/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.metrics;

import com.github.jknack.handlebars.Template;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.docs.commons.JavaSourceSearchHelper;
import io.micrometer.docs.commons.templates.HandlebarsUtils;
import io.micrometer.docs.metrics.MetricEntry;
import io.micrometer.docs.metrics.MetricSearchingFileVisitor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class MetricsDocGenerator {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MetricsDocGenerator.class);
    private final File projectRoot;
    private final Pattern inclusionPattern;
    private final String templateLocation;
    private final Path output;

    public MetricsDocGenerator(File projectRoot, Pattern inclusionPattern, String templateLocation, Path output) {
        this.projectRoot = projectRoot;
        this.inclusionPattern = inclusionPattern;
        this.templateLocation = templateLocation;
        this.output = output;
    }

    public void generate() {
        Path path = this.projectRoot.toPath();
        logger.debug("Path is [" + this.projectRoot.getAbsolutePath() + "]. Inclusion pattern is [" + this.inclusionPattern + "]");
        JavaSourceSearchHelper searchHelper = JavaSourceSearchHelper.create(this.projectRoot.toPath(), this.inclusionPattern);
        TreeSet<MetricEntry> entries = new TreeSet<MetricEntry>();
        MetricSearchingFileVisitor fv = new MetricSearchingFileVisitor(this.inclusionPattern, entries, searchHelper);
        try {
            Files.walkFileTree(path, fv);
            this.printMetricsAdoc(entries);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void printMetricsAdoc(Collection<MetricEntry> entries) throws IOException {
        Template template = HandlebarsUtils.createTemplate(this.templateLocation);
        HashMap<String, Collection<MetricEntry>> map = new HashMap<String, Collection<MetricEntry>>();
        map.put("entries", entries);
        String result = template.apply(map);
        Files.write(this.output, result.getBytes(), new OpenOption[0]);
    }
}

