/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.PredicateVisitor;
import io.micronaut.data.model.jpa.criteria.impl.expression.IdExpression;
import io.micronaut.data.model.jpa.criteria.impl.predicate.BetweenPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.BinaryPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.InPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.PredicateBinaryOp;
import io.micronaut.data.model.jpa.criteria.impl.predicate.UnaryPredicate;
import jakarta.persistence.criteria.Expression;
import java.util.Collection;

@Internal
public interface AdvancedPredicateVisitor<P>
extends PredicateVisitor {
    public P getRequiredProperty(PersistentPropertyPath<?> var1);

    @Override
    default public void visit(UnaryPredicate unaryPredicate) {
        Expression<?> expression = unaryPredicate.getExpression();
        switch (unaryPredicate.getOp()) {
            case IS_NULL: {
                this.visitIsNull(expression);
                break;
            }
            case IS_NON_NULL: {
                this.visitIsNotNull(expression);
                break;
            }
            case IS_TRUE: {
                this.visitIsTrue(expression);
                break;
            }
            case IS_FALSE: {
                this.visitIsFalse(expression);
                break;
            }
            case IS_EMPTY: {
                this.visitIsEmpty(expression);
                break;
            }
            case IS_NOT_EMPTY: {
                this.visitIsNotEmpty(expression);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported property operation: " + unaryPredicate.getOp());
            }
        }
    }

    @Override
    default public void visit(BetweenPredicate betweenPredicate) {
        this.visitInBetween(betweenPredicate.getValue(), betweenPredicate.getFrom(), betweenPredicate.getTo());
    }

    @Override
    default public void visit(BinaryPredicate binaryPredicate) {
        this.appendPredicate(binaryPredicate.getOp(), binaryPredicate.getLeftExpression(), binaryPredicate.getRightExpression());
    }

    public void visitIdEquals(Expression<?> var1);

    default public void appendPredicate(PredicateBinaryOp op, Expression<?> leftExpression, Expression<?> rightExpression) {
        switch (op) {
            case EQUALS: {
                if (leftExpression instanceof IdExpression) {
                    this.visitIdEquals(rightExpression);
                    break;
                }
                this.visitEquals(leftExpression, rightExpression, false);
                break;
            }
            case NOT_EQUALS: {
                this.visitNotEquals(leftExpression, rightExpression, false);
                break;
            }
            case EQUALS_IGNORE_CASE: {
                this.visitEquals(leftExpression, rightExpression, true);
                break;
            }
            case NOT_EQUALS_IGNORE_CASE: {
                this.visitNotEquals(leftExpression, rightExpression, true);
                break;
            }
            case GREATER_THAN: {
                this.visitGreaterThan(leftExpression, rightExpression);
                break;
            }
            case GREATER_THAN_OR_EQUALS: {
                this.visitGreaterThanOrEquals(leftExpression, rightExpression);
                break;
            }
            case LESS_THAN: {
                this.visitLessThan(leftExpression, rightExpression);
                break;
            }
            case LESS_THAN_OR_EQUALS: {
                this.visitLessThanOrEquals(leftExpression, rightExpression);
                break;
            }
            case STARTS_WITH: {
                this.visitStartsWith(leftExpression, rightExpression, false);
                break;
            }
            case STARTS_WITH_IGNORE_CASE: {
                this.visitStartsWith(leftExpression, rightExpression, true);
                break;
            }
            case REGEX: {
                this.visitRegexp(leftExpression, rightExpression);
                break;
            }
            case ARRAY_CONTAINS: {
                this.visitArrayContains(leftExpression, rightExpression);
                break;
            }
            case CONTAINS: {
                this.visitContains(leftExpression, rightExpression, false);
                break;
            }
            case CONTAINS_IGNORE_CASE: {
                this.visitContains(leftExpression, rightExpression, true);
                break;
            }
            case ENDS_WITH: {
                this.visitEndsWith(leftExpression, rightExpression, false);
                break;
            }
            case ENDS_WITH_IGNORE_CASE: {
                this.visitEndsWith(leftExpression, rightExpression, true);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported operation: " + op);
            }
        }
    }

    public void visitContains(Expression<?> var1, Expression<?> var2, boolean var3);

    public void visitEndsWith(Expression<?> var1, Expression<?> var2, boolean var3);

    default public void visitRegexp(Expression<?> leftExpression, Expression<?> expression) {
        throw new UnsupportedOperationException("Regexp is not supported by this implementation.");
    }

    default public void visitArrayContains(Expression<?> leftExpression, Expression<?> expression) {
        throw new UnsupportedOperationException("ArrayContains is not supported by this implementation.");
    }

    public void visitStartsWith(Expression<?> var1, Expression<?> var2, boolean var3);

    public void visitEquals(Expression<?> var1, Expression<?> var2, boolean var3);

    public void visitNotEquals(Expression<?> var1, Expression<?> var2, boolean var3);

    public void visitGreaterThan(Expression<?> var1, Expression<?> var2);

    public void visitGreaterThanOrEquals(Expression<?> var1, Expression<?> var2);

    public void visitLessThan(Expression<?> var1, Expression<?> var2);

    public void visitLessThanOrEquals(Expression<?> var1, Expression<?> var2);

    public void visitInBetween(Expression<?> var1, Expression<?> var2, Expression<?> var3);

    public void visitIsFalse(Expression<?> var1);

    public void visitIsNotNull(Expression<?> var1);

    public void visitIsNull(Expression<?> var1);

    public void visitIsTrue(Expression<?> var1);

    public void visitIsEmpty(Expression<?> var1);

    public void visitIsNotEmpty(Expression<?> var1);

    @Override
    default public void visit(InPredicate<?> inPredicate) {
        this.visitIn(inPredicate.getExpression(), inPredicate.getValues(), false);
    }

    public void visitIn(Expression<?> var1, Collection<?> var2, boolean var3);
}

