/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.string;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.nio.charset.Charset;

@ChannelHandler.Sharable
public class StringEncoder
extends MessageToMessageEncoder<String, ByteBuf> {
    private final Charset charset;

    public StringEncoder() {
        this(Charset.defaultCharset());
    }

    public StringEncoder(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.charset = charset;
    }

    @Override
    public boolean isEncodable(Object msg) throws Exception {
        return msg instanceof String;
    }

    @Override
    public ByteBuf encode(ChannelHandlerContext ctx, String msg) throws Exception {
        return Unpooled.copiedBuffer((CharSequence)msg, (Charset)this.charset);
    }
}

