/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.IoEventLoop;
import io.netty.channel.IoEventLoopGroup;
import io.netty.channel.IoExecutionContext;
import io.netty.channel.IoHandle;
import io.netty.channel.IoHandler;
import io.netty.channel.IoRegistration;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SystemPropertyUtil;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;

public class SingleThreadIoEventLoop
extends SingleThreadEventLoop
implements IoEventLoop {
    protected static final int DEFAULT_MAX_TASKS_PER_RUN = Math.max(1, SystemPropertyUtil.getInt((String)"io.netty.eventLoop.maxTaskPerRun", (int)4096));
    private final int maxTasksPerRun = DEFAULT_MAX_TASKS_PER_RUN;
    private final IoExecutionContext context = new IoExecutionContext(){

        @Override
        public boolean canBlock() {
            assert (SingleThreadIoEventLoop.this.inEventLoop());
            return !SingleThreadIoEventLoop.this.hasTasks() && !SingleThreadIoEventLoop.this.hasScheduledTasks();
        }

        @Override
        public long delayNanos(long currentTimeNanos) {
            assert (SingleThreadIoEventLoop.this.inEventLoop());
            return SingleThreadIoEventLoop.this.delayNanos(currentTimeNanos);
        }

        @Override
        public long deadlineNanos() {
            assert (SingleThreadIoEventLoop.this.inEventLoop());
            return SingleThreadIoEventLoop.this.deadlineNanos();
        }
    };
    private final IoHandler ioHandler;

    public SingleThreadIoEventLoop(IoEventLoopGroup parent, ThreadFactory threadFactory, IoHandler ioHandler) {
        super((EventLoopGroup)parent, threadFactory, false);
        this.ioHandler = (IoHandler)ObjectUtil.checkNotNull((Object)ioHandler, (String)"ioHandler");
    }

    public SingleThreadIoEventLoop(IoEventLoopGroup parent, Executor executor, IoHandler ioHandler) {
        super((EventLoopGroup)parent, executor, false);
        this.ioHandler = (IoHandler)ObjectUtil.checkNotNull((Object)ioHandler, (String)"ioHandler");
    }

    public SingleThreadIoEventLoop(IoEventLoopGroup parent, ThreadFactory threadFactory, IoHandler ioHandler, int maxPendingTasks, RejectedExecutionHandler rejectedExecutionHandler) {
        super((EventLoopGroup)parent, threadFactory, false, maxPendingTasks, rejectedExecutionHandler);
        this.ioHandler = (IoHandler)ObjectUtil.checkNotNull((Object)ioHandler, (String)"ioHandler");
    }

    public SingleThreadIoEventLoop(IoEventLoopGroup parent, Executor executor, IoHandler ioHandler, int maxPendingTasks, RejectedExecutionHandler rejectedExecutionHandler) {
        super((EventLoopGroup)parent, executor, false, maxPendingTasks, rejectedExecutionHandler);
        this.ioHandler = (IoHandler)ObjectUtil.checkNotNull((Object)ioHandler, (String)"ioHandler");
    }

    protected SingleThreadIoEventLoop(IoEventLoopGroup parent, Executor executor, IoHandler ioHandler, Queue<Runnable> taskQueue, Queue<Runnable> tailTaskQueue, RejectedExecutionHandler rejectedExecutionHandler) {
        super(parent, executor, false, taskQueue, tailTaskQueue, rejectedExecutionHandler);
        this.ioHandler = (IoHandler)ObjectUtil.checkNotNull((Object)ioHandler, (String)"ioHandler");
    }

    protected void run() {
        assert (this.inEventLoop());
        do {
            this.runIo();
            if (this.isShuttingDown()) {
                this.ioHandler.prepareToDestroy();
            }
            this.runAllTasks(this.maxTasksPerRun);
        } while (!this.confirmShutdown());
    }

    protected final IoHandler ioHandler() {
        return this.ioHandler;
    }

    protected int runIo() {
        assert (this.inEventLoop());
        return this.ioHandler.run(this.context);
    }

    @Override
    public IoEventLoop next() {
        return this;
    }

    @Override
    public final Future<IoRegistration> register(IoHandle handle) {
        Promise promise = this.newPromise();
        if (this.inEventLoop()) {
            this.registerForIo0(handle, (Promise<IoRegistration>)promise);
        } else {
            this.execute(() -> this.registerForIo0(handle, (Promise<IoRegistration>)promise));
        }
        return promise;
    }

    private void registerForIo0(IoHandle handle, Promise<IoRegistration> promise) {
        IoRegistration registration;
        assert (this.inEventLoop());
        try {
            registration = this.ioHandler.register(this, handle);
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            return;
        }
        promise.setSuccess((Object)registration);
    }

    protected final void wakeup(boolean inEventLoop) {
        this.ioHandler.wakeup(this);
    }

    protected final void cleanup() {
        assert (this.inEventLoop());
        this.ioHandler.destroy();
    }

    @Override
    public boolean isCompatible(Class<? extends IoHandle> handleType) {
        return this.ioHandler.isCompatible(handleType);
    }

    @Override
    public boolean isIoType(Class<? extends IoHandler> handlerType) {
        return this.ioHandler.getClass().equals(handlerType);
    }
}

