/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.server;

import io.openliberty.tools.ant.ServerTask;
import io.openliberty.tools.common.plugins.config.ServerConfigXmlDocument;
import io.openliberty.tools.maven.BasicSupport;
import io.openliberty.tools.maven.ServerFeatureSupport;
import io.openliberty.tools.maven.applications.LooseWarApplication;
import io.openliberty.tools.maven.server.CopyDependencies;
import io.openliberty.tools.maven.server.Dependency;
import io.openliberty.tools.maven.server.DependencyGroup;
import io.openliberty.tools.maven.utils.ExecuteMojoUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public abstract class StartDebugMojoSupport
extends ServerFeatureSupport {
    private static final String LIBERTY_MAVEN_PLUGIN_GROUP_ID = "io.openliberty.tools";
    private static final String LIBERTY_MAVEN_PLUGIN_ARTIFACT_ID = "liberty-maven-plugin";
    protected static final String HEADER = "# Generated by liberty-maven-plugin";
    private static final String LIBERTY_CONFIG_MAVEN_PROPS = "(^liberty\\.(env|jvm|bootstrap|var|defaultVar)\\.).+";
    private static final Pattern pattern = Pattern.compile("(^liberty\\.(env|jvm|bootstrap|var|defaultVar)\\.).+");
    private static final String LATE_PROP_RESOLUTION_SYNTAX = "@\\{(.+?)\\}";
    private static final Pattern LATE_PROP_PATTERN = Pattern.compile("@\\{(.+?)\\}");
    private boolean configFilesCopied = false;
    protected final String PLUGIN_VARIABLE_CONFIG_OVERRIDES_XML = "configDropins/overrides/liberty-plugin-variable-config.xml";
    protected final String PLUGIN_VARIABLE_CONFIG_DEFAULTS_XML = "configDropins/defaults/liberty-plugin-variable-config.xml";
    protected Map<String, String> bootstrapMavenProps = new HashMap<String, String>();
    protected Map<String, String> envMavenProps = new HashMap<String, String>();
    protected List<String> jvmMavenPropNames = new ArrayList<String>();
    protected List<String> jvmMavenPropValues = new ArrayList<String>();
    protected Map<String, String> varMavenProps = new HashMap<String, String>();
    protected Map<String, String> defaultVarMavenProps = new HashMap<String, String>();
    protected Map<String, String> combinedBootstrapProperties = null;
    protected List<String> combinedJvmOptions = null;
    protected Map<String, String> bootstrapPropertiesResolved = null;
    protected List<String> jvmOptionsResolved = null;
    @Component
    protected BuildPluginManager pluginManager;
    @Parameter
    protected CopyDependencies copyDependencies;
    @Parameter(property="bootstrapPropertiesFile")
    protected File bootstrapPropertiesFile;
    @Parameter
    protected Map<String, String> bootstrapProperties;
    @Parameter(property="jvmOptionsFile")
    protected File jvmOptionsFile;
    @Parameter
    protected List<String> jvmOptions;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor plugin;

    protected ServerTask initializeJava() {
        ServerTask serverTask = (ServerTask)this.ant.createTask("antlib:io/openliberty/tools/ant:server");
        if (serverTask == null) {
            throw new IllegalStateException(MessageFormat.format(messages.getString("error.dependencies.not.found"), "server"));
        }
        serverTask.setInstallDir(this.installDirectory);
        serverTask.setServerName(this.serverName);
        serverTask.setUserDir(this.userDirectory);
        serverTask.setOutputDir(this.outputDirectory);
        return serverTask;
    }

    protected void runMojo(String groupId, String artifactId, String goal) throws MojoExecutionException {
        Plugin plugin = this.getPlugin(groupId, artifactId);
        Xpp3Dom config = ExecuteMojoUtil.getPluginGoalConfig(plugin, goal, this.getLog());
        this.getLog().info((CharSequence)("Running " + artifactId + ":" + goal));
        this.getLog().debug((CharSequence)("configuration:\n" + config));
        MojoExecutor.executeMojo((Plugin)plugin, (String)MojoExecutor.goal((String)goal), (Xpp3Dom)config, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    protected void runExplodedMojo() throws MojoExecutionException {
        Plugin warPlugin = this.getPlugin("org.apache.maven.plugins", "maven-war-plugin");
        Xpp3Dom explodedConfig = ExecuteMojoUtil.getPluginGoalConfig(warPlugin, "exploded", this.getLog());
        if (explodedConfig.getChild("outdatedCheckPath") == null) {
            if (this.validatePluginVersion(warPlugin.getVersion(), "3.3.2")) {
                explodedConfig.addChild(MojoExecutor.element((String)MojoExecutor.name((String)"outdatedCheckPath"), (String)"/").toDom());
            } else if (this.validatePluginVersion(warPlugin.getVersion(), "3.3.1")) {
                explodedConfig.addChild(MojoExecutor.element((String)MojoExecutor.name((String)"outdatedCheckPath"), (String)"WEB-INF").toDom());
            }
        }
        this.getLog().info((CharSequence)"Running maven-war-plugin:exploded");
        this.getLog().debug((CharSequence)("configuration:\n" + explodedConfig));
        this.session.getRequest().setStartTime(new Date());
        MojoExecutor.executeMojo((Plugin)warPlugin, (String)MojoExecutor.goal((String)"exploded"), (Xpp3Dom)explodedConfig, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    protected void runMojoForProject(String groupId, String artifactId, String goal, MavenProject project) throws MojoExecutionException {
        Plugin plugin = this.getPluginForProject(groupId, artifactId, project);
        Xpp3Dom config = ExecuteMojoUtil.getPluginGoalConfig(plugin, goal, this.getLog());
        this.getLog().info((CharSequence)("Running " + artifactId + ":" + goal + " on " + project.getFile()));
        this.getLog().debug((CharSequence)("configuration:\n" + config));
        MavenSession tempSession = this.session.clone();
        tempSession.setCurrentProject(project);
        MojoExecutor.executeMojo((Plugin)plugin, (String)MojoExecutor.goal((String)goal), (Xpp3Dom)config, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)project, (MavenSession)tempSession, (BuildPluginManager)this.pluginManager));
    }

    protected boolean validatePluginVersion(String version, String minVersion) {
        ComparableVersion ver = new ComparableVersion(version);
        ComparableVersion minVer = new ComparableVersion(minVersion);
        return ver.compareTo(minVer) >= 0;
    }

    protected Plugin getPlugin(String groupId, String artifactId) {
        return this.getPluginForProject(groupId, artifactId, this.project);
    }

    protected Plugin getPluginForProject(String groupId, String artifactId, MavenProject currentProject) {
        Plugin plugin = currentProject.getPlugin(groupId + ":" + artifactId);
        if (plugin == null) {
            plugin = this.getPluginFromPluginManagement(groupId, artifactId, currentProject);
        }
        if (plugin == null) {
            plugin = MojoExecutor.plugin((String)MojoExecutor.groupId((String)groupId), (String)MojoExecutor.artifactId((String)artifactId), (String)MojoExecutor.version((String)"RELEASE"));
        }
        return plugin;
    }

    protected Plugin getLibertyPlugin() {
        return this.getLibertyPluginForProject(this.project);
    }

    protected Plugin getLibertyPluginForProject(MavenProject currentProject) {
        Plugin projectPlugin;
        String version = null;
        if (this.plugin != null && this.plugin.getPlugin() != null) {
            version = this.plugin.getVersion();
            this.getLog().debug((CharSequence)("Setting plugin version to " + version));
        }
        if ((projectPlugin = currentProject.getPlugin("io.openliberty.tools:liberty-maven-plugin")) == null) {
            this.getLog().debug((CharSequence)("Did not find liberty-maven-plugin configured in currentProject: " + currentProject.toString()));
            projectPlugin = this.getPluginFromPluginManagement(LIBERTY_MAVEN_PLUGIN_GROUP_ID, LIBERTY_MAVEN_PLUGIN_ARTIFACT_ID, currentProject);
        } else {
            this.getLog().debug((CharSequence)("Found liberty-maven-plugin configured in currentProject: " + currentProject.toString()));
        }
        if (projectPlugin == null) {
            this.getLog().debug((CharSequence)("Did not find liberty-maven-plugin in pluginManagement in currentProject: " + currentProject.toString()));
            projectPlugin = MojoExecutor.plugin((String)LIBERTY_MAVEN_PLUGIN_GROUP_ID, (String)LIBERTY_MAVEN_PLUGIN_ARTIFACT_ID, (String)"LATEST");
        }
        if (version != null) {
            projectPlugin.setVersion(version);
        }
        return projectPlugin;
    }

    protected Plugin getPluginFromPluginManagement(String groupId, String artifactId, MavenProject currentProject) {
        Plugin retVal = null;
        PluginManagement pm = currentProject.getPluginManagement();
        if (pm != null) {
            for (Plugin p : pm.getPlugins()) {
                if (!groupId.equals(p.getGroupId()) || !artifactId.equals(p.getArtifactId())) continue;
                retVal = p;
                break;
            }
        }
        return retVal;
    }

    protected void runLibertyMojoCreate() throws MojoExecutionException {
        Xpp3Dom config = ExecuteMojoUtil.getPluginGoalConfig(this.getLibertyPlugin(), "create", this.getLog());
        this.runLibertyMojo("create", config);
    }

    protected void runLibertyMojoDeploy() throws MojoExecutionException {
        this.runLibertyMojoDeploy(true);
    }

    protected void runLibertyMojoDeploy(boolean forceLooseApp) throws MojoExecutionException {
        Xpp3Dom looseApp;
        Xpp3Dom config = ExecuteMojoUtil.getPluginGoalConfig(this.getLibertyPlugin(), "deploy", this.getLog());
        if (forceLooseApp && (looseApp = config.getChild("looseApplication")) != null && "false".equals(looseApp.getValue())) {
            this.getLog().warn((CharSequence)"Overriding liberty plugin parameter, \"looseApplication\" to \"true\" and deploying application in looseApplication format");
            looseApp.setValue("true");
        }
        if (this.project.getPackaging().equals("war") && LooseWarApplication.isExploded(this.project)) {
            this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "resources");
        }
        this.runLibertyMojo("deploy", config);
    }

    protected void runLibertyMojoInstallFeature(MojoExecutor.Element features, File serverDir, String containerName) throws MojoExecutionException {
        Xpp3Dom config = ExecuteMojoUtil.getPluginGoalConfig(this.getLibertyPlugin(), "install-feature", this.getLog());
        if (features != null) {
            config = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{features}), (Xpp3Dom)config);
        }
        if (containerName != null) {
            config.addChild(MojoExecutor.element((String)MojoExecutor.name((String)"containerName"), (String)containerName).toDom());
        }
        if (serverDir != null && serverDir.exists()) {
            try {
                config.addChild(MojoExecutor.element((String)MojoExecutor.name((String)"serverDir"), (String)serverDir.getCanonicalPath()).toDom());
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Unable to pass 'serverDir' configuration parameter to liberty:install-feature: " + serverDir));
            }
        }
        this.runLibertyMojo("install-feature", config);
    }

    protected void runLibertyMojoGenerateFeatures(MojoExecutor.Element classFiles, boolean optimize) throws MojoExecutionException {
        Xpp3Dom config = ExecuteMojoUtil.getPluginGoalConfig(this.getLibertyPlugin(), "generate-features", this.getLog());
        if (classFiles != null) {
            config = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{classFiles}), (Xpp3Dom)config);
        }
        config.addChild(MojoExecutor.element((String)MojoExecutor.name((String)"optimize"), (String)Boolean.toString(optimize)).toDom());
        this.runLibertyMojo("generate-features", config);
    }

    private void runLibertyMojo(String goal, Xpp3Dom config) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Running liberty:" + goal));
        this.getLog().debug((CharSequence)("configuration:\n" + config));
        this.getLog().debug((CharSequence)("project:\n" + this.project));
        MavenSession tempSession = this.session.clone();
        tempSession.setCurrentProject(this.project);
        MojoExecutor.executeMojo((Plugin)this.getLibertyPlugin(), (String)MojoExecutor.goal((String)goal), (Xpp3Dom)config, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)tempSession, (BuildPluginManager)this.pluginManager));
    }

    private void copyDependencies() throws MojoExecutionException, IOException {
        if (this.copyDependencies != null) {
            List<Dependency> deps = this.copyDependencies.getDependencies();
            boolean defaultStripVersion = this.copyDependencies.isStripVersion();
            String defaultLocation = this.copyDependencies.getLocation();
            File dftLocationFile = new File(defaultLocation);
            if (!dftLocationFile.isAbsolute()) {
                dftLocationFile = new File(this.serverDirectory, defaultLocation);
            }
            if (!dftLocationFile.exists()) {
                dftLocationFile.mkdirs();
            } else if (!dftLocationFile.isDirectory()) {
                throw new MojoExecutionException("The copyDependencies location " + dftLocationFile.getCanonicalPath() + " is not a directory.");
            }
            String dftLocationPath = dftLocationFile.getCanonicalPath();
            if (!deps.isEmpty()) {
                this.getLog().debug((CharSequence)("copyDependencies to location: " + dftLocationPath));
            }
            for (Dependency dep : deps) {
                this.copyDependencies(dep, null, dftLocationPath, defaultStripVersion);
            }
            List<DependencyGroup> depGroups = this.copyDependencies.getDependencyGroups();
            for (DependencyGroup depGroup : depGroups) {
                String overrideLocation = depGroup.getLocation();
                if (overrideLocation != null) {
                    this.getLog().debug((CharSequence)("copyDependencies to location: " + overrideLocation));
                } else {
                    this.getLog().debug((CharSequence)("copyDependencies to location: " + dftLocationPath));
                }
                boolean stripVersion = defaultStripVersion;
                Boolean overrideStripVersion = depGroup.getStripVersion();
                if (overrideStripVersion != null) {
                    stripVersion = overrideStripVersion;
                }
                List<Dependency> groupDeps = depGroup.getDependencies();
                for (Dependency dep : groupDeps) {
                    this.copyDependencies(dep, overrideLocation, dftLocationPath, stripVersion);
                }
            }
        }
    }

    private void copyDependencies(Dependency dep, String overrideLocation, String defaultLocation, boolean stripVersion) throws MojoExecutionException, IOException {
        Set<Artifact> artifactsToCopy;
        String location = defaultLocation;
        if (overrideLocation != null) {
            File overrideLocationFile = new File(overrideLocation);
            if (!overrideLocationFile.isAbsolute()) {
                overrideLocationFile = new File(this.serverDirectory, overrideLocation);
            }
            location = overrideLocationFile.getCanonicalPath();
            if (!overrideLocationFile.exists()) {
                overrideLocationFile.mkdirs();
            } else if (!overrideLocationFile.isDirectory()) {
                this.getLog().warn((CharSequence)("The specified dependency location " + overrideLocationFile.getCanonicalPath() + " is not a directory. Using default copyDependencies location " + defaultLocation + " instead."));
                location = defaultLocation;
            }
        }
        if ((artifactsToCopy = this.getResolvedDependencyWithTransitiveDependencies(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getType(), dep.getClassifier())).isEmpty()) {
            String version;
            StringBuilder sb = new StringBuilder();
            sb.append("copyDependencies failed for dependency with groupId " + dep.getGroupId());
            String artifactId = dep.getArtifactId();
            if (artifactId != null) {
                sb.append(", artifactId " + artifactId);
            }
            if ((version = dep.getVersion()) != null) {
                sb.append(", version " + version);
            }
            sb.append(" and type " + dep.getType());
            sb.append(". No matching resolved dependencies were found.");
            this.getLog().warn((CharSequence)sb.toString());
        } else {
            for (Artifact nextArtifact : artifactsToCopy) {
                File nextFile = nextArtifact.getFile();
                String targetFileName = nextFile.getName();
                if (stripVersion) {
                    targetFileName = this.stripVersionFromName(targetFileName, nextArtifact.getVersion());
                }
                File fileToCopyTo = new File(location, targetFileName);
                Copy copy = (Copy)this.ant.createTask("copy");
                copy.setFile(nextFile);
                copy.setTofile(fileToCopyTo);
                copy.setOverwrite(true);
                copy.execute();
                this.getLog().info((CharSequence)("copyDependencies copied file " + nextFile.getName() + " to location " + location + "/" + targetFileName + "."));
            }
        }
    }

    protected void copyConfigFiles() throws IOException, MojoExecutionException {
        File optionsFile;
        String jvmOptionsPath = null;
        String bootStrapPropertiesPath = null;
        String serverEnvPath = null;
        String serverXMLPath = null;
        this.loadLibertyConfigFromProperties();
        if (this.configDirectory != null && this.configDirectory.exists()) {
            File configDirBootstrapFile;
            File configDirJvmOptionsFile;
            Copy copydir = (Copy)this.ant.createTask("copy");
            FileSet fileset = new FileSet();
            fileset.setDir(this.configDirectory);
            File configDirServerEnv = new File(this.configDirectory, "server.env");
            if (this.mergeServerEnv && configDirServerEnv.exists()) {
                fileset.setExcludes("server.env");
            }
            copydir.addFileset(fileset);
            copydir.setTodir(this.serverDirectory);
            copydir.setOverwrite(true);
            copydir.execute();
            File configDirServerXML = new File(this.configDirectory, "server.xml");
            if (configDirServerXML.exists()) {
                serverXMLPath = configDirServerXML.getCanonicalPath();
            }
            if ((configDirJvmOptionsFile = new File(this.configDirectory, "jvm.options")).exists()) {
                jvmOptionsPath = configDirJvmOptionsFile.getCanonicalPath();
            }
            if ((configDirBootstrapFile = new File(this.configDirectory, "bootstrap.properties")).exists()) {
                bootStrapPropertiesPath = configDirBootstrapFile.getCanonicalPath();
            }
            if (configDirServerEnv.exists()) {
                serverEnvPath = configDirServerEnv.getCanonicalPath();
            }
        }
        if (this.serverXmlFile != null && this.serverXmlFile.exists()) {
            if (serverXMLPath != null && !this.serverXmlFile.getCanonicalPath().equals(serverXMLPath)) {
                this.getLog().info((CharSequence)("The " + serverXMLPath + " file is overwritten by the " + this.serverXmlFile.getCanonicalPath() + " file."));
            }
            Copy copy = (Copy)this.ant.createTask("copy");
            copy.setFile(this.serverXmlFile);
            copy.setTofile(new File(this.serverDirectory, "server.xml"));
            copy.setOverwrite(true);
            copy.execute();
            serverXMLPath = this.serverXmlFile.getCanonicalPath();
        }
        if ((optionsFile = new File(this.serverDirectory, "jvm.options")).exists() && jvmOptionsPath == null && this.installType != BasicSupport.InstallType.ALREADY_EXISTS) {
            this.getLog().info((CharSequence)(optionsFile.getCanonicalPath() + " file deleted before processing plugin configuration."));
            optionsFile.delete();
        }
        if (this.jvmOptions != null || !this.jvmMavenPropValues.isEmpty()) {
            if (jvmOptionsPath != null) {
                this.getLog().info((CharSequence)("The " + jvmOptionsPath + " file is overwritten by inlined configuration."));
            }
            this.jvmOptionsResolved = this.handleLatePropertyResolution(this.jvmOptions);
            this.writeJvmOptions(optionsFile, this.jvmOptionsResolved, this.jvmMavenPropValues);
            jvmOptionsPath = "inlined configuration";
        } else if (this.jvmOptionsFile != null && this.jvmOptionsFile.exists()) {
            if (jvmOptionsPath != null) {
                this.getLog().info((CharSequence)("The " + jvmOptionsPath + " file is overwritten by the " + this.jvmOptionsFile.getCanonicalPath() + " file."));
            }
            Copy copy = (Copy)this.ant.createTask("copy");
            copy.setFile(this.jvmOptionsFile);
            copy.setTofile(optionsFile);
            copy.setOverwrite(true);
            copy.execute();
            jvmOptionsPath = this.jvmOptionsFile.getCanonicalPath();
        }
        File bootstrapFile = new File(this.serverDirectory, "bootstrap.properties");
        if (bootstrapFile.exists() && bootStrapPropertiesPath == null && this.installType != BasicSupport.InstallType.ALREADY_EXISTS) {
            this.getLog().info((CharSequence)(bootstrapFile.getCanonicalPath() + " file deleted before processing plugin configuration."));
            bootstrapFile.delete();
        }
        if (this.bootstrapProperties != null || !this.bootstrapMavenProps.isEmpty()) {
            if (bootStrapPropertiesPath != null) {
                this.getLog().info((CharSequence)("The " + bootStrapPropertiesPath + " file is overwritten by inlined configuration."));
            }
            this.bootstrapPropertiesResolved = this.handleLatePropertyResolution(this.bootstrapProperties);
            this.writeBootstrapProperties(bootstrapFile, this.bootstrapPropertiesResolved, this.bootstrapMavenProps);
            bootStrapPropertiesPath = "inlined configuration";
        } else if (this.bootstrapPropertiesFile != null && this.bootstrapPropertiesFile.exists()) {
            if (bootStrapPropertiesPath != null) {
                this.getLog().info((CharSequence)("The " + bootStrapPropertiesPath + " file is overwritten by the " + this.bootstrapPropertiesFile.getCanonicalPath() + " file."));
            }
            Copy copy = (Copy)this.ant.createTask("copy");
            copy.setFile(this.bootstrapPropertiesFile);
            copy.setTofile(bootstrapFile);
            copy.setOverwrite(true);
            copy.execute();
            bootStrapPropertiesPath = this.bootstrapPropertiesFile.getCanonicalPath();
        }
        File envFile = new File(this.serverDirectory, "server.env");
        if (this.mergeServerEnv) {
            serverEnvPath = this.mergeServerEnvFileAndEnvMavenProps(serverEnvPath);
        } else if (!this.envMavenProps.isEmpty()) {
            Map<String, String> envPropsToWrite = this.envMavenProps;
            if (this.serverEnvFile == null && serverEnvPath == null) {
                envPropsToWrite = this.mergeSpecialPropsFromInstallServerEnvIfAbsent(this.envMavenProps);
            } else if (serverEnvPath != null) {
                this.getLog().info((CharSequence)("The " + serverEnvPath + " file is overwritten by inlined configuration."));
            }
            this.writeServerEnvProperties(envFile, envPropsToWrite);
            serverEnvPath = "inlined configuration";
        } else if (this.serverEnvFile != null && this.serverEnvFile.exists()) {
            Copy copy = (Copy)this.ant.createTask("copy");
            copy.setFile(this.serverEnvFile);
            copy.setTofile(envFile);
            copy.setOverwrite(true);
            copy.execute();
            serverEnvPath = this.serverEnvFile.getCanonicalPath();
        }
        File pluginVariableConfig = new File(this.serverDirectory, "configDropins/overrides/liberty-plugin-variable-config.xml");
        if (pluginVariableConfig.exists()) {
            this.getLog().debug((CharSequence)(pluginVariableConfig.getCanonicalPath() + " file deleted before processing plugin configuration."));
            pluginVariableConfig.delete();
        }
        if (!this.varMavenProps.isEmpty()) {
            this.writeConfigDropinsServerVariables(pluginVariableConfig, this.varMavenProps, false);
        }
        if ((pluginVariableConfig = new File(this.serverDirectory, "configDropins/defaults/liberty-plugin-variable-config.xml")).exists()) {
            this.getLog().debug((CharSequence)(pluginVariableConfig.getCanonicalPath() + " file deleted before processing plugin configuration."));
            pluginVariableConfig.delete();
        }
        if (!this.defaultVarMavenProps.isEmpty()) {
            this.writeConfigDropinsServerVariables(pluginVariableConfig, this.defaultVarMavenProps, true);
        }
        if (serverXMLPath != null && !serverXMLPath.isEmpty()) {
            this.getLog().info((CharSequence)MessageFormat.format(messages.getString("info.server.start.update.config"), "server.xml", serverXMLPath));
        }
        if (jvmOptionsPath != null && !jvmOptionsPath.isEmpty()) {
            this.getLog().info((CharSequence)MessageFormat.format(messages.getString("info.server.start.update.config"), "jvm.options", jvmOptionsPath));
        }
        if (bootStrapPropertiesPath != null && !bootStrapPropertiesPath.isEmpty()) {
            this.getLog().info((CharSequence)MessageFormat.format(messages.getString("info.server.start.update.config"), "bootstrap.properties", bootStrapPropertiesPath));
        }
        if (serverEnvPath != null && !serverEnvPath.isEmpty()) {
            this.getLog().info((CharSequence)MessageFormat.format(messages.getString("info.server.start.update.config"), "server.env", serverEnvPath));
        }
        this.configFilesCopied = true;
        this.copyDependencies();
    }

    private Map<String, String> mergeSpecialPropsFromInstallServerEnvIfAbsent(Map<String, String> envProps) throws IOException {
        String[] specialProps = new String[]{"keystore_password"};
        HashMap<String, String> mergedProps = new HashMap<String, String>(envProps);
        File serverEnv = new File(this.serverDirectory, "server.env");
        Map<String, String> serverEnvProps = this.convertServerEnvToProperties(serverEnv);
        for (String propertyName : specialProps) {
            if (!serverEnvProps.containsKey(propertyName)) continue;
            mergedProps.putIfAbsent(propertyName, serverEnvProps.get(propertyName));
        }
        return mergedProps;
    }

    private String mergeServerEnvFileAndEnvMavenProps(String serverEnvPath) throws IOException {
        boolean mergeRequired;
        String modifiedServerEnvPath = serverEnvPath;
        boolean bl = mergeRequired = serverEnvPath != null || this.serverEnvFile != null && this.serverEnvFile.exists() || !this.envMavenProps.isEmpty();
        if (mergeRequired) {
            File serverEnv = new File(this.serverDirectory, "server.env");
            Map<String, String> serverEnvProps = this.convertServerEnvToProperties(serverEnv);
            if (serverEnvPath != null) {
                File configDirServerEnv = new File(this.configDirectory, "server.env");
                Map<String, String> configDirServerEnvProps = this.convertServerEnvToProperties(configDirServerEnv);
                serverEnvProps.putAll(configDirServerEnvProps);
            }
            if (this.serverEnvFile != null && this.serverEnvFile.exists()) {
                Map<String, String> serverEnvFileProps = this.convertServerEnvToProperties(this.serverEnvFile);
                serverEnvProps.putAll(serverEnvFileProps);
            }
            if (!this.envMavenProps.isEmpty()) {
                serverEnvProps.putAll(this.envMavenProps);
            }
            this.writeServerEnvProperties(serverEnv, serverEnvProps);
            modifiedServerEnvPath = this.getMergedServerEnvPath(serverEnvPath);
        }
        return modifiedServerEnvPath;
    }

    private String getMergedServerEnvPath(String serverEnvPath) throws IOException {
        boolean configDirEnvMerged = serverEnvPath != null;
        boolean serverEnvFileMerged = this.serverEnvFile != null && this.serverEnvFile.exists();
        boolean inlineEnvPropsMerged = !this.envMavenProps.isEmpty();
        StringBuilder updatedServerEnvPath = new StringBuilder("merging");
        if (configDirEnvMerged) {
            updatedServerEnvPath.append(" configDir server.env " + serverEnvPath + ", ");
        }
        if (serverEnvFileMerged) {
            updatedServerEnvPath.append(" serverEnvFile " + this.serverEnvFile.getCanonicalPath() + ", ");
        }
        if (inlineEnvPropsMerged) {
            updatedServerEnvPath.append(" env properties, ");
        }
        int lastCommaIndex = updatedServerEnvPath.lastIndexOf(", ");
        if ((lastCommaIndex = (updatedServerEnvPath = updatedServerEnvPath.replace(lastCommaIndex, lastCommaIndex + 2, ".")).lastIndexOf(", ")) > 0) {
            updatedServerEnvPath = updatedServerEnvPath.replace(lastCommaIndex, lastCommaIndex + 2, "");
            updatedServerEnvPath = updatedServerEnvPath.insert(lastCommaIndex, " and");
        }
        return updatedServerEnvPath.toString();
    }

    private Map<String, String> convertServerEnvToProperties(File serverEnv) throws IOException {
        String line;
        HashMap<String, String> mavenProperties = new HashMap<String, String>();
        if (serverEnv == null || !serverEnv.exists()) {
            return mavenProperties;
        }
        BufferedReader bf = new BufferedReader(new FileReader(serverEnv));
        while ((line = bf.readLine()) != null) {
            String[] keyValue;
            if (line.startsWith("#") || (keyValue = line.split("=", 2)).length != 2) continue;
            String key = keyValue[0];
            String value = keyValue[1];
            mavenProperties.put(key, value);
        }
        bf.close();
        return mavenProperties;
    }

    private void loadLibertyConfigFromProperties() {
        this.loadLibertyConfigFromProperties(this.project.getProperties());
        this.loadLibertyConfigFromProperties(System.getProperties());
    }

    private void loadLibertyConfigFromProperties(Properties props) {
        Set<Map.Entry<Object, Object>> entries = props.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            String key = (String)entry.getKey();
            PropertyType propType = PropertyType.getPropertyType(key);
            if (propType == null) continue;
            String suffix = key.substring(propType.getPrefix().length());
            String value = (String)entry.getValue();
            value = this.resolveLatePropertyReferences(value);
            this.getLog().debug((CharSequence)("Processing Liberty configuration from property with key " + key + " and value " + value));
            switch (propType) {
                case ENV: {
                    this.envMavenProps.put(suffix, value);
                    break;
                }
                case BOOTSTRAP: {
                    this.bootstrapMavenProps.put(suffix, value);
                    break;
                }
                case JVM: {
                    if (this.jvmMavenPropNames.contains(suffix)) {
                        int index = this.jvmMavenPropNames.indexOf(suffix);
                        this.getLog().debug((CharSequence)("Remove duplicate property with name: " + suffix + " at position: " + index));
                        this.jvmMavenPropNames.remove(index);
                        this.jvmMavenPropValues.remove(index);
                    }
                    this.jvmMavenPropNames.add(suffix);
                    this.jvmMavenPropValues.add(value);
                    break;
                }
                case VAR: {
                    this.varMavenProps.put(suffix, value);
                    break;
                }
                case DEFAULTVAR: {
                    this.defaultVarMavenProps.put(suffix, value);
                }
            }
        }
    }

    private String resolveLatePropertyReferences(String value) {
        String returnValue = value;
        if (value != null) {
            Matcher m = LATE_PROP_PATTERN.matcher(value);
            while (m.find()) {
                String replacementValue;
                String varName = m.group(1);
                if (!this.project.getProperties().containsKey(varName) || (replacementValue = this.project.getProperties().getProperty(varName)) == null) continue;
                returnValue = returnValue.replace("@{" + varName + "}", replacementValue);
                this.getLog().debug((CharSequence)("Replaced Liberty configuration property value @{" + varName + "} with value " + replacementValue));
            }
        }
        return returnValue;
    }

    protected Map<String, String> handleLatePropertyResolution(Map<String, String> properties) {
        HashMap<String, String> propertiesResolved = null;
        if (properties != null) {
            propertiesResolved = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                String value = this.resolveLatePropertyReferences(entry.getValue());
                propertiesResolved.put(entry.getKey(), value);
            }
        }
        return propertiesResolved;
    }

    protected List<String> handleLatePropertyResolution(List<String> properties) {
        ArrayList<String> propertiesResolved = null;
        if (properties != null) {
            propertiesResolved = new ArrayList<String>();
            for (String nextOption : properties) {
                String value = this.resolveLatePropertyReferences(nextOption);
                propertiesResolved.add(value);
            }
        }
        return propertiesResolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBootstrapProperties(File file, Map<String, String> properties, Map<String, String> mavenProperties) throws IOException {
        if (!mavenProperties.isEmpty()) {
            if (properties == null) {
                this.combinedBootstrapProperties = mavenProperties;
            } else {
                this.combinedBootstrapProperties = new HashMap<String, String>();
                this.combinedBootstrapProperties.putAll(mavenProperties);
                this.combinedBootstrapProperties.putAll(properties);
            }
        } else {
            this.combinedBootstrapProperties = properties;
        }
        this.makeParentDirectory(file);
        try (PrintWriter writer = null;){
            writer = new PrintWriter(file, "UTF-8");
            writer.println(HEADER);
            for (Map.Entry<String, String> entry : this.combinedBootstrapProperties.entrySet()) {
                String key = entry.getKey();
                writer.print(key);
                writer.print("=");
                String value = entry.getValue();
                writer.println(value != null ? value.replace("\\", "/") : "");
                if (value != null) continue;
                this.getLog().warn((CharSequence)("The value of the bootstrap property " + key + " is null. Verify if the needed POM properties are set correctly."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeServerEnvProperties(File file, Map<String, String> mavenProperties) throws IOException {
        this.makeParentDirectory(file);
        try (PrintWriter writer = null;){
            writer = new PrintWriter(file, "UTF-8");
            writer.println(HEADER);
            for (Map.Entry<String, String> entry : mavenProperties.entrySet()) {
                String key = entry.getKey();
                writer.print(key);
                writer.print("=");
                String value = entry.getValue();
                writer.println(value != null ? value.replace("\\", "/") : "");
                if (value != null) continue;
                this.getLog().warn((CharSequence)("The value of the server.env property " + entry.getKey() + " is null. Verify if the needed POM properties are set correctly."));
            }
        }
    }

    protected List<String> getUniqueValues(List<String> values) {
        ArrayList<String> uniqueValues = new ArrayList<String>();
        if (values == null) {
            return uniqueValues;
        }
        for (String nextValue : values) {
            if (uniqueValues.contains(nextValue)) {
                this.getLog().debug((CharSequence)("Remove duplicate value: " + nextValue + " at position: " + uniqueValues.indexOf(nextValue)));
            }
            uniqueValues.remove(nextValue);
            uniqueValues.add(nextValue);
        }
        return uniqueValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJvmOptions(File file, List<String> options, List<String> mavenProperties) throws IOException {
        List<String> uniqueOptions = this.getUniqueValues(options);
        List<String> uniqueMavenProps = this.getUniqueValues(mavenProperties);
        if (!uniqueMavenProps.isEmpty()) {
            if (uniqueOptions.isEmpty()) {
                this.combinedJvmOptions = uniqueMavenProps;
            } else {
                this.combinedJvmOptions = new ArrayList<String>();
                this.combinedJvmOptions.addAll(uniqueMavenProps);
                this.combinedJvmOptions.removeAll(uniqueOptions);
                this.combinedJvmOptions.addAll(uniqueOptions);
            }
        } else {
            this.combinedJvmOptions = uniqueOptions;
        }
        this.makeParentDirectory(file);
        try (PrintWriter writer = null;){
            writer = new PrintWriter(file, "UTF-8");
            writer.println(HEADER);
            for (String option : this.combinedJvmOptions) {
                writer.println(option);
            }
        }
    }

    private void writeConfigDropinsServerVariables(File file, Map<String, String> props, boolean isDefaultVar) throws IOException, MojoExecutionException {
        try {
            ServerConfigXmlDocument configDocument = ServerConfigXmlDocument.newInstance();
            configDocument.createComment(HEADER);
            for (Map.Entry<String, String> entry : props.entrySet()) {
                configDocument.createVariableWithValue(entry.getKey(), entry.getValue(), isDefaultVar);
            }
            this.makeParentDirectory(file);
            configDocument.writeXMLDocument(file);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new MojoExecutionException("Error writing configDropins variable file " + file.getCanonicalPath(), e);
        }
    }

    private void makeParentDirectory(File file) {
        File parentDir = file.getParentFile();
        if (parentDir != null) {
            parentDir.mkdirs();
        }
    }

    public boolean isConfigCopied() {
        return this.configFilesCopied;
    }

    protected void getOrCreateEarArtifact(MavenProject earProject) {
        org.apache.maven.model.Dependency existingEarItem = this.createArtifactItem(earProject.getGroupId(), earProject.getArtifactId(), earProject.getPackaging(), earProject.getVersion());
        try {
            Artifact existingEarArtifact = this.getArtifact(existingEarItem);
            this.getLog().debug((CharSequence)("EAR artifact already exists at " + existingEarArtifact.getFile()));
        }
        catch (MojoExecutionException e) {
            this.getLog().debug((CharSequence)"Installing empty EAR artifact to .m2 directory...");
            this.updateArtifactPathToOutputDirectory(earProject);
        }
    }

    private void installEmptyEAR(MavenProject earProject) throws MojoExecutionException {
        File tempFile;
        String goal = "install-file";
        Plugin plugin = this.getPlugin("org.apache.maven.plugins", "maven-install-plugin");
        this.getLog().debug((CharSequence)("Running maven-install-plugin:" + goal));
        try {
            tempFile = File.createTempFile(earProject.getArtifactId(), ".ear");
            tempFile.deleteOnExit();
        }
        catch (IOException e) {
            String module = this.getModuleRelativePath(earProject);
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException("Could not install placeholder EAR artifact for module " + module + ". Manually run the following command to resolve this issue: mvn install -pl " + module + " -am");
        }
        Xpp3Dom config = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"file"), (String)tempFile.getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"pomFile"), (String)earProject.getFile().getAbsolutePath())});
        this.getLog().debug((CharSequence)("configuration:\n" + config));
        try {
            MojoExecutor.executeMojo((Plugin)plugin, (String)MojoExecutor.goal((String)goal), (Xpp3Dom)config, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        }
        catch (MojoExecutionException e) {
            String module = this.getModuleRelativePath(earProject);
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException("Could not install placeholder EAR artifact for module " + module + ". Manually run the following command to resolve this issue: mvn install -pl " + module + " -am");
        }
    }

    protected void purgeLocalRepositoryArtifact() throws MojoExecutionException {
        Plugin plugin = this.getPlugin("org.apache.maven.plugins", "maven-dependency-plugin");
        String goal = "purge-local-repository";
        Xpp3Dom config = ExecuteMojoUtil.getPluginGoalConfig(plugin, goal, this.getLog());
        config = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"reResolve"), (String)"false"), MojoExecutor.element((String)MojoExecutor.name((String)"actTransitively"), (String)"false"), MojoExecutor.element((String)MojoExecutor.name((String)"manualIncludes"), (String)(this.project.getGroupId() + ":" + this.project.getArtifactId()))}), (Xpp3Dom)config);
        this.getLog().info((CharSequence)("Running maven-dependency-plugin:" + goal));
        this.getLog().debug((CharSequence)("configuration:\n" + config));
        MojoExecutor.executeMojo((Plugin)plugin, (String)MojoExecutor.goal((String)goal), (Xpp3Dom)config, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    protected void updateArtifactPathToOutputDirectory(MavenProject mavenProject) {
        this.updateArtifactPathToOutputDirectory(mavenProject, mavenProject.getArtifact());
    }

    protected void updateArtifactPathToOutputDirectory(MavenProject mavenProject, Artifact artifactToUpdate) {
        Path outputDir = null;
        outputDir = artifactToUpdate.getType().equals("ear") ? Paths.get(mavenProject.getBuild().getDirectory(), new String[0]) : Paths.get(mavenProject.getBuild().getOutputDirectory(), new String[0]);
        try {
            if (!Files.exists(outputDir, new LinkOption[0])) {
                Files.createDirectory(outputDir, new FileAttribute[0]);
            }
        }
        catch (IOException ioe) {
            this.getLog().debug((CharSequence)("Failure creating output directory: " + outputDir), (Throwable)ioe);
        }
        artifactToUpdate.setFile(outputDir.toFile());
    }

    private static enum PropertyType {
        BOOTSTRAP("liberty.bootstrap."),
        ENV("liberty.env."),
        JVM("liberty.jvm."),
        VAR("liberty.var."),
        DEFAULTVAR("liberty.defaultVar.");

        private final String prefix;
        private static final Map<String, PropertyType> lookup;

        private PropertyType(String prefix) {
            this.prefix = prefix;
        }

        public static PropertyType getPropertyType(String propertyName) {
            Matcher matcher = pattern.matcher(propertyName);
            if (matcher.find()) {
                String prefix = matcher.group(1);
                return lookup.get(prefix);
            }
            return null;
        }

        public String getPrefix() {
            return this.prefix;
        }

        static {
            lookup = new HashMap<String, PropertyType>();
            for (PropertyType s : EnumSet.allOf(PropertyType.class)) {
                lookup.put(s.prefix, s);
            }
        }
    }
}

