/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.server;

import io.openliberty.tools.ant.ServerTask;
import io.openliberty.tools.maven.server.StartDebugMojoSupport;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="java-dump", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class JavaDumpServerMojo
extends StartDebugMojoSupport {
    @Parameter(property="heapDump")
    private boolean heapDump;
    @Parameter(property="systemDump")
    private boolean systemDump;

    public void execute() throws MojoExecutionException {
        this.init();
        if (this.skip) {
            this.getLog().info((CharSequence)"\nSkipping java-dump goal.\n");
            return;
        }
        this.doJavaDumpServer();
    }

    private void doJavaDumpServer() throws MojoExecutionException {
        if (this.isInstall) {
            try {
                this.installServerAssembly();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error installing the Liberty server.", (Exception)e);
            }
        } else {
            this.getLog().info((CharSequence)MessageFormat.format(messages.getString("info.install.type.preexisting"), ""));
            this.checkServerHomeExists();
            this.checkServerDirectoryExists();
        }
        ServerTask serverTask = this.initializeJava();
        try {
            this.copyConfigFiles();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying configuration files to Liberty server directory.", (Exception)e);
        }
        serverTask.setOperation("javadump");
        serverTask.setInclude(this.generateInclude());
        serverTask.execute();
    }

    private String generateInclude() {
        StringBuilder builder = new StringBuilder();
        if (this.heapDump) {
            builder.append("heap");
        }
        if (this.systemDump) {
            if (builder.length() != 0) {
                builder.append(",");
            }
            builder.append("system");
        }
        return builder.length() == 0 ? null : builder.toString();
    }
}

