/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.server;

import io.openliberty.tools.ant.ServerTask;
import io.openliberty.tools.maven.server.PluginConfigSupport;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="run", requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class RunServerMojo
extends PluginConfigSupport {
    @Parameter(property="clean", defaultValue="false")
    protected boolean clean;
    @Parameter(property="embedded", defaultValue="false")
    private boolean embedded;

    protected void doExecute() throws Exception {
        boolean hasDownstreamProjects;
        block26: {
            if (this.skip) {
                this.getLog().info((CharSequence)"\nSkipping run goal.\n");
                return;
            }
            String projectPackaging = this.project.getPackaging();
            hasDownstreamProjects = false;
            ProjectDependencyGraph graph = this.session.getProjectDependencyGraph();
            if (graph != null) {
                this.checkMultiModuleConflicts(graph);
                Object downstreamProjects = graph.getDownstreamProjects(this.project, true);
                if (!downstreamProjects.isEmpty()) {
                    this.log.debug((CharSequence)("Downstream projects: " + downstreamProjects));
                    hasDownstreamProjects = true;
                }
                if (this.containsPreviousLibertyModule(graph)) {
                    return;
                }
            }
            if (projectPackaging.equals("ear")) {
                this.runMojo("org.apache.maven.plugins", "maven-ear-plugin", "generate-application-xml");
                this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "resources");
                if (hasDownstreamProjects && this.looseApplication) {
                    this.installEmptyEarIfNotFound(this.project);
                }
            } else if (projectPackaging.equals("pom")) {
                this.log.debug((CharSequence)"Skipping compile/resources on module with pom packaging type");
            } else {
                if (hasDownstreamProjects && this.looseApplication) {
                    this.purgeLocalRepositoryArtifact();
                }
                this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "resources");
                this.runMojo("org.apache.maven.plugins", "maven-compiler-plugin", "compile");
            }
            if (!this.looseApplication) {
                try {
                    switch (projectPackaging) {
                        case "war": {
                            this.runMojo("org.apache.maven.plugins", "maven-war-plugin", "war");
                            break;
                        }
                        case "ear": {
                            this.runMojo("org.apache.maven.plugins", "maven-ear-plugin", "ear");
                            break;
                        }
                        case "ejb": {
                            this.runMojo("org.apache.maven.plugins", "maven-ejb-plugin", "ejb");
                            break;
                        }
                        case "jar": {
                            this.runMojo("org.apache.maven.plugins", "maven-jar-plugin", "jar");
                        }
                    }
                }
                catch (MojoExecutionException e) {
                    if (graph == null || graph.getUpstreamProjects(this.project, true).isEmpty()) break block26;
                    this.log.warn((CharSequence)("The looseApplication parameter was set to false for the module with artifactId " + this.project.getArtifactId() + ". Ensure that all modules use the same value for the looseApplication parameter by including -DlooseApplication=false in the Maven command for your multi module project."));
                    throw e;
                }
            }
        }
        if (hasDownstreamProjects) {
            return;
        }
        this.runLibertyMojoCreate();
        this.runLibertyMojoInstallFeature(null, null);
        this.runLibertyMojoDeploy(false);
        ServerTask serverTask = this.initializeJava();
        this.copyConfigFiles();
        serverTask.setUseEmbeddedServer(this.embedded);
        serverTask.setClean(this.clean);
        serverTask.setOperation("run");
        serverTask.execute();
    }
}

