/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.server;

import io.openliberty.tools.maven.server.PluginConfigSupport;
import io.openliberty.tools.maven.utils.MavenProjectUtil;
import java.io.File;
import org.apache.maven.project.MavenProject;

public class LooseAppSupport
extends PluginConfigSupport {
    public String getLooseConfigFileName(MavenProject project) {
        return this.getPostDeployAppFileName(project) + ".xml";
    }

    protected String getPostDeployAppFileName(MavenProject project) {
        return this.getAppFileName(project, true);
    }

    protected String getPreDeployAppFileName(MavenProject project) {
        return this.getAppFileName(project, false);
    }

    protected String getAppFileName(MavenProject project, boolean stripVersionIfConfigured) {
        String classifier;
        String name = project.getBuild().getFinalName();
        if (stripVersionIfConfigured && this.stripVersion) {
            name = this.stripVersionFromName(name, project.getVersion());
        }
        if ((classifier = MavenProjectUtil.getAppNameClassifier(project)) != null) {
            name = name + "-" + classifier;
        }
        name = project.getPackaging().equals("liberty-assembly") ? name + ".war" : (project.getPackaging().equals("ejb") ? name + ".jar" : name + "." + project.getPackaging());
        return name;
    }

    public File getLooseAppConfigFile(MavenProject proj, boolean container) {
        String looseConfigFileName = this.getLooseConfigFileName(proj);
        if (container) {
            File devcDestDir = new File(new File(this.project.getBuild().getDirectory(), ".libertyDevc"), this.getAppsDirectory(false));
            File devcLooseConfigFile = new File(devcDestDir, looseConfigFileName);
            return devcLooseConfigFile;
        }
        File destDir = new File(this.serverDirectory, this.getAppsDirectory(false));
        File looseConfigFile = new File(destDir, looseConfigFileName);
        return looseConfigFile;
    }
}

