/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.extensions.arquillian;

import io.openliberty.tools.common.arquillian.objects.LibertyManagedObject;
import io.openliberty.tools.common.arquillian.objects.LibertyProperty;
import io.openliberty.tools.common.arquillian.objects.LibertyRemoteObject;
import io.openliberty.tools.common.arquillian.util.ArquillianConfigurationException;
import io.openliberty.tools.common.arquillian.util.ArtifactCoordinates;
import io.openliberty.tools.common.arquillian.util.Constants;
import io.openliberty.tools.common.arquillian.util.HttpPortUtil;
import io.openliberty.tools.maven.BasicSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.xml.sax.SAXException;

@Mojo(name="configure-arquillian", requiresDependencyResolution=ResolutionScope.TEST)
public class ConfigureArquillianMojo
extends BasicSupport {
    @Parameter
    private Map<String, String> arquillianProperties;
    private TypeProperty type = TypeProperty.NOTFOUND;
    @Parameter(property="skipIfArquillianXmlExists", defaultValue="false")
    protected boolean skipIfArquillianXmlExists = false;

    public void execute() throws MojoExecutionException {
        this.init();
        File arquillianXml = new File(this.project.getBuild().getDirectory(), "test-classes/arquillian.xml");
        Set artifacts = this.project.getArtifacts();
        block4: for (Artifact artifact : artifacts) {
            String artifactId;
            String groupId;
            for (ArtifactCoordinates coors : Constants.ARQUILLIAN_REMOTE_DEPENDENCY) {
                groupId = artifact.getGroupId();
                artifactId = artifact.getArtifactId();
                if (!groupId.equals(coors.getGroupId()) || !artifactId.equals(coors.getArtifactId())) continue;
                this.type = TypeProperty.REMOTE;
                this.getLog().info((CharSequence)("Automatically detected the Arquillian Liberty Remote container at the following coordinates: " + groupId + ":" + artifactId + "."));
                break block4;
            }
            for (ArtifactCoordinates coors : Constants.ARQUILLIAN_MANAGED_DEPENDENCY) {
                groupId = artifact.getGroupId();
                artifactId = artifact.getArtifactId();
                if (!groupId.equals(coors.getGroupId()) || !artifactId.equals(coors.getArtifactId())) continue;
                this.type = TypeProperty.MANAGED;
                this.getLog().info((CharSequence)("Automatically detected the Arquillian Liberty Managed container at the following coordinates: " + groupId + ":" + artifactId + "."));
                break block4;
            }
        }
        if (this.type == TypeProperty.NOTFOUND) {
            this.getLog().warn((CharSequence)"Arquillian Liberty Managed and Remote dependencies were not found. Defaulting to use the Liberty Managed container.");
            this.type = TypeProperty.MANAGED;
        }
        if (this.skipIfArquillianXmlExists && arquillianXml.exists()) {
            this.getLog().info((CharSequence)"Skipping configure-arquillian goal because arquillian.xml already exists in \"target/test-classes\".");
            return;
        }
        switch (this.type) {
            case MANAGED: {
                this.configureArquillianManaged(arquillianXml);
                break;
            }
            case REMOTE: {
                this.configureArquillianRemote(arquillianXml);
                break;
            }
            default: {
                throw new MojoExecutionException("This should never happen.");
            }
        }
    }

    private void configureArquillianManaged(File arquillianXml) throws MojoExecutionException {
        try {
            String userDir = this.userDirectorySpecified ? this.userDirectory.getCanonicalPath() : null;
            LibertyManagedObject arquillianManaged = new LibertyManagedObject(this.installDirectory.getCanonicalPath(), this.serverName, userDir, this.getHttpPort(), LibertyProperty.getArquillianProperties(this.arquillianProperties, LibertyManagedObject.LibertyManagedProperty.class));
            arquillianManaged.build(arquillianXml);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error configuring Arquillian.", e);
        }
    }

    private void configureArquillianRemote(File arquillianXml) throws MojoExecutionException {
        try {
            LibertyRemoteObject arquillianRemote = new LibertyRemoteObject(LibertyProperty.getArquillianProperties(this.arquillianProperties, LibertyRemoteObject.LibertyRemoteProperty.class));
            arquillianRemote.build(arquillianXml);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error configuring Arquillian.", e);
        }
    }

    private int getHttpPort() throws FileNotFoundException, XPathExpressionException, IOException, ParserConfigurationException, SAXException, ArquillianConfigurationException {
        File serverXML = new File(this.serverDirectory + "/server.xml");
        File configVariableXML = new File(this.serverDirectory + "/configDropins/overrides/liberty-plugin-variable-config.xml");
        File bootstrapProperties = new File(this.serverDirectory + "/bootstrap.properties");
        return HttpPortUtil.getHttpPort((File)serverXML, (File)bootstrapProperties, (File)configVariableXML);
    }

    private static enum TypeProperty {
        MANAGED,
        REMOTE,
        NOTFOUND;

    }
}

