/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.applications;

import io.openliberty.tools.ant.ServerTask;
import io.openliberty.tools.ant.SpringBootUtilTask;
import io.openliberty.tools.common.CommonLoggerI;
import io.openliberty.tools.common.plugins.config.ApplicationXmlDocument;
import io.openliberty.tools.common.plugins.config.LooseApplication;
import io.openliberty.tools.common.plugins.config.LooseConfigData;
import io.openliberty.tools.common.plugins.config.ServerConfigDocument;
import io.openliberty.tools.common.plugins.util.DevUtil;
import io.openliberty.tools.maven.applications.LooseEarApplication;
import io.openliberty.tools.maven.applications.LooseWarApplication;
import io.openliberty.tools.maven.server.LooseAppSupport;
import io.openliberty.tools.maven.utils.CommonLogger;
import io.openliberty.tools.maven.utils.MavenProjectUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.taskdefs.Copy;
import org.w3c.dom.Element;

public abstract class DeployMojoSupport
extends LooseAppSupport {
    private final String PROJECT_ROOT_TARGET_LIBS = "target/libs";
    @Parameter(property="timeout", defaultValue="40")
    protected long timeout = 40L;
    @Parameter(property="copyLibsDirectory")
    protected File copyLibsDirectory;
    protected ApplicationXmlDocument applicationXml = new ApplicationXmlDocument();

    protected void installApp(Artifact artifact) throws MojoExecutionException, IOException {
        if (artifact.getFile() == null || artifact.getFile().isDirectory()) {
            String appFileName = this.getPreDeployAppFileName(this.project);
            File f = new File(this.project.getBuild().getDirectory() + "/" + appFileName);
            artifact.setFile(f);
        }
        if (!artifact.getFile().exists()) {
            throw new MojoExecutionException(messages.getString("error.install.app.missing"));
        }
        File destDir = new File(this.serverDirectory, this.getAppsDirectory());
        this.getLog().info((CharSequence)MessageFormat.format(messages.getString("info.install.app"), artifact.getFile().getCanonicalPath()));
        Copy copyFile = (Copy)this.ant.createTask("copy");
        File fileToCopy = artifact.getFile();
        copyFile.setFile(fileToCopy);
        String originalFileName = fileToCopy.getName();
        File destFile = new File(destDir, originalFileName);
        String destFileName = originalFileName;
        if (this.stripVersion) {
            destFileName = this.stripVersionFromName(originalFileName, artifact.getBaseVersion());
            destFile = new File(destDir, destFileName);
            copyFile.setTofile(destFile);
        } else {
            copyFile.setTodir(destDir);
        }
        this.validateAppConfig(destFile.getCanonicalPath(), destFileName, artifact.getArtifactId());
        this.deleteApplication(this.serverDirectory, fileToCopy, destFile);
        copyFile.execute();
        this.verifyAppStarted(destFileName);
    }

    private void setLooseProjectRootForContainer(MavenProject proj, LooseConfigData config) throws MojoExecutionException {
        try {
            String projectRoot = DevUtil.getLooseAppProjectRoot((File)proj.getBasedir(), (File)this.multiModuleProjectDirectory).getCanonicalPath();
            config.setProjectRoot(projectRoot);
            config.setSourceOnDiskName("${io.openliberty.tools.projectRoot}");
            if (this.copyLibsDirectory == null) {
                this.copyLibsDirectory = new File(proj.getBasedir(), "target/libs");
            } else {
                String copyLibsPath = this.copyLibsDirectory.getCanonicalPath();
                if (!copyLibsPath.startsWith(projectRoot)) {
                    this.getLog().error((CharSequence)"The directory indicated by the copyLibsDirectory parameter must be within the Maven project directory when the container option is specified.");
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not resolve the canonical path of the Maven project or the directory specified in the copyLibsDirectory parameter. Exception message:" + e.getMessage(), (Exception)e);
        }
    }

    protected void installLooseConfigWar(MavenProject proj, LooseConfigData config, boolean container) throws MojoExecutionException, IOException {
        LooseWarApplication looseWar;
        File dir = new File(proj.getBuild().getOutputDirectory());
        if (!dir.exists() && this.containsJavaSource(proj)) {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.project.not.compile"), proj.getId()));
        }
        if (container) {
            this.setLooseProjectRootForContainer(proj, config);
        }
        if ((looseWar = new LooseWarApplication(proj, config, this.getLog())).isExploded()) {
            Plugin warPlugin = this.getPlugin("org.apache.maven.plugins", "maven-war-plugin");
            if (!this.validatePluginVersion(warPlugin.getVersion(), "3.3.2")) {
                this.getLog().warn((CharSequence)"Exploded WAR functionality is enabled. Please use maven-war-plugin version 3.3.2 or greater for best results.");
            }
            this.runExplodedMojo();
            looseWar.addNonFilteredSourceAndWebResourcesPaths();
            looseWar.addOutputDir(looseWar.getDocumentRoot(), new File(proj.getBuild().getOutputDirectory()), "/WEB-INF/classes");
            looseWar.addOutputDir(looseWar.getDocumentRoot(), looseWar.getWebAppDirectory(), "/");
        } else {
            looseWar.addSourceDir();
            looseWar.addOutputDir(looseWar.getDocumentRoot(), new File(proj.getBuild().getOutputDirectory()), "/WEB-INF/classes");
            looseWar.addAllWebResourcesConfigurationPaths();
            this.addEmbeddedLib(looseWar.getDocumentRoot(), proj, looseWar, "/WEB-INF/lib/");
        }
        File manifestFile = MavenProjectUtil.getManifestFile(proj, "maven-war-plugin");
        try {
            looseWar.addManifestFile(manifestFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to install loose application. Error adding manifest file to loose war configuration file.", e);
        }
    }

    protected void installLooseConfigEar(MavenProject proj, LooseConfigData config, boolean container) throws MojoExecutionException, IOException {
        if (container) {
            this.setLooseProjectRootForContainer(proj, config);
        }
        LooseEarApplication looseEar = new LooseEarApplication(proj, config);
        looseEar.addSourceDir();
        looseEar.addApplicationXmlFile();
        Set artifacts = proj.getArtifacts();
        this.getLog().debug((CharSequence)("Number of compile dependencies for " + proj.getArtifactId() + " : " + artifacts.size()));
        block16: for (Artifact artifact : artifacts) {
            if (!"compile".equals(artifact.getScope()) && !"runtime".equals(artifact.getScope())) continue;
            if (!this.isReactorMavenProject(artifact)) {
                if (looseEar.isEarSkinnyWars().booleanValue() && "war".equals(artifact.getType())) {
                    throw new MojoExecutionException("Unable to create loose configuration for the EAR application with skinnyWars package from " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ". Please set the looseApplication configuration parameter to false and try again.");
                }
                looseEar.addModuleFromM2(this.resolveArtifact(artifact));
                continue;
            }
            MavenProject dependencyProject = this.getReactorMavenProject(artifact);
            switch (artifact.getType()) {
                case "jar": {
                    looseEar.addJarModule(dependencyProject, artifact);
                    continue block16;
                }
                case "ejb": {
                    looseEar.addEjbModule(dependencyProject, artifact);
                    continue block16;
                }
                case "bundle": {
                    looseEar.addBundleModule(dependencyProject, artifact);
                    continue block16;
                }
                case "war": {
                    Element warArchive = looseEar.addWarModule(dependencyProject, artifact, this.getWarSourceDirectory(dependencyProject));
                    if (looseEar.isEarSkinnyWars().booleanValue()) {
                        this.addSkinnyWarLib(warArchive, dependencyProject, looseEar);
                        continue block16;
                    }
                    this.addEmbeddedLib(warArchive, dependencyProject, looseEar, "/WEB-INF/lib/");
                    continue block16;
                }
                case "rar": {
                    Element rarArchive = looseEar.addRarModule(dependencyProject, artifact);
                    this.addEmbeddedLib(rarArchive, dependencyProject, looseEar, "/");
                    continue block16;
                }
            }
            looseEar.addModuleFromM2(this.resolveArtifact(artifact));
        }
        File manifestFile = MavenProjectUtil.getManifestFile(proj, "maven-ear-plugin");
        try {
            looseEar.addManifestFile(manifestFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to install loose application. Error adding manifest file to loose ear configuration file.", e);
        }
    }

    private boolean shouldValidateAppStart() throws MojoExecutionException {
        try {
            return new File(this.serverDirectory.getCanonicalPath() + "/workarea/.sRunning").exists();
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Could not get the server directory to determine the state of the server.");
        }
    }

    protected void verifyAppStarted(String appFile) throws MojoExecutionException {
        if (this.shouldValidateAppStart()) {
            ServerTask serverTask;
            String appName = appFile.substring(0, appFile.lastIndexOf(46));
            if (this.getAppsDirectory().equals("apps")) {
                File serverXML = new File(this.serverDirectory, "server.xml");
                try {
                    Map<String, File> libertyDirPropertyFiles = this.getLibertyDirectoryPropertyFiles();
                    CommonLogger logger = CommonLogger.getInstance(this.getLog());
                    this.setLog(logger.getLog());
                    ServerConfigDocument.getInstance((CommonLoggerI)logger, (File)serverXML, (File)this.configDirectory, (File)this.bootstrapPropertiesFile, (Map)this.combinedBootstrapProperties, (File)this.serverEnvFile, (boolean)false, libertyDirPropertyFiles);
                    appName = ServerConfigDocument.findNameForLocation((String)appFile);
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)e.getLocalizedMessage());
                    this.getLog().debug((Throwable)e);
                }
            }
            if ((serverTask = this.initializeJava()).waitForStringInLog("CWWKZ0001I.*" + appName, this.timeout * 1000L, new File(new File(this.outputDirectory, this.serverName), "logs/messages.log")) == null) {
                throw new MojoExecutionException(MessageFormat.format(messages.getString("error.deploy.fail"), appName));
            }
        }
    }

    private void addEmbeddedLib(Element parent, MavenProject warProject, LooseApplication looseApp, String dir) throws MojoExecutionException, IOException {
        Set artifacts = warProject.getArtifacts();
        this.getLog().debug((CharSequence)("Number of compile dependencies for " + warProject.getArtifactId() + " : " + artifacts.size()));
        for (Artifact artifact : artifacts) {
            if (!"compile".equals(artifact.getScope()) && !"runtime".equals(artifact.getScope()) || !"jar".equals(artifact.getType()) && !"jar".equals(artifact.getArtifactHandler().getExtension())) continue;
            this.addLibrary(parent, looseApp, dir, artifact);
        }
    }

    private void addSkinnyWarLib(Element parent, MavenProject warProject, LooseEarApplication looseEar) throws MojoExecutionException, IOException {
        Set artifacts = warProject.getArtifacts();
        this.getLog().debug((CharSequence)("Number of compile dependencies for " + warProject.getArtifactId() + " : " + artifacts.size()));
        for (Artifact artifact : artifacts) {
            if (!"compile".equals(artifact.getScope()) && !"runtime".equals(artifact.getScope()) || !"jar".equals(artifact.getType()) && !"jar".equals(artifact.getArtifactHandler().getExtension()) || looseEar.isEarDependency(artifact)) continue;
            this.addLibrary(parent, looseEar, "/WEB-INF/lib/", artifact);
        }
    }

    private void addLibrary(Element parent, LooseApplication looseApp, String dir, Artifact artifact) throws MojoExecutionException, IOException {
        if (this.isReactorMavenProject(artifact)) {
            MavenProject dependProject = this.getReactorMavenProject(artifact);
            String artifactFileName = this.getPreDeployAppFileName(dependProject);
            Element archive = looseApp.addArchive(parent, dir + artifactFileName);
            looseApp.addOutputDir(archive, new File(dependProject.getBuild().getOutputDirectory()), "/");
            String archivePlugin = "maven-jar-plugin";
            String packaging = dependProject.getPackaging();
            if (packaging.equalsIgnoreCase("ejb")) {
                archivePlugin = "maven-ejb-plugin";
            } else if (packaging.equalsIgnoreCase("bundle")) {
                archivePlugin = "maven-bundle-plugin";
            }
            File manifestFile = MavenProjectUtil.getManifestFile(dependProject, archivePlugin);
            String dependProjectTargetDir = dependProject.getBuild().getDirectory();
            try {
                looseApp.addManifestFileWithParent(archive, manifestFile, dependProjectTargetDir);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error adding manifest file with parent: " + manifestFile.getCanonicalPath(), e);
            }
        } else {
            this.resolveArtifact(artifact);
            if (this.copyLibsDirectory != null) {
                if (!this.copyLibsDirectory.exists()) {
                    this.copyLibsDirectory.mkdirs();
                }
                if (!this.copyLibsDirectory.isDirectory()) {
                    throw new MojoExecutionException("copyLibsDirectory must be a directory");
                }
                looseApp.getConfig().addFile(parent, artifact.getFile(), dir + artifact.getFile().getName(), this.copyLibsDirectory);
            } else {
                looseApp.getConfig().addFile(parent, artifact.getFile(), dir + artifact.getFile().getName());
            }
        }
    }

    private boolean containsJavaSource(MavenProject proj) {
        List srcDirs = proj.getCompileSourceRoots();
        for (String dir : srcDirs) {
            File javaSourceDir = new File(dir);
            if (!javaSourceDir.exists() || !javaSourceDir.isDirectory() || !this.containsJavaSource(javaSourceDir)) continue;
            return true;
        }
        return false;
    }

    private boolean containsJavaSource(File dir) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isFile() && file.getName().toLowerCase().endsWith(".java")) {
                return true;
            }
            if (!file.isDirectory()) continue;
            return this.containsJavaSource(file);
        }
        return false;
    }

    protected void validateAppConfig(String fullyQualifiedFileName, String fileName, String artifactId) throws MojoExecutionException {
        this.validateAppConfig(fullyQualifiedFileName, fileName, artifactId, false);
    }

    protected void validateAppConfig(String fullyQualifiedFileName, String fileName, String artifactId, boolean isSpringBootApp) throws MojoExecutionException {
        String appsDir = this.getAppsDirectory();
        if (appsDir.equalsIgnoreCase("apps") && !this.isAppConfiguredInSourceServerXml(fullyQualifiedFileName, fileName)) {
            this.getLog().info((CharSequence)("Could not find application " + fileName + " in server.xml locations."));
            this.applicationXml.createApplicationElement(fileName, artifactId, isSpringBootApp);
        } else if (appsDir.equalsIgnoreCase("dropins") && this.isAppConfiguredInSourceServerXml(fullyQualifiedFileName, fileName)) {
            throw new MojoExecutionException(messages.getString("error.install.app.dropins.directory"));
        }
    }

    protected void invokeSpringBootUtilCommand(File installDirectory, String fatArchiveSrcLocation, String thinArchiveTargetLocation, String libIndexCacheTargetLocation) throws MojoExecutionException, IOException {
        SpringBootUtilTask springBootUtilTask = (SpringBootUtilTask)this.ant.createTask("antlib:io/openliberty/tools/ant:springBootUtil");
        if (springBootUtilTask == null) {
            throw new IllegalStateException(MessageFormat.format(messages.getString("error.dependencies.not.found"), "springBootUtil"));
        }
        Validate.notNull((Object)fatArchiveSrcLocation, (String)"Spring Boot source archive location cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)thinArchiveTargetLocation, (String)"Target thin archive location cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)libIndexCacheTargetLocation, (String)"Library cache location cannot be null", (Object[])new Object[0]);
        springBootUtilTask.setInstallDir(installDirectory);
        springBootUtilTask.setTargetThinAppPath(thinArchiveTargetLocation);
        springBootUtilTask.setSourceAppPath(fatArchiveSrcLocation);
        springBootUtilTask.setTargetLibCachePath(libIndexCacheTargetLocation);
        springBootUtilTask.execute();
    }

    protected boolean matches(Artifact artifact, Dependency assemblyArtifact) {
        return artifact.getGroupId().equals(assemblyArtifact.getGroupId()) && artifact.getArtifactId().equals(assemblyArtifact.getArtifactId()) && artifact.getType().equals(assemblyArtifact.getType());
    }

    protected boolean isSupportedType(String type) {
        boolean supported = false;
        switch (type) {
            case "ear": 
            case "war": 
            case "rar": 
            case "eba": 
            case "esa": 
            case "liberty-assembly": {
                supported = true;
                break;
            }
        }
        return supported;
    }

    public static boolean isSupportedLooseAppType(String type) {
        boolean supported = false;
        switch (type) {
            case "ear": 
            case "war": 
            case "liberty-assembly": 
            case "pom": {
                supported = true;
                break;
            }
        }
        return supported;
    }
}

