/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.server;

import io.openliberty.tools.ant.ServerTask;
import io.openliberty.tools.maven.server.StartDebugMojoSupport;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="debug", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DebugServerMojo
extends StartDebugMojoSupport {
    @Parameter(property="clean", defaultValue="false")
    protected boolean clean;

    public void execute() throws MojoExecutionException {
        this.init();
        if (this.skip) {
            this.getLog().info((CharSequence)"\nSkipping debug goal.\n");
            return;
        }
        this.doDebug();
    }

    private void doDebug() throws MojoExecutionException {
        if (this.isInstall) {
            try {
                this.installServerAssembly();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error installing the Liberty server.", (Exception)e);
            }
        } else {
            this.getLog().info((CharSequence)MessageFormat.format(messages.getString("info.install.type.preexisting"), ""));
            this.checkServerHomeExists();
        }
        ServerTask serverTask = this.initializeJava();
        try {
            this.copyConfigFiles();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying configuration files to Liberty server directory.", (Exception)e);
        }
        serverTask.setClean(this.clean);
        serverTask.setOperation("debug");
        serverTask.execute();
    }
}

