/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.utils;

import io.openliberty.tools.common.CommonLoggerI;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;

public class CommonLogger
implements CommonLoggerI {
    private static CommonLogger logger = null;
    private Log loggerImpl;

    public static CommonLogger getInstance(Log mojoLogger) {
        if (logger == null) {
            logger = new CommonLogger(mojoLogger);
        } else {
            logger.setLogger(mojoLogger);
        }
        return logger;
    }

    private CommonLogger(Log mojoLogger) {
        this.loggerImpl = mojoLogger;
    }

    private void setLogger(Log mojoLogger) {
        this.loggerImpl = mojoLogger;
    }

    public Log getLog() {
        if (this.loggerImpl == null) {
            this.loggerImpl = new SystemStreamLog();
        }
        return this.loggerImpl;
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.getLog().debug((CharSequence)msg);
        }
    }

    public void debug(String msg, Throwable e) {
        if (this.isDebugEnabled()) {
            this.getLog().debug((CharSequence)msg, e);
        }
    }

    public void debug(Throwable e) {
        if (this.isDebugEnabled()) {
            this.getLog().debug(e);
        }
    }

    public void warn(String msg) {
        this.getLog().warn((CharSequence)msg);
    }

    public void info(String msg) {
        this.getLog().info((CharSequence)msg);
    }

    public void error(String msg) {
        this.getLog().error((CharSequence)msg);
    }

    public boolean isDebugEnabled() {
        return this.getLog().isDebugEnabled();
    }
}

