/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.sdk.trace.IdsGenerator;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.TraceId;
import java.util.concurrent.ThreadLocalRandom;

public final class RandomIdsGenerator
implements IdsGenerator {
    private static final long INVALID_ID = 0L;

    @Override
    public String generateSpanId() {
        long id;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while ((id = random.nextLong()) == 0L) {
        }
        return SpanId.fromLong((long)id);
    }

    @Override
    public String generateTraceId() {
        long idLo;
        long idHi;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        do {
            idHi = random.nextLong();
            idLo = random.nextLong();
        } while (idHi == 0L && idLo == 0L);
        return TraceId.fromLongs((long)idHi, (long)idLo);
    }
}

