/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import io.opentelemetry.common.AttributeKey;
import io.opentelemetry.common.Attributes;
import io.opentelemetry.common.ReadableAttributes;
import io.opentelemetry.sdk.trace.AutoValue_Samplers_SamplingResultImpl;
import io.opentelemetry.sdk.trace.AutoValue_Samplers_TraceIdRatioBased;
import io.opentelemetry.sdk.trace.Sampler;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.TraceId;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Samplers {
    static final AttributeKey<Double> SAMPLING_PROBABILITY = AttributeKey.doubleKey((String)"sampling.probability");
    private static final Sampler.SamplingResult EMPTY_RECORDED_AND_SAMPLED_SAMPLING_RESULT = SamplingResultImpl.createWithoutAttributes(Sampler.Decision.RECORD_AND_SAMPLE);
    private static final Sampler.SamplingResult EMPTY_NOT_SAMPLED_OR_RECORDED_SAMPLING_RESULT = SamplingResultImpl.createWithoutAttributes(Sampler.Decision.DROP);
    private static final Sampler.SamplingResult EMPTY_RECORDED_SAMPLING_RESULT = SamplingResultImpl.createWithoutAttributes(Sampler.Decision.RECORD_ONLY);

    private Samplers() {
    }

    static boolean isRecording(Sampler.Decision decision) {
        return Sampler.Decision.RECORD_ONLY.equals((Object)decision) || Sampler.Decision.RECORD_AND_SAMPLE.equals((Object)decision);
    }

    static boolean isSampled(Sampler.Decision decision) {
        return Sampler.Decision.RECORD_AND_SAMPLE.equals((Object)decision);
    }

    public static Sampler.SamplingResult samplingResult(Sampler.Decision decision, Attributes attributes) {
        Objects.requireNonNull(attributes, "attributes");
        return attributes.isEmpty() ? Samplers.emptySamplingResult(decision) : SamplingResultImpl.create(decision, attributes);
    }

    public static Sampler.SamplingResult emptySamplingResult(Sampler.Decision decision) {
        switch (decision) {
            case RECORD_AND_SAMPLE: {
                return EMPTY_RECORDED_AND_SAMPLED_SAMPLING_RESULT;
            }
            case RECORD_ONLY: {
                return EMPTY_RECORDED_SAMPLING_RESULT;
            }
            case DROP: {
                return EMPTY_NOT_SAMPLED_OR_RECORDED_SAMPLING_RESULT;
            }
        }
        throw new AssertionError((Object)"unrecognised samplingResult");
    }

    public static Sampler alwaysOn() {
        return AlwaysOnSampler.INSTANCE;
    }

    public static Sampler alwaysOff() {
        return AlwaysOffSampler.INSTANCE;
    }

    public static Sampler parentBased(Sampler root) {
        return Samplers.parentBasedBuilder(root).build();
    }

    public static ParentBased.Builder parentBasedBuilder(Sampler root) {
        return new ParentBased.Builder(root);
    }

    public static Sampler traceIdRatioBased(double ratio) {
        return TraceIdRatioBased.create(ratio);
    }

    @Immutable
    @AutoValue
    static abstract class SamplingResultImpl
    implements Sampler.SamplingResult {
        SamplingResultImpl() {
        }

        static Sampler.SamplingResult createWithProbability(Sampler.Decision decision, double probability) {
            return new AutoValue_Samplers_SamplingResultImpl(decision, Attributes.of(SAMPLING_PROBABILITY, (Object)probability));
        }

        static Sampler.SamplingResult createWithoutAttributes(Sampler.Decision decision) {
            return new AutoValue_Samplers_SamplingResultImpl(decision, Attributes.empty());
        }

        static Sampler.SamplingResult create(Sampler.Decision decision, Attributes attributes) {
            return new AutoValue_Samplers_SamplingResultImpl(decision, attributes);
        }

        @Override
        public abstract Sampler.Decision getDecision();

        @Override
        public abstract Attributes getAttributes();
    }

    @AutoValue
    @Immutable
    static abstract class TraceIdRatioBased
    implements Sampler {
        TraceIdRatioBased() {
        }

        static TraceIdRatioBased create(double ratio) {
            Preconditions.checkArgument((ratio >= 0.0 && ratio <= 1.0 ? 1 : 0) != 0, (Object)"ratio must be in range [0.0, 1.0]");
            long idUpperBound = ratio == 0.0 ? Long.MIN_VALUE : (ratio == 1.0 ? Long.MAX_VALUE : (long)(ratio * 9.223372036854776E18));
            return new AutoValue_Samplers_TraceIdRatioBased(ratio, idUpperBound, SamplingResultImpl.createWithProbability(Sampler.Decision.RECORD_AND_SAMPLE, ratio), SamplingResultImpl.createWithProbability(Sampler.Decision.DROP, ratio));
        }

        abstract double getRatio();

        abstract long getIdUpperBound();

        abstract Sampler.SamplingResult getPositiveSamplingResult();

        abstract Sampler.SamplingResult getNegativeSamplingResult();

        @Override
        public final Sampler.SamplingResult shouldSample(SpanContext parentContext, String traceId, String name, Span.Kind spanKind, ReadableAttributes attributes, List<SpanData.Link> parentLinks) {
            return Math.abs(TraceId.getTraceIdRandomPart((CharSequence)traceId)) < this.getIdUpperBound() ? this.getPositiveSamplingResult() : this.getNegativeSamplingResult();
        }

        @Override
        public final String getDescription() {
            return String.format("TraceIdRatioBased{%.6f}", this.getRatio());
        }
    }

    @Immutable
    static class ParentBased
    implements Sampler {
        private final Sampler root;
        private final Sampler remoteParentSampled;
        private final Sampler remoteParentNotSampled;
        private final Sampler localParentSampled;
        private final Sampler localParentNotSampled;

        private ParentBased(Sampler root, Sampler remoteParentSampled, Sampler remoteParentNotSampled, Sampler localParentSampled, Sampler localParentNotSampled) {
            this.root = root;
            this.remoteParentSampled = remoteParentSampled == null ? Samplers.alwaysOn() : remoteParentSampled;
            this.remoteParentNotSampled = remoteParentNotSampled == null ? Samplers.alwaysOff() : remoteParentNotSampled;
            this.localParentSampled = localParentSampled == null ? Samplers.alwaysOn() : localParentSampled;
            this.localParentNotSampled = localParentNotSampled == null ? Samplers.alwaysOff() : localParentNotSampled;
        }

        @Override
        public Sampler.SamplingResult shouldSample(SpanContext parentContext, String traceId, String name, Span.Kind spanKind, ReadableAttributes attributes, List<SpanData.Link> parentLinks) {
            if (!parentContext.isValid()) {
                return this.root.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
            }
            if (parentContext.isRemote()) {
                return parentContext.isSampled() ? this.remoteParentSampled.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks) : this.remoteParentNotSampled.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
            }
            return parentContext.isSampled() ? this.localParentSampled.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks) : this.localParentNotSampled.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
        }

        @Override
        public String getDescription() {
            return String.format("ParentBased{root:%s,remoteParentSampled:%s,remoteParentNotSampled:%s,localParentSampled:%s,localParentNotSampled:%s}", this.root.getDescription(), this.remoteParentSampled.getDescription(), this.remoteParentNotSampled.getDescription(), this.localParentSampled.getDescription(), this.localParentNotSampled.getDescription());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParentBased)) {
                return false;
            }
            ParentBased that = (ParentBased)o;
            if (this.root != null ? !this.root.equals(that.root) : that.root != null) {
                return false;
            }
            if (this.remoteParentSampled != null ? !this.remoteParentSampled.equals(that.remoteParentSampled) : that.remoteParentSampled != null) {
                return false;
            }
            if (this.remoteParentNotSampled != null ? !this.remoteParentNotSampled.equals(that.remoteParentNotSampled) : that.remoteParentNotSampled != null) {
                return false;
            }
            if (this.localParentSampled != null ? !this.localParentSampled.equals(that.localParentSampled) : that.localParentSampled != null) {
                return false;
            }
            return this.localParentNotSampled != null ? this.localParentNotSampled.equals(that.localParentNotSampled) : that.localParentNotSampled == null;
        }

        public int hashCode() {
            int result = this.root != null ? this.root.hashCode() : 0;
            result = 31 * result + (this.remoteParentSampled != null ? this.remoteParentSampled.hashCode() : 0);
            result = 31 * result + (this.remoteParentNotSampled != null ? this.remoteParentNotSampled.hashCode() : 0);
            result = 31 * result + (this.localParentSampled != null ? this.localParentSampled.hashCode() : 0);
            result = 31 * result + (this.localParentNotSampled != null ? this.localParentNotSampled.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ParentBased{root=" + this.root + ", remoteParentSampled=" + this.remoteParentSampled + ", remoteParentNotSampled=" + this.remoteParentNotSampled + ", localParentSampled=" + this.localParentSampled + ", localParentNotSampled=" + this.localParentNotSampled + '}';
        }

        static class Builder {
            private final Sampler root;
            private Sampler remoteParentSampled;
            private Sampler remoteParentNotSampled;
            private Sampler localParentSampled;
            private Sampler localParentNotSampled;

            public Builder setRemoteParentSampled(Sampler remoteParentSampled) {
                this.remoteParentSampled = remoteParentSampled;
                return this;
            }

            public Builder setRemoteParentNotSampled(Sampler remoteParentNotSampled) {
                this.remoteParentNotSampled = remoteParentNotSampled;
                return this;
            }

            public Builder setLocalParentSampled(Sampler localParentSampled) {
                this.localParentSampled = localParentSampled;
                return this;
            }

            public Builder setLocalParentNotSampled(Sampler localParentNotSampled) {
                this.localParentNotSampled = localParentNotSampled;
                return this;
            }

            public ParentBased build() {
                return new ParentBased(this.root, this.remoteParentSampled, this.remoteParentNotSampled, this.localParentSampled, this.localParentNotSampled);
            }

            private Builder(Sampler root) {
                this.root = root;
            }
        }
    }

    @Immutable
    private static enum AlwaysOffSampler implements Sampler
    {
        INSTANCE;


        @Override
        public Sampler.SamplingResult shouldSample(SpanContext parentContext, String traceId, String name, Span.Kind spanKind, ReadableAttributes attributes, List<SpanData.Link> parentLinks) {
            return EMPTY_NOT_SAMPLED_OR_RECORDED_SAMPLING_RESULT;
        }

        @Override
        public String getDescription() {
            return "AlwaysOffSampler";
        }
    }

    @Immutable
    private static enum AlwaysOnSampler implements Sampler
    {
        INSTANCE;


        @Override
        public Sampler.SamplingResult shouldSample(SpanContext parentContext, String traceId, String name, Span.Kind spanKind, ReadableAttributes attributes, List<SpanData.Link> parentLinks) {
            return EMPTY_RECORDED_AND_SAMPLED_SAMPLING_RESULT;
        }

        @Override
        public String getDescription() {
            return "AlwaysOnSampler";
        }
    }
}

