/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.grpc.Context;
import io.opentelemetry.common.AttributeConsumer;
import io.opentelemetry.common.AttributeKey;
import io.opentelemetry.common.Attributes;
import io.opentelemetry.common.ReadableAttributes;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.internal.MonotonicClock;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.AttributesMap;
import io.opentelemetry.sdk.trace.IdsGenerator;
import io.opentelemetry.sdk.trace.RecordEventsReadableSpan;
import io.opentelemetry.sdk.trace.Sampler;
import io.opentelemetry.sdk.trace.Samplers;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.StringUtils;
import io.opentelemetry.sdk.trace.config.TraceConfig;
import io.opentelemetry.sdk.trace.data.ImmutableLink;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.trace.DefaultSpan;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.TraceFlags;
import io.opentelemetry.trace.TraceState;
import io.opentelemetry.trace.TracingContextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

final class SpanBuilderSdk
implements Span.Builder {
    private final String spanName;
    private final InstrumentationLibraryInfo instrumentationLibraryInfo;
    private final SpanProcessor spanProcessor;
    private final TraceConfig traceConfig;
    private final Resource resource;
    private final IdsGenerator idsGenerator;
    private final Clock clock;
    @Nullable
    private Context parent;
    private Span.Kind spanKind = Span.Kind.INTERNAL;
    @Nullable
    private AttributesMap attributes;
    @Nullable
    private List<ImmutableLink> links;
    private int totalNumberOfLinksAdded = 0;
    private long startEpochNanos = 0L;
    private boolean isRootSpan;

    SpanBuilderSdk(String spanName, InstrumentationLibraryInfo instrumentationLibraryInfo, SpanProcessor spanProcessor, TraceConfig traceConfig, Resource resource, IdsGenerator idsGenerator, Clock clock) {
        this.spanName = spanName;
        this.instrumentationLibraryInfo = instrumentationLibraryInfo;
        this.spanProcessor = spanProcessor;
        this.traceConfig = traceConfig;
        this.resource = resource;
        this.idsGenerator = idsGenerator;
        this.clock = clock;
    }

    public Span.Builder setParent(Context context) {
        Objects.requireNonNull(context, "context");
        this.isRootSpan = false;
        this.parent = context;
        return this;
    }

    public Span.Builder setNoParent() {
        this.isRootSpan = true;
        this.parent = null;
        return this;
    }

    public Span.Builder setSpanKind(Span.Kind spanKind) {
        this.spanKind = Objects.requireNonNull(spanKind, "spanKind");
        return this;
    }

    public Span.Builder addLink(SpanContext spanContext) {
        this.addLink(ImmutableLink.create(spanContext));
        return this;
    }

    public Span.Builder addLink(SpanContext spanContext, Attributes attributes) {
        int totalAttributeCount = attributes.size();
        this.addLink(ImmutableLink.create(spanContext, RecordEventsReadableSpan.copyAndLimitAttributes(attributes, this.traceConfig.getMaxNumberOfAttributesPerLink()), totalAttributeCount));
        return this;
    }

    private void addLink(ImmutableLink link) {
        Objects.requireNonNull(link, "link");
        ++this.totalNumberOfLinksAdded;
        if (this.links == null) {
            this.links = new ArrayList<ImmutableLink>(this.traceConfig.getMaxNumberOfLinks());
        }
        if (this.links.size() == this.traceConfig.getMaxNumberOfLinks()) {
            return;
        }
        this.links.add(link);
    }

    public Span.Builder setAttribute(String key, String value) {
        return this.setAttribute(AttributeKey.stringKey((String)key), value);
    }

    public Span.Builder setAttribute(String key, long value) {
        return this.setAttribute(AttributeKey.longKey((String)key), Long.valueOf(value));
    }

    public Span.Builder setAttribute(String key, double value) {
        return this.setAttribute(AttributeKey.doubleKey((String)key), Double.valueOf(value));
    }

    public Span.Builder setAttribute(String key, boolean value) {
        return this.setAttribute(AttributeKey.booleanKey((String)key), Boolean.valueOf(value));
    }

    public <T> Span.Builder setAttribute(AttributeKey<T> key, T value) {
        Objects.requireNonNull(key, "key");
        if (value == null) {
            return this;
        }
        if (this.attributes == null) {
            this.attributes = new AttributesMap(this.traceConfig.getMaxNumberOfAttributes());
        }
        if (this.traceConfig.shouldTruncateStringAttributeValues()) {
            value = StringUtils.truncateToSize(key, value, this.traceConfig.getMaxLengthOfAttributeValues());
        }
        this.attributes.put(key, value);
        return this;
    }

    public Span.Builder setStartTimestamp(long startTimestamp) {
        Utils.checkArgument((startTimestamp >= 0L ? 1 : 0) != 0, (String)"Negative startTimestamp");
        this.startEpochNanos = startTimestamp;
        return this;
    }

    public Span startSpan() {
        String traceId;
        Context parentContext = this.isRootSpan ? Context.ROOT : (this.parent == null ? Context.current() : this.parent);
        Span parentSpan = TracingContextUtils.getSpan((Context)parentContext);
        SpanContext parentSpanContext = parentSpan.getContext();
        String spanId = this.idsGenerator.generateSpanId();
        TraceState traceState = TraceState.getDefault();
        if (!parentSpanContext.isValid()) {
            traceId = this.idsGenerator.generateTraceId();
        } else {
            traceId = parentSpanContext.getTraceIdAsHexString();
            traceState = parentSpanContext.getTraceState();
        }
        List<SpanData.Link> immutableLinks = this.links == null ? Collections.emptyList() : Collections.unmodifiableList(this.links);
        this.links = null;
        Object immutableAttributes = this.attributes == null ? Attributes.empty() : this.attributes;
        Sampler.SamplingResult samplingResult = this.traceConfig.getSampler().shouldSample(parentSpanContext, traceId, this.spanName, this.spanKind, (ReadableAttributes)immutableAttributes, immutableLinks);
        Sampler.Decision samplingDecision = samplingResult.getDecision();
        SpanContext spanContext = SpanBuilderSdk.createSpanContext(traceId, spanId, traceState, Samplers.isSampled(samplingDecision));
        if (!Samplers.isRecording(samplingDecision)) {
            return DefaultSpan.create((SpanContext)spanContext);
        }
        Attributes samplingAttributes = samplingResult.getAttributes();
        if (!samplingAttributes.isEmpty()) {
            if (this.attributes == null) {
                this.attributes = new AttributesMap(this.traceConfig.getMaxNumberOfAttributes());
            }
            samplingAttributes.forEach(new AttributeConsumer(){

                public <T> void consume(AttributeKey<T> key, T value) {
                    SpanBuilderSdk.this.attributes.put(key, value);
                }
            });
        }
        AttributesMap recordedAttributes = this.attributes;
        this.attributes = null;
        return RecordEventsReadableSpan.startSpan(spanContext, this.spanName, this.instrumentationLibraryInfo, this.spanKind, parentSpanContext.getSpanIdAsHexString(), parentSpanContext.isRemote(), this.traceConfig, this.spanProcessor, SpanBuilderSdk.getClock(parentSpan, this.clock), this.resource, recordedAttributes, immutableLinks, this.totalNumberOfLinksAdded, this.startEpochNanos);
    }

    private static SpanContext createSpanContext(String traceId, String spanId, TraceState traceState, boolean isSampled) {
        byte traceFlags = isSampled ? TraceFlags.getSampled() : TraceFlags.getDefault();
        return SpanContext.create((String)traceId, (String)spanId, (byte)traceFlags, (TraceState)traceState);
    }

    private static Clock getClock(Span parent, Clock clock) {
        if (parent instanceof RecordEventsReadableSpan) {
            RecordEventsReadableSpan parentRecordEventsSpan = (RecordEventsReadableSpan)parent;
            return parentRecordEventsSpan.getClock();
        }
        return MonotonicClock.create((Clock)clock);
    }
}

