/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jms.spring;

import io.opentracing.Tracer;
import io.opentracing.contrib.jms.spring.TracingJmsListenerConfigurer;
import io.opentracing.contrib.jms.spring.TracingJmsListenerEndpointRegistry;
import io.opentracing.contrib.jms.spring.TracingJmsTemplate;
import javax.jms.ConnectionFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.AbstractLazyCreationTargetSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.annotation.JmsListenerConfigurer;
import org.springframework.jms.core.JmsTemplate;

@Configuration
public class TracingJmsConfiguration {
    @Bean
    public TracingJmsListenerEndpointRegistry createTracingJmsListenerEndpointRegistry(Tracer tracer) {
        return new TracingJmsListenerEndpointRegistry(tracer);
    }

    @Bean
    public JmsListenerConfigurer createTracingJmsListenerConfigurer(TracingJmsListenerEndpointRegistry registry) {
        return new TracingJmsListenerConfigurer(registry);
    }

    @Bean
    public JmsTemplate jmsTemplate(BeanFactory beanFactory, Tracer tracer) {
        ConnectionFactory connectionFactory = this.createProxy(beanFactory);
        return new TracingJmsTemplate(connectionFactory, tracer);
    }

    private ConnectionFactory createProxy(final BeanFactory beanFactory) {
        return (ConnectionFactory)ProxyFactory.getProxy((TargetSource)new AbstractLazyCreationTargetSource(){

            public synchronized Class<?> getTargetClass() {
                return ConnectionFactory.class;
            }

            protected Object createObject() throws Exception {
                return beanFactory.getBean(ConnectionFactory.class);
            }
        });
    }
}

