/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.rxjava;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.rxjava.AbstractTracingSubscriber;
import rx.Observer;

public class TracingObserverSubscriber<T>
extends AbstractTracingSubscriber<T> {
    private final Observer<? super T> observer;
    private final Tracer tracer;

    public TracingObserverSubscriber(Observer<? super T> observer, String operationName, Tracer tracer) {
        this(observer, operationName, "rxjava-1", tracer);
    }

    public TracingObserverSubscriber(Observer<? super T> observer, String operationName, String componentName, Tracer tracer) {
        super(operationName, componentName, tracer);
        if (observer == null) {
            throw new NullPointerException("observer is null");
        }
        this.observer = observer;
        this.tracer = tracer;
    }

    @Override
    public void onNext(T t) {
        Span span = this.getSpan();
        Span activeSpan = this.tracer.activeSpan();
        if (!(span == null || activeSpan != null && span.equals(activeSpan))) {
            try (Scope ignore = this.tracer.scopeManager().activate(this.getSpan(), false);){
                this.observer.onNext(t);
            }
        } else {
            this.observer.onNext(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable e) {
        block16: {
            try {
                Span span = this.getSpan();
                Span activeSpan = this.tracer.activeSpan();
                if (!(span == null || activeSpan != null && span.equals(activeSpan))) {
                    try (Scope ignore = this.tracer.scopeManager().activate(this.getSpan(), false);){
                        this.observer.onError(e);
                        break block16;
                    }
                }
                this.observer.onError(e);
            }
            finally {
                super.onError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompleted() {
        block16: {
            try {
                Span span = this.getSpan();
                Span activeSpan = this.tracer.activeSpan();
                if (!(span == null || activeSpan != null && span.equals(activeSpan))) {
                    try (Scope ignore = this.tracer.scopeManager().activate(this.getSpan(), false);){
                        this.observer.onCompleted();
                        break block16;
                    }
                }
                this.observer.onCompleted();
            }
            finally {
                super.onCompleted();
            }
        }
    }
}

