/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.rxjava;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.rxjava.AbstractTracingSubscriber;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;

public class TracingSubscriber<T>
extends AbstractTracingSubscriber<T> {
    private final Subscriber<T> subscriber;
    private final Tracer tracer;

    public TracingSubscriber(Subscriber<T> subscriber, String operationName, Tracer tracer) {
        this(subscriber, operationName, "rxjava-1", tracer);
    }

    public TracingSubscriber(Subscriber<T> subscriber, String operationName, String componentName, Tracer tracer) {
        super(operationName, componentName, tracer);
        if (subscriber == null) {
            throw new IllegalArgumentException("subscriber can not be null");
        }
        this.subscriber = subscriber;
        this.tracer = tracer;
        subscriber.add((Subscription)this);
    }

    @Override
    public void onStart() {
        super.onStart();
        Span span = this.getSpan();
        Span activeSpan = this.tracer.activeSpan();
        if (!(span == null || activeSpan != null && span.equals(activeSpan))) {
            try (Scope ignore = this.tracer.scopeManager().activate(this.getSpan(), false);){
                this.subscriber.onStart();
            }
        } else {
            this.subscriber.onStart();
        }
    }

    @Override
    public void onNext(T o) {
        Span span = this.getSpan();
        Span activeSpan = this.tracer.activeSpan();
        if (!(span == null || activeSpan != null && span.equals(activeSpan))) {
            try (Scope ignore = this.tracer.scopeManager().activate(this.getSpan(), false);){
                this.subscriber.onNext(o);
            }
        } else {
            this.subscriber.onNext(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable t) {
        block16: {
            try {
                Span span = this.getSpan();
                Span activeSpan = this.tracer.activeSpan();
                if (!(span == null || activeSpan != null && span.equals(activeSpan))) {
                    try (Scope ignore = this.tracer.scopeManager().activate(this.getSpan(), false);){
                        this.subscriber.onError(t);
                        break block16;
                    }
                }
                this.subscriber.onError(t);
            }
            finally {
                super.onError(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompleted() {
        block16: {
            try {
                Span span = this.getSpan();
                Span activeSpan = this.tracer.activeSpan();
                if (!(span == null || activeSpan != null && span.equals(activeSpan))) {
                    try (Scope ignore = this.tracer.scopeManager().activate(this.getSpan(), false);){
                        this.subscriber.onCompleted();
                        break block16;
                    }
                }
                this.subscriber.onCompleted();
            }
            finally {
                super.onCompleted();
            }
        }
    }

    public void setProducer(Producer p) {
        this.subscriber.setProducer(p);
    }
}

