/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.client;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.spanmanager.DefaultSpanManager;
import io.opentracing.contrib.spanmanager.SpanManager;
import io.opentracing.contrib.spring.web.client.HttpHeadersCarrier;
import io.opentracing.contrib.spring.web.client.RestTemplateSpanDecorator;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.AsyncClientHttpRequestExecution;
import org.springframework.http.client.AsyncClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public class TracingAsyncRestTemplateInterceptor
implements AsyncClientHttpRequestInterceptor {
    private static final Logger log = Logger.getLogger(TracingAsyncRestTemplateInterceptor.class.getName());
    private Tracer tracer;
    private SpanManager spanManager = DefaultSpanManager.getInstance();
    private List<RestTemplateSpanDecorator> spanDecorators;

    public TracingAsyncRestTemplateInterceptor() {
        this(GlobalTracer.get());
    }

    public TracingAsyncRestTemplateInterceptor(Tracer tracer) {
        this.tracer = tracer;
        this.spanDecorators = Collections.singletonList(new RestTemplateSpanDecorator.StandardTags());
    }

    public TracingAsyncRestTemplateInterceptor(Tracer tracer, List<RestTemplateSpanDecorator> spanDecorators) {
        this.tracer = tracer;
        this.spanDecorators = new ArrayList<RestTemplateSpanDecorator>(spanDecorators);
    }

    public ListenableFuture<ClientHttpResponse> intercept(final HttpRequest httpRequest, byte[] body, AsyncClientHttpRequestExecution execution) throws IOException {
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(httpRequest.getMethod().toString()).withTag(Tags.SPAN_KIND.getKey(), "client");
        SpanManager.ManagedSpan parentSpan = this.spanManager.current();
        if (parentSpan.getSpan() != null) {
            spanBuilder.asChildOf(parentSpan.getSpan());
        }
        final Span span = spanBuilder.start();
        this.tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new HttpHeadersCarrier(httpRequest.getHeaders()));
        for (RestTemplateSpanDecorator spanDecorator : this.spanDecorators) {
            try {
                spanDecorator.onRequest(httpRequest, span);
            }
            catch (RuntimeException exDecorator) {
                log.log(Level.SEVERE, "Exception during decorating span", exDecorator);
            }
        }
        ListenableFuture future = execution.executeAsync(httpRequest, body);
        future.addCallback((ListenableFutureCallback)new ListenableFutureCallback<ClientHttpResponse>(){

            public void onSuccess(ClientHttpResponse httpResponse) {
                for (RestTemplateSpanDecorator spanDecorator : TracingAsyncRestTemplateInterceptor.this.spanDecorators) {
                    try {
                        spanDecorator.onResponse(httpRequest, httpResponse, span);
                    }
                    catch (RuntimeException exDecorator) {
                        log.log(Level.SEVERE, "Exception during decorating span", exDecorator);
                    }
                }
                span.finish();
            }

            public void onFailure(Throwable ex) {
                for (RestTemplateSpanDecorator spanDecorator : TracingAsyncRestTemplateInterceptor.this.spanDecorators) {
                    try {
                        spanDecorator.onError(httpRequest, ex, span);
                    }
                    catch (RuntimeException exDecorator) {
                        log.log(Level.SEVERE, "Exception during decorating span", exDecorator);
                    }
                }
                span.finish();
            }
        });
        return future;
    }
}

