/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.client;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.spanmanager.DefaultSpanManager;
import io.opentracing.contrib.spanmanager.SpanManager;
import io.opentracing.contrib.spring.web.client.HttpHeadersCarrier;
import io.opentracing.contrib.spring.web.client.RestTemplateSpanDecorator;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class TracingRestTemplateInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = Logger.getLogger(TracingRestTemplateInterceptor.class.getName());
    private Tracer tracer;
    private List<RestTemplateSpanDecorator> spanDecorators;
    private SpanManager spanManager = DefaultSpanManager.getInstance();

    public TracingRestTemplateInterceptor() {
        this(GlobalTracer.get(), Collections.singletonList(new RestTemplateSpanDecorator.StandardTags()));
    }

    public TracingRestTemplateInterceptor(Tracer tracer) {
        this(tracer, Collections.singletonList(new RestTemplateSpanDecorator.StandardTags()));
    }

    public TracingRestTemplateInterceptor(Tracer tracer, List<RestTemplateSpanDecorator> spanDecorators) {
        this.tracer = tracer;
        this.spanDecorators = new ArrayList<RestTemplateSpanDecorator>(spanDecorators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientHttpResponse intercept(HttpRequest httpRequest, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        ClientHttpResponse httpResponse;
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(httpRequest.getMethod().toString()).withTag(Tags.SPAN_KIND.getKey(), "client");
        SpanManager.ManagedSpan parentSpan = this.spanManager.current();
        if (parentSpan.getSpan() != null) {
            spanBuilder.asChildOf(parentSpan.getSpan());
        }
        Span span = spanBuilder.start();
        try {
            this.tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new HttpHeadersCarrier(httpRequest.getHeaders()));
            for (RestTemplateSpanDecorator restTemplateSpanDecorator : this.spanDecorators) {
                try {
                    restTemplateSpanDecorator.onRequest(httpRequest, span);
                }
                catch (RuntimeException exDecorator) {
                    log.log(Level.SEVERE, "Exception during decorating span", exDecorator);
                }
            }
            try {
                httpResponse = execution.execute(httpRequest, body);
            }
            catch (Exception ex) {
                for (RestTemplateSpanDecorator spanDecorator : this.spanDecorators) {
                    try {
                        spanDecorator.onError(httpRequest, ex, span);
                    }
                    catch (RuntimeException exDecorator) {
                        log.log(Level.SEVERE, "Exception during decorating span", exDecorator);
                    }
                }
                throw ex;
            }
            for (RestTemplateSpanDecorator restTemplateSpanDecorator : this.spanDecorators) {
                try {
                    restTemplateSpanDecorator.onResponse(httpRequest, httpResponse, span);
                }
                catch (RuntimeException exDecorator) {
                    log.log(Level.SEVERE, "Exception during decorating span", exDecorator);
                }
            }
        }
        finally {
            span.finish();
        }
        return httpResponse;
    }
}

