/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.interceptor;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.spring.web.interceptor.HandlerInterceptorSpanDecorator;
import io.opentracing.contrib.spring.web.interceptor.InterceptorSpanWrapper;
import io.opentracing.contrib.web.servlet.filter.SpanWrapper;
import io.opentracing.contrib.web.servlet.filter.TracingFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class TracingHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = Logger.getLogger(TracingHandlerInterceptor.class.getName());
    static final String AFTER_CONCURRENT_HANDLING_STARTED = TracingHandlerInterceptor.class.getName() + ".afterConcurrentHandlingStarted";
    static final String CONTINUED_SERVER_SPAN = TracingHandlerInterceptor.class.getName() + ".continuedServerSpan";
    private Tracer tracer;
    private List<HandlerInterceptorSpanDecorator> decorators;

    @Autowired
    public TracingHandlerInterceptor(Tracer tracer) {
        this(tracer, Collections.singletonList(HandlerInterceptorSpanDecorator.STANDARD_TAGS));
    }

    @Autowired
    public TracingHandlerInterceptor(Tracer tracer, List<HandlerInterceptorSpanDecorator> decorators) {
        this.tracer = tracer;
        this.decorators = new ArrayList<HandlerInterceptorSpanDecorator>(decorators);
    }

    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object handler) throws Exception {
        Object continuedSpanAttribute;
        Object spanAttribute = httpServletRequest.getAttribute(TracingFilter.SERVER_SPAN_WRAPPER);
        if (!(spanAttribute instanceof SpanWrapper)) {
            log.severe("Span not found! TracingFilter is not registered!?");
            return true;
        }
        if (httpServletRequest.getAttribute(AFTER_CONCURRENT_HANDLING_STARTED) != null) {
            httpServletRequest.removeAttribute(AFTER_CONCURRENT_HANDLING_STARTED);
            return true;
        }
        SpanWrapper filterSpan = (SpanWrapper)spanAttribute;
        Span serverSpan = filterSpan.get();
        if (filterSpan.isFinished() && ((continuedSpanAttribute = httpServletRequest.getAttribute(CONTINUED_SERVER_SPAN)) == null || continuedSpanAttribute instanceof InterceptorSpanWrapper && ((InterceptorSpanWrapper)((Object)continuedSpanAttribute)).isFinished())) {
            serverSpan = this.tracer.buildSpan(httpServletRequest.getMethod()).addReference("follows_from", filterSpan.get().context()).start();
            httpServletRequest.setAttribute(CONTINUED_SERVER_SPAN, (Object)new InterceptorSpanWrapper(serverSpan, handler));
            httpServletRequest.setAttribute(TracingFilter.SERVER_SPAN_CONTEXT, (Object)serverSpan.context());
        }
        if (filterSpan.isTraced()) {
            for (HandlerInterceptorSpanDecorator decorator : this.decorators) {
                decorator.onPreHandle(httpServletRequest, handler, serverSpan);
            }
        }
        return true;
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        request.setAttribute(AFTER_CONCURRENT_HANDLING_STARTED, (Object)Boolean.TRUE);
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object handler, Exception ex) throws Exception {
        Object spanAttribute = httpServletRequest.getAttribute(TracingFilter.SERVER_SPAN_WRAPPER);
        if (!(spanAttribute instanceof SpanWrapper)) {
            log.severe("Span not found! TracingFilter is not registered!?");
            return;
        }
        SpanWrapper filterSpan = (SpanWrapper)spanAttribute;
        Span serverSpan = filterSpan.get();
        if (filterSpan.isFinished()) {
            serverSpan = ((InterceptorSpanWrapper)((Object)httpServletRequest.getAttribute(CONTINUED_SERVER_SPAN))).get();
        }
        if (filterSpan.isTraced()) {
            for (HandlerInterceptorSpanDecorator decorator : this.decorators) {
                decorator.onAfterCompletion(httpServletRequest, httpServletResponse, handler, ex, serverSpan);
            }
        }
        if (filterSpan.isFinished()) {
            ((InterceptorSpanWrapper)((Object)httpServletRequest.getAttribute(CONTINUED_SERVER_SPAN))).finish(handler);
        }
    }

    protected boolean isTraced(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object handler) {
        return true;
    }

    public static SpanContext serverSpanContext(ServletRequest servletRequest) {
        return (SpanContext)servletRequest.getAttribute(TracingFilter.SERVER_SPAN_CONTEXT);
    }
}

