/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.server;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.ipc.netty.ByteBufFlux;
import reactor.ipc.netty.http.server.DefaultHttpServerRoutes;
import reactor.ipc.netty.http.server.HttpPredicate;
import reactor.ipc.netty.http.server.HttpServerOperations;
import reactor.ipc.netty.http.server.HttpServerRequest;
import reactor.ipc.netty.http.server.HttpServerResponse;
import reactor.ipc.netty.http.websocket.WebsocketInbound;
import reactor.ipc.netty.http.websocket.WebsocketOutbound;

public interface HttpServerRoutes
extends BiFunction<HttpServerRequest, HttpServerResponse, Publisher<Void>> {
    public static final Predicate<HttpServerRequest> INDEX_PREDICATE = req -> {
        URI uri = URI.create(req.uri());
        return req.method() == HttpMethod.GET && (uri.getPath().endsWith("/") || uri.getPath().indexOf(".", uri.getPath().lastIndexOf("/")) == -1);
    };

    public static HttpServerRoutes newRoutes() {
        return new DefaultHttpServerRoutes();
    }

    default public HttpServerRoutes delete(String path, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        return this.route(HttpPredicate.delete(path), handler);
    }

    default public HttpServerRoutes directory(String uri, Path directory) {
        return this.directory(uri, directory, null);
    }

    public HttpServerRoutes directory(String var1, Path var2, Function<HttpServerResponse, HttpServerResponse> var3);

    default public HttpServerRoutes file(String uri, Path path) {
        return this.file(HttpPredicate.get(uri), path, null);
    }

    default public HttpServerRoutes file(String uri, String path) {
        return this.file(HttpPredicate.get(uri), Paths.get(path, new String[0]), null);
    }

    default public HttpServerRoutes file(Predicate<HttpServerRequest> uri, Path path, Function<HttpServerResponse, HttpServerResponse> interceptor) {
        Objects.requireNonNull(path, "path");
        return this.route(uri, (req, resp) -> {
            if (!Files.isReadable(path)) {
                return resp.send((Publisher)ByteBufFlux.fromPath(path));
            }
            if (interceptor != null) {
                return ((HttpServerResponse)interceptor.apply((HttpServerResponse)resp)).sendFile(path);
            }
            return resp.sendFile(path);
        });
    }

    default public HttpServerRoutes get(String path, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        return this.route(HttpPredicate.get(path), handler);
    }

    default public HttpServerRoutes index(BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        return this.route(INDEX_PREDICATE, handler);
    }

    default public HttpServerRoutes post(String path, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        return this.route(HttpPredicate.post(path), handler);
    }

    default public HttpServerRoutes put(String path, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        return this.route(HttpPredicate.put(path), handler);
    }

    public HttpServerRoutes route(Predicate<? super HttpServerRequest> var1, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> var2);

    default public HttpServerRoutes ws(String path, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> handler) {
        return this.ws(path, handler, null);
    }

    default public HttpServerRoutes ws(String path, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> handler, String protocols) {
        Predicate<HttpServerRequest> condition = HttpPredicate.get(path);
        return this.route(condition, (req, resp) -> {
            if (req.requestHeaders().contains((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.UPGRADE, true)) {
                HttpServerOperations ops = (HttpServerOperations)req;
                return ops.withWebsocketSupport(req.uri(), protocols, handler);
            }
            return resp.sendNotFound();
        });
    }
}

