/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.resources;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import reactor.ipc.netty.resources.DefaultLoopEpollDetector;
import reactor.ipc.netty.resources.LoopResources;

final class DefaultLoopResources
extends AtomicLong
implements LoopResources {
    final String prefix;
    final boolean daemon;
    final int selectCount;
    final int workerCount;
    final EventLoopGroup serverLoops;
    final EventLoopGroup clientLoops;
    final EventLoopGroup serverSelectLoops;
    final AtomicReference<EventLoopGroup> cacheNativeClientLoops;
    final AtomicReference<EventLoopGroup> cacheNativeServerLoops;
    final AtomicReference<EventLoopGroup> cacheNativeSelectLoops;
    final AtomicBoolean running = new AtomicBoolean();

    static ThreadFactory threadFactory(DefaultLoopResources parent, String prefix) {
        return new EventLoopSelectorFactory(parent.daemon, parent.prefix + "-" + prefix, parent);
    }

    DefaultLoopResources(String prefix, int workerCount, boolean daemon) {
        this(prefix, -1, workerCount, daemon);
    }

    DefaultLoopResources(String prefix, int selectCount, int workerCount, boolean daemon) {
        this.daemon = daemon;
        this.workerCount = workerCount;
        this.prefix = prefix;
        this.serverLoops = new NioEventLoopGroup(workerCount, DefaultLoopResources.threadFactory(this, "nio"));
        this.clientLoops = LoopResources.colocate(this.serverLoops);
        this.cacheNativeClientLoops = new AtomicReference();
        this.cacheNativeServerLoops = new AtomicReference();
        if (selectCount == -1) {
            this.selectCount = workerCount;
            this.serverSelectLoops = this.serverLoops;
            this.cacheNativeSelectLoops = this.cacheNativeServerLoops;
        } else {
            this.selectCount = selectCount;
            this.serverSelectLoops = new NioEventLoopGroup(selectCount, DefaultLoopResources.threadFactory(this, "select-nio"));
            this.cacheNativeSelectLoops = new AtomicReference();
        }
    }

    @Override
    public void dispose() {
        if (this.running.compareAndSet(false, true)) {
            this.clientLoops.shutdownGracefully();
            this.serverSelectLoops.shutdownGracefully();
            this.serverLoops.shutdownGracefully();
            EventLoopGroup group = this.cacheNativeClientLoops.get();
            if (group != null) {
                group.shutdownGracefully();
            }
            if ((group = this.cacheNativeSelectLoops.get()) != null) {
                group.shutdownGracefully();
            }
            if ((group = this.cacheNativeServerLoops.get()) != null) {
                group.shutdownGracefully();
            }
        }
    }

    @Override
    public EventLoopGroup onServerSelect(boolean useNative) {
        if (useNative && this.preferNative()) {
            return this.cacheNativeSelectLoops();
        }
        return this.serverSelectLoops;
    }

    @Override
    public EventLoopGroup onServer(boolean useNative) {
        if (useNative && this.preferNative()) {
            return this.cacheNativeServerLoops();
        }
        return this.serverLoops;
    }

    @Override
    public EventLoopGroup onClient(boolean useNative) {
        if (useNative && this.preferNative()) {
            return this.cacheNativeClientLoops();
        }
        return this.clientLoops;
    }

    EventLoopGroup cacheNativeSelectLoops() {
        if (this.cacheNativeSelectLoops == this.cacheNativeServerLoops) {
            return this.cacheNativeServerLoops();
        }
        EventLoopGroup eventLoopGroup = this.cacheNativeSelectLoops.get();
        if (null == eventLoopGroup) {
            EventLoopGroup newEventLoopGroup = DefaultLoopEpollDetector.newEventLoopGroup(this.selectCount, DefaultLoopResources.threadFactory(this, "select-epoll"));
            if (!this.cacheNativeSelectLoops.compareAndSet(null, newEventLoopGroup)) {
                newEventLoopGroup.shutdownGracefully();
            }
            eventLoopGroup = this.cacheNativeSelectLoops();
        }
        return eventLoopGroup;
    }

    EventLoopGroup cacheNativeServerLoops() {
        EventLoopGroup eventLoopGroup = this.cacheNativeServerLoops.get();
        if (null == eventLoopGroup) {
            EventLoopGroup newEventLoopGroup = DefaultLoopEpollDetector.newEventLoopGroup(this.workerCount, DefaultLoopResources.threadFactory(this, "server-epoll"));
            if (!this.cacheNativeServerLoops.compareAndSet(null, newEventLoopGroup)) {
                newEventLoopGroup.shutdownGracefully();
            }
            eventLoopGroup = this.cacheNativeServerLoops();
        }
        return eventLoopGroup;
    }

    EventLoopGroup cacheNativeClientLoops() {
        EventLoopGroup eventLoopGroup = this.cacheNativeClientLoops.get();
        if (null == eventLoopGroup) {
            EventLoopGroup newEventLoopGroup = DefaultLoopEpollDetector.newEventLoopGroup(this.workerCount, DefaultLoopResources.threadFactory(this, "client-epoll"));
            if (!this.cacheNativeClientLoops.compareAndSet(null, newEventLoopGroup = LoopResources.colocate(newEventLoopGroup))) {
                newEventLoopGroup.shutdownGracefully();
            }
            eventLoopGroup = this.cacheNativeClientLoops();
        }
        return eventLoopGroup;
    }

    static final class EventLoopSelectorFactory
    implements ThreadFactory {
        final boolean daemon;
        final AtomicLong counter;
        final String prefix;

        public EventLoopSelectorFactory(boolean daemon, String prefix, AtomicLong counter) {
            this.daemon = daemon;
            this.counter = counter;
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(this.daemon);
            t.setName(this.prefix + "-" + this.counter.incrementAndGet());
            return t;
        }
    }
}

