/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.resources;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.Objects;
import reactor.core.Disposable;
import reactor.ipc.netty.resources.ColocatedEventLoopGroup;
import reactor.ipc.netty.resources.DefaultLoopEpollDetector;
import reactor.ipc.netty.resources.DefaultLoopResources;

@FunctionalInterface
public interface LoopResources
extends Disposable {
    public static final int DEFAULT_IO_WORKER_COUNT = Integer.parseInt(System.getProperty("reactor.ipc.netty.workerCount", "" + Math.max(Runtime.getRuntime().availableProcessors(), 4)));
    public static final int DEFAULT_IO_SELECT_COUNT = Integer.parseInt(System.getProperty("reactor.ipc.netty.selectCount", "-1"));

    public static EventLoopGroup colocate(EventLoopGroup group) {
        return new ColocatedEventLoopGroup(group);
    }

    public static LoopResources create(String prefix, int workerCount, boolean daemon) {
        if (workerCount < 1) {
            throw new IllegalArgumentException("Must provide a strictly positive worker number, was: " + workerCount);
        }
        return new DefaultLoopResources(prefix, workerCount, daemon);
    }

    public static LoopResources create(String prefix, int selectCount, int workerCount, boolean daemon) {
        if (Objects.requireNonNull(prefix, "prefix").isEmpty()) {
            throw new IllegalArgumentException("Cannot use empty prefix");
        }
        if (workerCount < 1) {
            throw new IllegalArgumentException("Must provide a strictly positive worker number, was: " + workerCount);
        }
        if (selectCount < 1) {
            throw new IllegalArgumentException("Must provide a strictly positive worker number, was: " + workerCount);
        }
        return new DefaultLoopResources(prefix, selectCount, workerCount, daemon);
    }

    public static LoopResources create(String prefix) {
        return new DefaultLoopResources(prefix, DEFAULT_IO_SELECT_COUNT, DEFAULT_IO_WORKER_COUNT, true);
    }

    default public Class<? extends Channel> onChannel(EventLoopGroup group) {
        return this.preferNative() ? DefaultLoopEpollDetector.getChannel(group) : NioSocketChannel.class;
    }

    default public EventLoopGroup onClient(boolean useNative) {
        return this.onServer(useNative);
    }

    default public Class<? extends DatagramChannel> onDatagramChannel(EventLoopGroup group) {
        return this.preferNative() ? DefaultLoopEpollDetector.getDatagramChannel(group) : NioDatagramChannel.class;
    }

    public EventLoopGroup onServer(boolean var1);

    default public Class<? extends ServerChannel> onServerChannel(EventLoopGroup group) {
        return this.preferNative() ? DefaultLoopEpollDetector.getServerChannel(group) : NioServerSocketChannel.class;
    }

    default public EventLoopGroup onServerSelect(boolean useNative) {
        return this.onServer(useNative);
    }

    default public boolean preferNative() {
        return DefaultLoopEpollDetector.hasEpoll();
    }

    default public boolean daemon() {
        return false;
    }

    default public void dispose() {
    }
}

