/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.ipc.netty.NettyConnector;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.channel.ChannelOperations;
import reactor.ipc.netty.channel.ContextHandler;
import reactor.ipc.netty.options.ClientOptions;
import reactor.ipc.netty.options.NettyOptions;
import reactor.ipc.netty.resources.PoolResources;
import reactor.ipc.netty.tcp.TcpResources;

public class TcpClient
implements NettyConnector<NettyInbound, NettyOutbound> {
    final ClientOptions options;
    protected static final ChannelOperations.OnNew EMPTY = (a, b, c) -> null;
    static final LoggingHandler loggingHandler = new LoggingHandler(TcpClient.class);

    public static TcpClient create() {
        return TcpClient.create(NetUtil.LOCALHOST.getHostAddress());
    }

    public static TcpClient create(String bindAddress) {
        return TcpClient.create(bindAddress, NettyOptions.DEFAULT_PORT);
    }

    public static TcpClient create(int port) {
        return TcpClient.create(NetUtil.LOCALHOST.getHostAddress(), port);
    }

    public static TcpClient create(String bindAddress, int port) {
        return TcpClient.create((? super ClientOptions opts) -> opts.connect(bindAddress, port));
    }

    public static TcpClient create(Consumer<? super ClientOptions> options) {
        Objects.requireNonNull(options, "options");
        ClientOptions clientOptions = ClientOptions.create();
        ((ClientOptions)clientOptions.loopResources(TcpResources.get())).poolResources(TcpResources.get());
        options.accept(clientOptions);
        return new TcpClient(clientOptions.duplicate());
    }

    protected TcpClient(ClientOptions options) {
        this.options = Objects.requireNonNull(options, "options");
    }

    public final ClientOptions options() {
        return this.options;
    }

    public final Mono<? extends NettyContext> newHandler(BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler) {
        Objects.requireNonNull(handler, "handler");
        return this.newHandler(handler, null, true, null);
    }

    public String toString() {
        return "TcpClient:" + this.options.toString();
    }

    protected Mono<NettyContext> newHandler(BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler, InetSocketAddress address, boolean secure, Consumer<? super Channel> onSetup) {
        BiFunction<Object, Object, Object> targetHandler = null == handler ? ChannelOperations.noopHandler() : handler;
        return Mono.create((T sink) -> {
            InetSocketAddress remote = address != null ? address : this.options.getAddress();
            ChannelPool pool = null;
            PoolResources poolResources = this.options.getPoolResources();
            if (poolResources != null) {
                pool = poolResources.selectOrCreate(remote, this.options, this.doHandler(null, (MonoSink<NettyContext>)sink, secure, remote, null, null), this.options.getLoopResources().onClient(this.options.preferNative()));
            }
            ContextHandler<SocketChannel> contextHandler = this.doHandler(targetHandler, (MonoSink<NettyContext>)sink, secure, remote, pool, onSetup);
            if (pool == null) {
                Bootstrap b = this.options.get();
                b.remoteAddress((SocketAddress)remote);
                b.handler(contextHandler);
                contextHandler.setFuture((Future<?>)b.connect());
            } else {
                contextHandler.setFuture(pool.acquire());
            }
        });
    }

    protected ContextHandler<SocketChannel> doHandler(BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler, MonoSink<NettyContext> sink, boolean secure, SocketAddress providedAddress, ChannelPool pool, Consumer<? super Channel> onSetup) {
        return ContextHandler.newClientContext(sink, this.options, loggingHandler, secure, providedAddress, pool, handler == null ? EMPTY : (ch, c, msg) -> ChannelOperations.bind(ch, handler, c));
    }
}

