/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCounted;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.core.publisher.UnicastProcessor;
import reactor.ipc.netty.ByteBufFlux;
import reactor.ipc.netty.http.multipart.MultipartTokenizer;
import reactor.util.concurrent.QueueSupplier;

final class MultipartParser
implements Subscriber<MultipartTokenizer.Token>,
Subscription,
Disposable {
    final Subscriber<? super ByteBufFlux> actual;
    final ByteBufAllocator alloc;
    volatile int wip;
    static final AtomicIntegerFieldUpdater<MultipartParser> WIP = AtomicIntegerFieldUpdater.newUpdater(MultipartParser.class, "wip");
    volatile int once;
    static final AtomicIntegerFieldUpdater<MultipartParser> ONCE = AtomicIntegerFieldUpdater.newUpdater(MultipartParser.class, "once");
    Subscription s;
    UnicastProcessor<ByteBuf> window;
    boolean done;

    MultipartParser(Subscriber<? super ByteBufFlux> actual, ByteBufAllocator alloc) {
        this.actual = actual;
        this.wip = 1;
        this.alloc = alloc;
    }

    public void onSubscribe(Subscription s) {
        if (Operators.validate((Subscription)this.s, (Subscription)s)) {
            this.s = s;
            this.actual.onSubscribe((Subscription)this);
        }
    }

    public void onNext(MultipartTokenizer.Token token) {
        if (this.done) {
            Operators.onNextDropped((Object)token);
            return;
        }
        UnicastProcessor w = this.window;
        switch (token.getKind()) {
            case BODY: {
                if (this.window != null) {
                    token.getByteBuf().touch();
                    this.window.onNext((Object)token.getByteBuf().retain());
                    return;
                }
                this.s.cancel();
                this.actual.onError((Throwable)new IllegalStateException("Body received before delimiter"));
                break;
            }
            case CLOSE_DELIMITER: {
                this.s.cancel();
                this.onComplete();
                break;
            }
            case DELIMITER: {
                if (this.window != null) {
                    this.window = null;
                    w.onComplete();
                }
                WIP.getAndIncrement(this);
                this.window = w = UnicastProcessor.create((Queue)((Queue)QueueSupplier.unbounded().get()), (Disposable)this);
                this.actual.onNext((Object)ByteBufFlux.fromInbound(w.flatMap(b -> Flux.using(() -> b, Flux::just, ReferenceCounted::release)), this.alloc));
            }
        }
    }

    public void onError(Throwable t) {
        if (this.done) {
            Operators.onErrorDropped((Throwable)t);
            return;
        }
        UnicastProcessor<ByteBuf> w = this.window;
        if (w != null) {
            this.window = null;
            w.onError(t);
        }
        this.actual.onError(t);
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        UnicastProcessor<ByteBuf> w = this.window;
        if (w != null) {
            this.window = null;
            w.onComplete();
        }
        this.actual.onComplete();
    }

    public void request(long n) {
        this.s.request(n);
    }

    public void cancel() {
        if (ONCE.compareAndSet(this, 0, 1)) {
            this.dispose();
        }
    }

    public void dispose() {
        if (WIP.decrementAndGet(this) == 0) {
            this.s.cancel();
        }
    }
}

