/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.options;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.AttributeKey;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.Consumer;
import reactor.core.Exceptions;
import reactor.ipc.netty.options.NettyOptions;
import reactor.ipc.netty.resources.LoopResources;

public class ServerOptions
extends NettyOptions<ServerBootstrap, ServerOptions> {
    SocketAddress localAddress = LOCALHOST_AUTO_PORT;
    static final InetSocketAddress LOCALHOST_AUTO_PORT = new InetSocketAddress(0);

    public static ServerOptions create() {
        return new ServerOptions();
    }

    static void defaultServerOptions(ServerBootstrap bootstrap) {
        ((ServerBootstrap)((ServerBootstrap)bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_BACKLOG, (Object)1000)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.SO_RCVBUF, (Object)0x100000).childOption(ChannelOption.SO_SNDBUF, (Object)0x100000).childOption(ChannelOption.AUTO_READ, (Object)false).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.SO_LINGER, (Object)0).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)30000);
    }

    protected ServerOptions() {
        this(new ServerBootstrap());
    }

    protected ServerOptions(ServerBootstrap serverBootstrap) {
        super(serverBootstrap);
        ServerOptions.defaultServerOptions(serverBootstrap);
    }

    protected ServerOptions(ServerOptions options) {
        super(options);
        this.localAddress = options.localAddress;
    }

    @Override
    public <T> ServerOptions attr(AttributeKey<T> key, T value) {
        ((ServerBootstrap)this.bootstrapTemplate).childAttr(key, value);
        return this;
    }

    @Override
    public ServerOptions duplicate() {
        return new ServerOptions(this);
    }

    @Override
    public ServerBootstrap get() {
        ServerBootstrap b = (ServerBootstrap)super.get();
        this.groupAndChannel(b);
        return b;
    }

    @Override
    public final SocketAddress getAddress() {
        return this.localAddress;
    }

    public ServerOptions listen(int port) {
        return this.listen(new InetSocketAddress(port));
    }

    public ServerOptions listen(String host) {
        if (null == host) {
            host = "localhost";
        }
        return this.listen(new InetSocketAddress(host, 0));
    }

    public ServerOptions listen(String host, int port) {
        if (null == host) {
            host = "localhost";
        }
        return this.listen(new InetSocketAddress(host, port));
    }

    public ServerOptions listen(InetSocketAddress listenAddress) {
        Objects.requireNonNull(listenAddress, "listenAddress");
        this.localAddress = listenAddress;
        return this;
    }

    @Override
    public <T> ServerOptions option(ChannelOption<T> key, T value) {
        ((ServerBootstrap)this.bootstrapTemplate).childOption(key, value);
        return this;
    }

    public <T> ServerOptions selectorAttr(AttributeKey<T> key, T value) {
        ((ServerBootstrap)this.bootstrapTemplate).childAttr(key, value);
        return this;
    }

    public <T> ServerOptions selectorOption(ChannelOption<T> key, T value) {
        ((ServerBootstrap)this.bootstrapTemplate).childOption(key, value);
        return this;
    }

    public ServerOptions sslSelfSigned() {
        return this.sslSelfSigned(c -> {});
    }

    public ServerOptions sslSelfSigned(Consumer<? super SslContextBuilder> configurator) {
        Objects.requireNonNull(configurator, "configurator");
        try {
            SelfSignedCertificate ssc = new SelfSignedCertificate();
            SslContextBuilder builder = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey());
            configurator.accept((SslContextBuilder)builder);
            return (ServerOptions)this.sslContext(builder.build());
        }
        catch (Exception sslException) {
            throw Exceptions.bubble((Throwable)sslException);
        }
    }

    final void groupAndChannel(ServerBootstrap bootstrap) {
        LoopResources loops = Objects.requireNonNull(this.loopResources, "loopResources");
        boolean useNative = this.preferNative && !(this.sslContext instanceof JdkSslContext);
        EventLoopGroup selectorGroup = loops.onServerSelect(useNative);
        EventLoopGroup elg = loops.onServer(useNative);
        bootstrap.group(selectorGroup, elg).channel(loops.onServerChannel(elg));
    }
}

