/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.receiver.internals;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import reactor.core.Disposable;
import reactor.core.scheduler.NonBlocking;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.Logger;
import reactor.util.Loggers;

class KafkaSchedulers {
    static final Logger log = Loggers.getLogger(Schedulers.class);

    KafkaSchedulers() {
    }

    static final void defaultUncaughtException(Thread t, Throwable e) {
        log.error("KafkaScheduler worker in group " + t.getThreadGroup().getName() + " failed with an uncaught exception", e);
    }

    static EventScheduler newEvent(String groupId) {
        return new EventScheduler(groupId);
    }

    static final class EventThreadFactory
    implements ThreadFactory {
        static final String PREFIX = "reactive-kafka-";
        static final AtomicLong COUNTER_REFERENCE = new AtomicLong();
        private final String groupId;

        EventThreadFactory(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Thread newThread(Runnable runnable) {
            String newThreadName = PREFIX + this.groupId + "-" + COUNTER_REFERENCE.incrementAndGet();
            EmitterThread t = new EmitterThread(runnable, newThreadName);
            t.setUncaughtExceptionHandler(KafkaSchedulers::defaultUncaughtException);
            return t;
        }

        static final class EmitterThread
        extends Thread
        implements NonBlocking {
            EmitterThread(Runnable target, String name) {
                super(target, name);
            }
        }
    }

    static final class EventScheduler
    implements Scheduler {
        final ThreadLocal<Boolean> holder = ThreadLocal.withInitial(() -> false);
        final Scheduler inner;

        private EventScheduler(String groupId) {
            this.inner = Schedulers.newSingle((ThreadFactory)new EventThreadFactory(groupId));
        }

        public Disposable schedule(Runnable task) {
            return this.inner.schedule(this.decorate(task));
        }

        public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
            return this.inner.schedule(this.decorate(task), delay, unit);
        }

        public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
            return this.inner.schedulePeriodically(this.decorate(task), initialDelay, period, unit);
        }

        public long now(TimeUnit unit) {
            return this.inner.now(unit);
        }

        public Scheduler.Worker createWorker() {
            return new EventWorker(this.inner.createWorker());
        }

        public void dispose() {
            this.inner.dispose();
        }

        public boolean isDisposed() {
            return this.inner.isDisposed();
        }

        public void start() {
            this.inner.start();
        }

        boolean isCurrentThreadFromScheduler() {
            return this.holder.get();
        }

        private Runnable decorate(Runnable task) {
            return () -> {
                this.holder.set(true);
                task.run();
            };
        }

        final class EventWorker
        implements Scheduler.Worker {
            final Scheduler.Worker actual;

            EventWorker(Scheduler.Worker actual) {
                this.actual = actual;
            }

            public void dispose() {
                this.actual.dispose();
            }

            public boolean isDisposed() {
                return this.actual.isDisposed();
            }

            public Disposable schedule(Runnable task) {
                return this.actual.schedule(EventScheduler.this.decorate(task));
            }

            public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
                return this.actual.schedule(EventScheduler.this.decorate(task), delay, unit);
            }

            public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
                return this.actual.schedulePeriodically(EventScheduler.this.decorate(task), initialDelay, period, unit);
            }
        }
    }
}

