/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.sender;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.serialization.Serializer;
import reactor.core.scheduler.Scheduler;
import reactor.kafka.sender.SenderOptions;

class ImmutableSenderOptions<K, V>
implements SenderOptions<K, V> {
    private final Map<String, Object> properties;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private final Duration closeTimeout;
    private final Scheduler scheduler;
    private final int maxInFlight;
    private final boolean stopOnError;

    ImmutableSenderOptions(SenderOptions<K, V> options) {
        this(new HashMap<String, Object>(options.producerProperties()), options.keySerializer(), options.valueSerializer(), options.closeTimeout(), options.scheduler(), options.maxInFlight(), options.stopOnError());
    }

    ImmutableSenderOptions(Map<String, Object> properties, Serializer<K> serializer, Serializer<V> valueSerializer, Duration timeout, Scheduler scheduler, int flight, boolean error) {
        this.properties = properties;
        this.keySerializer = serializer;
        this.valueSerializer = valueSerializer;
        this.closeTimeout = timeout;
        this.scheduler = scheduler;
        this.maxInFlight = flight;
        this.stopOnError = error;
    }

    @Override
    public Map<String, Object> producerProperties() {
        return new HashMap<String, Object>(this.properties);
    }

    @Override
    public Object producerProperty(String name) {
        Objects.requireNonNull(name);
        return this.properties.get(name);
    }

    @Override
    public SenderOptions<K, V> producerProperty(String name, Object value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        HashMap<String, Object> properties = new HashMap<String, Object>(this.properties);
        properties.put(name, value);
        return new ImmutableSenderOptions<K, V>(properties, this.keySerializer, this.valueSerializer, this.closeTimeout, this.scheduler, this.maxInFlight, this.stopOnError);
    }

    @Override
    public Serializer<K> keySerializer() {
        return this.keySerializer;
    }

    @Override
    public SenderOptions<K, V> withKeySerializer(Serializer<K> keySerializer) {
        return new ImmutableSenderOptions<K, V>(this.properties, Objects.requireNonNull(keySerializer), this.valueSerializer, this.closeTimeout, this.scheduler, this.maxInFlight, this.stopOnError);
    }

    @Override
    public Serializer<V> valueSerializer() {
        return this.valueSerializer;
    }

    @Override
    public SenderOptions<K, V> withValueSerializer(Serializer<V> valueSerializer) {
        return new ImmutableSenderOptions<K, V>(this.properties, this.keySerializer, Objects.requireNonNull(valueSerializer), this.closeTimeout, this.scheduler, this.maxInFlight, this.stopOnError);
    }

    @Override
    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public SenderOptions<K, V> scheduler(Scheduler scheduler) {
        return new ImmutableSenderOptions<K, V>(this.properties, this.keySerializer, this.valueSerializer, this.closeTimeout, Objects.requireNonNull(scheduler), this.maxInFlight, this.stopOnError);
    }

    @Override
    public int maxInFlight() {
        return this.maxInFlight;
    }

    @Override
    public SenderOptions<K, V> maxInFlight(int maxInFlight) {
        return new ImmutableSenderOptions<K, V>(this.properties, this.keySerializer, this.valueSerializer, this.closeTimeout, this.scheduler, maxInFlight, this.stopOnError);
    }

    @Override
    public boolean stopOnError() {
        return this.stopOnError;
    }

    @Override
    public SenderOptions<K, V> stopOnError(boolean stopOnError) {
        return new ImmutableSenderOptions<K, V>(this.properties, this.keySerializer, this.valueSerializer, this.closeTimeout, this.scheduler, this.maxInFlight, stopOnError);
    }

    @Override
    public Duration closeTimeout() {
        return this.closeTimeout;
    }

    @Override
    public SenderOptions<K, V> closeTimeout(Duration timeout) {
        return new ImmutableSenderOptions<K, V>(this.properties, this.keySerializer, this.valueSerializer, this.closeTimeout, this.scheduler, this.maxInFlight, this.stopOnError);
    }
}

