/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.sender;

import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import javax.naming.AuthenticationException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.serialization.Serializer;
import reactor.core.scheduler.Scheduler;
import reactor.kafka.sender.ImmutableSenderOptions;
import reactor.kafka.sender.MutableSenderOptions;
import reactor.util.annotation.NonNull;
import reactor.util.annotation.Nullable;

public interface SenderOptions<K, V> {
    @NonNull
    public static <K, V> SenderOptions<K, V> create() {
        return new MutableSenderOptions();
    }

    @NonNull
    public static <K, V> SenderOptions<K, V> create(@NonNull Map<String, Object> configProperties) {
        return new MutableSenderOptions(configProperties);
    }

    @NonNull
    public static <K, V> SenderOptions<K, V> create(@NonNull Properties configProperties) {
        return new MutableSenderOptions(configProperties);
    }

    @NonNull
    public Map<String, Object> producerProperties();

    @Nullable
    public Object producerProperty(@NonNull String var1);

    @NonNull
    public SenderOptions<K, V> producerProperty(@NonNull String var1, @NonNull Object var2);

    @Nullable
    public Serializer<K> keySerializer();

    @NonNull
    public SenderOptions<K, V> withKeySerializer(@NonNull Serializer<K> var1);

    @Nullable
    public Serializer<V> valueSerializer();

    @NonNull
    public SenderOptions<K, V> withValueSerializer(@NonNull Serializer<V> var1);

    @NonNull
    public Scheduler scheduler();

    @NonNull
    public SenderOptions<K, V> scheduler(@NonNull Scheduler var1);

    @NonNull
    public int maxInFlight();

    @NonNull
    public SenderOptions<K, V> maxInFlight(@NonNull int var1);

    @NonNull
    public boolean stopOnError();

    @NonNull
    public SenderOptions<K, V> stopOnError(@NonNull boolean var1);

    @NonNull
    public Duration closeTimeout();

    @NonNull
    public SenderOptions<K, V> closeTimeout(@NonNull Duration var1);

    @NonNull
    default public boolean isTransactional() {
        String transactionalId = this.transactionalId();
        return transactionalId != null && !transactionalId.isEmpty();
    }

    @Nullable
    default public String transactionalId() {
        return (String)this.producerProperty("transactional.id");
    }

    @NonNull
    default public boolean fatalException(@NonNull Throwable t) {
        return t instanceof AuthenticationException || t instanceof ProducerFencedException;
    }

    @NonNull
    @Deprecated
    default public SenderOptions<K, V> toImmutable() {
        if (this.isTransactional() && !this.stopOnError()) {
            throw new ConfigException("Transactional senders must be created with stopOnError=true");
        }
        return new ImmutableSenderOptions(this);
    }
}

