/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.antora;

import io.quarkiverse.antora.WebBundlerHandlerConfig;
import io.quarkus.runtime.util.StringUtil;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.FileSystemAccess;
import io.vertx.ext.web.handler.StaticHandler;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;

public class WebBundlerResourceHandler
implements Handler<RoutingContext> {
    public static final Set<HttpMethod> HANDLED_METHODS = Set.of(HttpMethod.HEAD, HttpMethod.OPTIONS, HttpMethod.GET);
    private static final Logger LOG = Logger.getLogger(WebBundlerResourceHandler.class);
    public static final String META_INF_ANTORA = "META-INF/antora";
    public static int DEFAULT_ROUTE_ORDER = 1050;
    private final WebBundlerHandlerConfig config;
    private final Set<String> webResources;
    private final Handler<RoutingContext> handler;
    private final ClassLoader currentClassLoader;

    WebBundlerResourceHandler(WebBundlerHandlerConfig config, String directory, Set<String> webResources) {
        this.config = config;
        this.webResources = WebBundlerResourceHandler.encodeUIResources(webResources);
        this.handler = WebBundlerResourceHandler.createStaticHandler(config, directory);
        this.currentClassLoader = Thread.currentThread().getContextClassLoader();
    }

    private static Set<String> encodeUIResources(Set<String> uiResources) {
        HashSet<String> encodedUIResources = new HashSet<String>(uiResources.size());
        for (String uiResource : uiResources) {
            encodedUIResources.add(WebBundlerResourceHandler.encodeURI(uiResource));
        }
        return encodedUIResources;
    }

    public void handle(RoutingContext ctx) {
        if (!WebBundlerResourceHandler.shouldHandleMethod(ctx)) {
            WebBundlerResourceHandler.next(this.currentClassLoader, ctx);
            return;
        }
        String path = WebBundlerResourceHandler.resolvePath(ctx);
        String resourcePath = path.endsWith("/") ? path + this.config.indexPage : path;
        LOG.debugf("Antora path hit: '%s'", (Object)resourcePath);
        if (this.webResources.contains(resourcePath)) {
            LOG.debugf("Antora resource served: '%s'", (Object)resourcePath);
            WebBundlerResourceHandler.compressIfNeeded(this.config, ctx, resourcePath);
            this.handler.handle((Object)ctx);
        } else {
            WebBundlerResourceHandler.next(this.currentClassLoader, ctx);
        }
    }

    private static Handler<RoutingContext> createStaticHandler(WebBundlerHandlerConfig config, String directory) {
        LOG.debugf("Static Index: '%s'", (Object)config.indexPage);
        if (StringUtil.isNullOrEmpty((String)config.indexPage)) {
            throw new IllegalStateException("Static index page is not configured!");
        }
        StaticHandler staticHandler = directory != null ? StaticHandler.create((FileSystemAccess)FileSystemAccess.ROOT, (String)directory) : StaticHandler.create((String)META_INF_ANTORA);
        staticHandler.setDefaultContentEncoding(StandardCharsets.UTF_8.name());
        staticHandler.setIndexPage(config.indexPage);
        staticHandler.setCachingEnabled(!config.devMode);
        return staticHandler;
    }

    private static String encodeURI(String string) {
        if (string == null) {
            return null;
        }
        return URLEncoder.encode(string, StandardCharsets.UTF_8).replace("+", "%20").replace("%21", "!").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%2F", "/").replace("%7E", "~");
    }

    static String resolvePath(RoutingContext ctx) {
        return ctx.mountPoint() == null ? ctx.normalizedPath() : ctx.normalizedPath().substring(ctx.mountPoint().endsWith("/") ? ctx.mountPoint().length() - 1 : ctx.mountPoint().length());
    }

    static void compressIfNeeded(WebBundlerHandlerConfig config, RoutingContext ctx, String path) {
        if (WebBundlerResourceHandler.isCompressed(config, path)) {
            ctx.response().headers().remove(HttpHeaders.CONTENT_ENCODING);
        }
    }

    private static boolean isCompressed(WebBundlerHandlerConfig config, String path) {
        if (config.compressMediaTypes.isEmpty()) {
            return false;
        }
        String contentType = MimeMapping.getMimeTypeForFilename((String)path);
        return contentType != null && config.compressMediaTypes.contains(contentType);
    }

    static boolean shouldHandleMethod(RoutingContext ctx) {
        return HANDLED_METHODS.contains(ctx.request().method());
    }

    static void next(ClassLoader cl, RoutingContext ctx) {
        Thread.currentThread().setContextClassLoader(cl);
        ctx.next();
    }
}

