/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.artemis.core.runtime;

import io.quarkus.artemis.core.runtime.ArtemisRuntimeConfig;
import io.quarkus.runtime.annotations.Recorder;
import java.util.function.Supplier;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;

@Recorder
public class ArtemisCoreRecorder {
    final ArtemisRuntimeConfig config;

    public ArtemisCoreRecorder(ArtemisRuntimeConfig config) {
        this.config = config;
    }

    public Supplier<ServerLocator> getServerLocatorSupplier() {
        return new Supplier<ServerLocator>(){

            @Override
            public ServerLocator get() {
                try {
                    return ActiveMQClient.createServerLocator((String)ArtemisCoreRecorder.this.config.url);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not create ServerLocator", e);
                }
            }
        };
    }
}

