/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AbstractApplicationBase;
import com.microsoft.aad.msal4j.AcquireTokenByAuthorizationGrantSupplier;
import com.microsoft.aad.msal4j.AcquireTokenByClientCredentialSupplier;
import com.microsoft.aad.msal4j.AcquireTokenByDeviceCodeFlowSupplier;
import com.microsoft.aad.msal4j.AcquireTokenByManagedIdentitySupplier;
import com.microsoft.aad.msal4j.AcquireTokenByOnBehalfOfSupplier;
import com.microsoft.aad.msal4j.AcquireTokenSilentSupplier;
import com.microsoft.aad.msal4j.AuthenticationResultSupplier;
import com.microsoft.aad.msal4j.ClientCredentialRequest;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.DeviceCodeFlowRequest;
import com.microsoft.aad.msal4j.InteractiveRequest;
import com.microsoft.aad.msal4j.ManagedIdentityApplication;
import com.microsoft.aad.msal4j.ManagedIdentityRequest;
import com.microsoft.aad.msal4j.MsalRequest;
import com.microsoft.aad.msal4j.OnBehalfOfRequest;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.SilentRequest;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.function.BooleanSupplier;

@TargetClass(className="com.microsoft.aad.msal4j.AbstractApplicationBase", onlyWith={Msal4jIsPresent.class})
public final class AbstractApplicationBaseSubstitutions {
    @Substitute
    private AuthenticationResultSupplier getAuthenticationResultSupplier(MsalRequest msalRequest) {
        Object supplier;
        if (msalRequest instanceof DeviceCodeFlowRequest) {
            supplier = new AcquireTokenByDeviceCodeFlowSupplier((PublicClientApplication)PublicClientApplication.class.cast(this), (DeviceCodeFlowRequest)msalRequest);
        } else if (msalRequest instanceof SilentRequest) {
            supplier = new AcquireTokenSilentSupplier((AbstractApplicationBase)AbstractApplicationBase.class.cast(this), (SilentRequest)msalRequest);
        } else {
            if (msalRequest instanceof InteractiveRequest) {
                throw new IllegalArgumentException("InteractiveRequest is not supported on GraalVM");
            }
            supplier = msalRequest instanceof ClientCredentialRequest ? new AcquireTokenByClientCredentialSupplier((ConfidentialClientApplication)ConfidentialClientApplication.class.cast(this), (ClientCredentialRequest)msalRequest) : (msalRequest instanceof OnBehalfOfRequest ? new AcquireTokenByOnBehalfOfSupplier((ConfidentialClientApplication)ConfidentialClientApplication.class.cast(this), (OnBehalfOfRequest)msalRequest) : (msalRequest instanceof ManagedIdentityRequest ? new AcquireTokenByManagedIdentitySupplier((ManagedIdentityApplication)ManagedIdentityApplication.class.cast(this), msalRequest) : new AcquireTokenByAuthorizationGrantSupplier((AbstractApplicationBase)AbstractApplicationBase.class.cast(this), msalRequest, null)));
        }
        return supplier;
    }

    static final class Msal4jIsPresent
    implements BooleanSupplier {
        Msal4jIsPresent() {
        }

        @Override
        public boolean getAsBoolean() {
            try {
                Thread.currentThread().getContextClassLoader().loadClass("com.microsoft.aad.msal4j.Credential");
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
    }
}

