/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.deployment;

import io.quarkiverse.cxf.CXFRecorder;
import io.quarkiverse.cxf.QuarkusBusFactory;
import io.quarkiverse.cxf.deployment.ClientSeiBuildItem;
import io.quarkiverse.cxf.deployment.CxfBuildTimeConfig;
import io.quarkiverse.cxf.deployment.CxfBusBuildItem;
import io.quarkiverse.cxf.deployment.CxfDeploymentUtils;
import io.quarkiverse.cxf.deployment.ServiceSeiBuildItem;
import io.quarkiverse.cxf.deployment.codegen.Wsdl2JavaCodeGen;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.UberJarMergedResourceBuildItem;
import io.quarkus.deployment.pkg.builditem.UberJarRequiredBuildItem;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.runtime.ShutdownContext;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.WebFault;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.extension.ExtensionManagerImpl;
import org.apache.cxf.common.spi.GeneratedClassClassLoaderCapture;
import org.apache.cxf.ws.addressing.JAXWSAConstants;
import org.apache.cxf.wsdl.WSDLConstants;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class QuarkusCxfProcessor {
    private static final String FEATURE_CXF = "cxf";
    private static final Logger LOGGER = Logger.getLogger(QuarkusCxfProcessor.class);

    QuarkusCxfProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE_CXF);
    }

    @BuildStep
    public void filterLogging(BuildProducer<LogCleanupFilterBuildItem> logCleanupProducer) {
        logCleanupProducer.produce((BuildItem)new LogCleanupFilterBuildItem("org.apache.cxf.wsdl.service.factory.ReflectionServiceFactoryBean", Level.FINE, new String[]{"Creating Service"}));
    }

    @BuildStep
    public void generateWSDL(OutputTargetBuildItem target, BuildProducer<NativeImageResourceBuildItem> resources, CxfBuildTimeConfig cxfBuildTimeConfig) {
        Path classesDir;
        if (cxfBuildTimeConfig.wsdlPath.isPresent()) {
            for (String wsdlPath : cxfBuildTimeConfig.wsdlPath.get()) {
                resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{wsdlPath}));
            }
        }
        if (Files.isDirectory(classesDir = target.getOutputDirectory().resolve("classes"), new LinkOption[0])) {
            LinkedHashSet wsdlResourcePaths = new LinkedHashSet();
            QuarkusCxfProcessor.scanWsdls(classesDir, cxfBuildTimeConfig.codegen.wsdl2java.rootParameterSet, "quarkus.cxf.codegen.wsdl2java", wsdlResourcePaths::add);
            for (Map.Entry<String, CxfBuildTimeConfig.Wsdl2JavaParameterSet> en : cxfBuildTimeConfig.codegen.wsdl2java.namedParameterSets.entrySet()) {
                QuarkusCxfProcessor.scanWsdls(target.getOutputDirectory(), en.getValue(), "quarkus.cxf.codegen.wsdl2java." + en.getKey(), wsdlResourcePaths::add);
            }
            if (!wsdlResourcePaths.isEmpty()) {
                resources.produce((BuildItem)new NativeImageResourceBuildItem(new ArrayList(wsdlResourcePaths)));
            }
        }
    }

    static void scanWsdls(Path inputDir, CxfBuildTimeConfig.Wsdl2JavaParameterSet params, String prefix, Consumer<String> resourcePathConsumer) {
        Wsdl2JavaCodeGen.scan(inputDir, params.includes.isPresent() ? params.includes : Optional.of(Collections.emptyList()), params.excludes, prefix, new HashMap<String, String>(), path -> resourcePathConsumer.accept(inputDir.relativize((Path)path).toString().replace('\\', '/')));
    }

    @BuildStep
    void markBeansAsUnremovable(BuildProducer<UnremovableBeanBuildItem> unremovables) {
        unremovables.produce((BuildItem)new UnremovableBeanBuildItem(beanInfo -> {
            String nameWithPackage = beanInfo.getBeanClass().local();
            return nameWithPackage.contains(".jaxws_asm") || nameWithPackage.endsWith("ObjectFactory");
        }));
    }

    @BuildStep
    CxfBusBuildItem bus() {
        Bus bus = BusFactory.getDefaultBus();
        return new CxfBusBuildItem(bus);
    }

    @BuildStep
    void generateRuntimeBusServiceFile(BuildProducer<GeneratedResourceBuildItem> generatedResources) {
        byte[] serviceFileContent = QuarkusBusFactory.class.getName().getBytes(StandardCharsets.UTF_8);
        generatedResources.produce((BuildItem)new GeneratedResourceBuildItem("META-INF/services/org.apache.cxf.bus.factory", serviceFileContent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BuildStep
    void generateClasses(CxfBusBuildItem busBuildItem, List<ClientSeiBuildItem> clients, List<ServiceSeiBuildItem> endpointImplementations, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        QuarkusCapture capture = new QuarkusCapture((ClassOutput)new GeneratedBeanGizmoAdaptor(generatedBeans));
        Bus bus = busBuildItem.getBus();
        GeneratedClassClassLoaderCapture oldCapture = (GeneratedClassClassLoaderCapture)bus.getExtension(GeneratedClassClassLoaderCapture.class);
        bus.setExtension((Object)capture, GeneratedClassClassLoaderCapture.class);
        try {
            Random rnd = new Random(System.currentTimeMillis());
            endpointImplementations.stream().map(ServiceSeiBuildItem::getSei).distinct().forEach(sei -> {
                LOGGER.infof("Generating ancillary classes for service %s", sei);
                String path = "/QuarkusCxfProcessor/dummy-" + rnd.nextLong();
                CxfDeploymentUtils.createServer(sei, path, bus);
            });
            clients.stream().map(ClientSeiBuildItem::getSei).distinct().forEach(sei -> {
                LOGGER.infof("Generating ancillary classes for client %s", sei);
                CxfDeploymentUtils.createClient(sei, bus);
            });
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, true, capture.getGeneratedClasses()));
        }
        finally {
            bus.setExtension((Object)oldCapture, GeneratedClassClassLoaderCapture.class);
        }
    }

    @BuildStep
    List<UberJarMergedResourceBuildItem> uberJarMergedResourceBuildItem() {
        return Arrays.asList(new UberJarMergedResourceBuildItem("META-INF/cxf/bus-extensions.txt"), new UberJarMergedResourceBuildItem("META-INF/wsdl.plugin.xml"));
    }

    @BuildStep
    void buildResources(BuildProducer<ReflectiveClassBuildItem> reflectiveItems, List<UberJarRequiredBuildItem> uberJarRequired, PackageConfig packageConfig, BuildProducer<GeneratedResourceBuildItem> generatedResources) {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();
             BufferedWriter out = new BufferedWriter(new OutputStreamWriter(os));){
            Enumeration<URL> urls = ExtensionManagerImpl.class.getClassLoader().getResources("META-INF/cxf/bus-extensions.txt");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                InputStream openStream = url.openStream();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(openStream, StandardCharsets.UTF_8));){
                    String line = reader.readLine();
                    while (line != null) {
                        String[] cols = line.split(":");
                        if (cols.length > 1) {
                            if (cols[0].length() > 0) {
                                reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{cols[0]}));
                            }
                            if (cols[1].length() > 0) {
                                reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{cols[1]}));
                            }
                        }
                        out.write(line);
                        out.newLine();
                        line = reader.readLine();
                    }
                }
                finally {
                    if (openStream == null) continue;
                    openStream.close();
                }
            }
            if ((!uberJarRequired.isEmpty() || packageConfig.type.equalsIgnoreCase("uber-jar")) && os.size() > 0) {
                generatedResources.produce((BuildItem)new GeneratedResourceBuildItem("META-INF/cxf/bus-extensions.txt", os.toByteArray()));
            }
        }
        catch (IOException e) {
            LOGGER.warn((Object)"cannot merge bus-extensions.txt");
        }
    }

    @BuildStep
    void buildXmlResources(List<UberJarRequiredBuildItem> uberJarRequired, PackageConfig packageConfig, BuildProducer<GeneratedResourceBuildItem> generatedResources) {
        if (uberJarRequired.isEmpty() && !packageConfig.type.equalsIgnoreCase("uber-jar")) {
            return;
        }
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            XPath xpath = XPathFactory.newInstance().newXPath();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            builder.setEntityResolver(new NoOpEntityResolver());
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> urls = loader.getResources("META-INF/wsdl.plugin.xml");
            Document mergedXmlDocument = builder.newDocument();
            Element root = mergedXmlDocument.createElement("properties");
            mergedXmlDocument.appendChild(root);
            for (URL url : Collections.list(urls)) {
                try (InputStreamReader inputStreamReader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);){
                    Document dDoc = builder.parse(new InputSource(inputStreamReader));
                    NodeList nodeList = (NodeList)xpath.compile("//entry").evaluate(dDoc, XPathConstants.NODESET);
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node = nodeList.item(i);
                        Node copyNode = mergedXmlDocument.importNode(node, true);
                        root.appendChild(copyNode);
                    }
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(mergedXmlDocument), new StreamResult(new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8)));
            if (os.size() > 0) {
                generatedResources.produce((BuildItem)new GeneratedResourceBuildItem("META-INF/wsdl.plugin.xml", os.toByteArray()));
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException | XPathExpressionException | SAXException e) {
            LOGGER.warn((Object)"cannot merge wsdl.plugin.xml");
        }
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem ssl() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE_CXF);
    }

    @BuildStep
    void runtimeInitializedClasses(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClass) {
        Stream.of("io.netty.buffer.PooledByteBufAllocator", "io.netty.buffer.UnpooledHeapByteBuf", "io.netty.buffer.UnpooledUnsafeHeapByteBuf", "io.netty.buffer.UnpooledByteBufAllocator$InstrumentedUnpooledUnsafeHeapByteBuf", "io.netty.buffer.AbstractReferenceCountedByteBuf", "org.apache.cxf.attachment.AttachmentSerializer", "org.apache.cxf.attachment.AttachmentUtil", "org.apache.cxf.attachment.ImageDataContentHandler", "org.apache.cxf.endpoint.ClientImpl", "org.apache.cxf.interceptor.AttachmentOutInterceptor", "org.apache.cxf.interceptor.OneWayProcessorInterceptor", "org.apache.cxf.interceptor.OneWayProcessorInterceptor$1", "org.apache.cxf.phase.PhaseInterceptorChain", "org.apache.cxf.service.factory.AbstractServiceFactoryBean", "org.apache.cxf.staxutils.validation.W3CMultiSchemaFactory", "org.apache.cxf.transport.http.HTTPConduit", "org.apache.cxf.transport.http.HTTPConduit$WrappedOutputStream", "org.apache.cxf.transport.http.HTTPConduit$WrappedOutputStream$1", "org.apache.cxf.ws.addressing.impl.InternalContextUtils", "org.apache.cxf.ws.addressing.impl.InternalContextUtils$1").map(RuntimeInitializedClassBuildItem::new).forEach(arg_0 -> runtimeInitializedClass.produce(arg_0));
        IndexView index = combinedIndexBuildItem.getIndex();
        Stream.of("org.apache.cxf.configuration.blueprint.AbstractBPBeanDefinitionParser").filter(cl -> index.getClassByName(DotName.createSimple((String)cl)) != null).map(RuntimeInitializedClassBuildItem::new).forEach(arg_0 -> runtimeInitializedClass.produce(arg_0));
    }

    @BuildStep
    void addDependencies(BuildProducer<IndexDependencyBuildItem> indexDependency) {
        Stream.of("io.quarkiverse.cxf:quarkus-cxf", "org.apache.cxf:cxf-core", "org.apache.cxf:cxf-rt-bindings-soap", "org.apache.cxf:cxf-rt-bindings-xml", "org.apache.cxf:cxf-rt-frontend-jaxws", "org.apache.cxf:cxf-rt-databinding-jaxb", "org.apache.cxf:cxf-rt-frontend-simple", "org.apache.cxf:cxf-rt-transports-http", "org.apache.cxf:cxf-rt-wsdl", "org.apache.cxf:cxf-rt-ws-addr", "org.apache.cxf:cxf-rt-ws-policy").forEach(ga -> {
            String[] coords = ga.split(":");
            indexDependency.produce((BuildItem)new IndexDependencyBuildItem(coords[0], coords[1]));
        });
    }

    @BuildStep
    void httpProxies(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<NativeImageProxyDefinitionBuildItem> proxies) {
        IndexView index = combinedIndexBuildItem.getIndex();
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"com.sun.xml.txw2.TypedXmlWriter"}));
        HashSet<String> proxiesCreated = new HashSet<String>();
        DotName typedXmlWriterDN = DotName.createSimple((String)"com.sun.xml.txw2.TypedXmlWriter");
        this.produceRecursiveProxies(index, typedXmlWriterDN, proxies, proxiesCreated);
    }

    @BuildStep
    void reflectiveClasses(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<UnremovableBeanBuildItem> unremovables) {
        IndexView index = combinedIndexBuildItem.getIndex();
        Stream.of("org.apache.cxf.databinding.DataBinding", "org.apache.cxf.interceptor.Interceptor", "org.apache.cxf.binding.soap.interceptor.SoapInterceptor", "org.apache.cxf.phase.PhaseInterceptor").map(DotName::createSimple).flatMap(dotName -> index.getAllKnownImplementors(dotName).stream()).map(classInfo -> classInfo.name().toString()).filter(className -> !className.startsWith("org.apache.cxf.") || !className.contains(".blueprint.")).map(className -> new ReflectiveClassBuildItem(false, false, new String[]{className})).forEach(arg_0 -> reflectiveClass.produce(arg_0));
        Stream.of("org.apache.cxf.feature.Feature").map(DotName::createSimple).flatMap(dotName -> index.getAllKnownImplementors(dotName).stream()).map(classInfo -> classInfo.name().toString()).map(className -> new ReflectiveClassBuildItem(true, false, new String[]{className})).forEach(arg_0 -> reflectiveClass.produce(arg_0));
        for (AnnotationInstance xmlNamespaceInstance : index.getAnnotations(DotName.createSimple((String)"com.sun.xml.txw2.annotation.XmlNamespace"))) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{xmlNamespaceInstance.target().asClass().name().toString()}));
        }
        String[] classes = (String[])index.getAnnotations(DotName.createSimple((String)WebFault.class.getName())).stream().map(annot -> annot.target().asClass().name().toString()).toArray(String[]::new);
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, classes));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, true, new Class[]{WSDLConstants.class, JAXWSAConstants.class}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"org.apache.cxf.common.logging.Slf4jLogger", QuarkusBusFactory.class.getName()}));
        Set<String> extensibilities = index.getKnownClasses().stream().map(classInfo -> classInfo.name().toString()).filter(className -> className.startsWith("io.quarkiverse.cxf.extensibility") && className.endsWith("Extensibility")).collect(Collectors.toSet());
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, extensibilities.toArray(new String[0])));
        unremovables.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNamesExclusion(extensibilities)));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"io.quarkiverse.cxf.CXFException"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"org.apache.cxf.common.jaxb.NamespaceMapper"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"com.sun.xml.bind.marshaller.MinimumEscapeHandler", "com.sun.xml.bind.marshaller.NoEscapeHandler"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"org.apache.cxf.ws.addressing.AddressingProperties"}));
    }

    @BuildStep
    void serviceProviders(BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        serviceProvider.produce((BuildItem)new ServiceProviderBuildItem("org.apache.cxf.bus.factory", new String[]{"org.apache.cxf.bus.CXFBusFactory"}));
    }

    void produceRecursiveProxies(IndexView index, DotName interfaceDN, BuildProducer<NativeImageProxyDefinitionBuildItem> proxies, Set<String> proxiesCreated) {
        index.getKnownDirectImplementors(interfaceDN).stream().filter(classinfo -> Modifier.isInterface(classinfo.flags())).map(ClassInfo::name).forEach(className -> {
            if (!proxiesCreated.contains(className.toString())) {
                proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{className.toString()}));
                this.produceRecursiveProxies(index, (DotName)className, proxies, proxiesCreated);
                proxiesCreated.add(className.toString());
            }
        });
    }

    @BuildStep
    void httpProxies(BuildProducer<NativeImageProxyDefinitionBuildItem> proxies) {
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.cxf.common.jaxb.JAXBContextProxy"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.cxf.common.jaxb.JAXBBeanInfo"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.cxf.common.jaxb.JAXBUtils$BridgeWrapper"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.cxf.common.jaxb.JAXBUtils$SchemaCompiler"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.cxf.common.util.ASMHelper$ClassWriter"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.cxf.binding.soap.wsdl.extensions.SoapBinding"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.cxf.binding.soap.wsdl.extensions.SoapAddress"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.cxf.binding.soap.wsdl.extensions.SoapHeader"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.cxf.binding.soap.wsdl.extensions.SoapBody"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.cxf.binding.soap.wsdl.extensions.SoapFault"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.cxf.binding.soap.wsdl.extensions.SoapOperation"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.cxf.binding.soap.wsdl.extensions.SoapHeaderFault"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.cxf.common.jaxb.JAXBUtils$S2JJAXBModel"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.cxf.common.jaxb.JAXBUtils$Options"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.cxf.common.jaxb.JAXBUtils$JCodeModel"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.cxf.common.jaxb.JAXBUtils$Mapping"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.cxf.common.jaxb.JAXBUtils$TypeAndAnnotation"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.cxf.common.jaxb.JAXBUtils$JType"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.cxf.common.jaxb.JAXBUtils$JPackage"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.cxf.common.jaxb.JAXBUtils$JDefinedClass"}));
    }

    @BuildStep
    NativeImageResourceBundleBuildItem nativeImageResourceBundleBuildItem() {
        return new NativeImageResourceBundleBuildItem("org.apache.cxf.interceptor.Messages");
    }

    @BuildStep
    NativeImageResourceBuildItem nativeImageResourceBuildItem() {
        return new NativeImageResourceBuildItem(new String[]{"com/sun/xml/fastinfoset/resources/ResourceBundle.properties", "META-INF/cxf/bus-extensions.txt", "META-INF/cxf/cxf.xml", "META-INF/cxf/org.apache.cxf.bus.factory", "META-INF/blueprint.handlers", "META-INF/spring.handlers", "META-INF/spring.schemas", "META-INF/jax-ws-catalog.xml", "OSGI-INF/metatype/workqueue.xml", "schemas/core.xsd", "schemas/blueprint/core.xsd", "schemas/wsdl/XMLSchema.xsd", "schemas/wsdl/addressing.xjb", "schemas/wsdl/addressing.xsd", "schemas/wsdl/addressing200403.xjb", "schemas/wsdl/addressing200403.xsd", "schemas/wsdl/http.xjb", "schemas/wsdl/http.xsd", "schemas/wsdl/mime-binding.xsd", "schemas/wsdl/soap-binding.xsd", "schemas/wsdl/soap-encoding.xsd", "schemas/wsdl/soap12-binding.xsd", "schemas/wsdl/swaref.xsd", "schemas/wsdl/ws-addr-wsdl.xjb", "schemas/wsdl/ws-addr-wsdl.xsd", "schemas/wsdl/ws-addr.xsd", "schemas/wsdl/wsdl.xjb", "schemas/wsdl/wsdl.xsd", "schemas/wsdl/wsrm.xsd", "schemas/wsdl/xmime.xsd", "schemas/wsdl/xml.xsd", "schemas/configuratio/cxf-beans.xsd", "schemas/configuration/extension.xsd", "schemas/configuration/parameterized-types.xsd", "schemas/configuration/security.xjb", "schemas/configuration/security.xsd"});
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void shutDown(CXFRecorder recorder, ShutdownContextBuildItem shutdownContext) {
        recorder.resetDestinationRegistry((ShutdownContext)shutdownContext);
    }

    private static class QuarkusCapture
    implements GeneratedClassClassLoaderCapture {
        private final ClassOutput classOutput;
        private final Set<String> generatedClasses = new LinkedHashSet<String>();

        QuarkusCapture(ClassOutput classOutput) {
            this.classOutput = classOutput;
        }

        public void capture(String name, byte[] bytes) {
            String dotName;
            String string = dotName = name.indexOf(46) >= 0 ? name : name.replace('/', '.');
            if (!this.generatedClasses.contains(dotName)) {
                String slashName = name.indexOf(47) >= 0 ? name : name.replace('.', '/');
                this.classOutput.getSourceWriter(slashName);
                LOGGER.infof("Generated class %s", (Object)dotName);
                this.classOutput.write(slashName, bytes);
                this.generatedClasses.add(dotName);
            }
        }

        public String[] getGeneratedClasses() {
            return this.generatedClasses.toArray(new String[0]);
        }
    }

    private static final class NoOpEntityResolver
    implements EntityResolver {
        private NoOpEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            LOGGER.info((Object)("Preventing access to " + systemId));
            return new InputSource(new StringReader(""));
        }
    }
}

