/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.stream.Stream;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class JakartaActivationProcessor {
    JakartaActivationProcessor() {
    }

    @BuildStep
    void indexDependencies(BuildProducer<IndexDependencyBuildItem> indexDependencies) {
        Stream.of("com.sun.activation:jakarta.activation").forEach(ga -> {
            String[] coords = ga.split(":");
            indexDependencies.produce((BuildItem)new IndexDependencyBuildItem(coords[0], coords[1]));
        });
    }

    @BuildStep
    public void nativeResources(BuildProducer<NativeImageResourceBuildItem> nativeResources) {
        Stream.of("META-INF/mailcap.default", "META-INF/mimetypes.default").map(xva$0 -> new NativeImageResourceBuildItem(new String[]{xva$0})).forEach(arg_0 -> nativeResources.produce(arg_0));
    }

    @BuildStep
    void reflectiveClasses(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        IndexView index = combinedIndexBuildItem.getIndex();
        index.getAllKnownImplementors(DotName.createSimple((String)"javax.activation.DataContentHandler")).stream().map(classInfo -> classInfo.name().toString()).map(className -> new ReflectiveClassBuildItem(false, false, new String[]{className})).forEach(arg_0 -> reflectiveClasses.produce(arg_0));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"java.beans.Beans"}));
    }
}

