/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.stream.Stream;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class JaxbProcessor {
    JaxbProcessor() {
    }

    @BuildStep
    void indexDependencies(BuildProducer<IndexDependencyBuildItem> indexDependencies) {
        Stream.of("org.glassfish.jaxb:txw2", "org.glassfish.jaxb:jaxb-runtime").forEach(ga -> {
            String[] coords = ga.split(":");
            indexDependencies.produce((BuildItem)new IndexDependencyBuildItem(coords[0], coords[1]));
        });
    }

    @BuildStep
    void registerWsSecurityReflectionItems(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        IndexView index = combinedIndexBuildItem.getIndex();
        Stream.of("jakarta.xml.bind.JAXBElement", "com.sun.xml.bind.v2.runtime.JaxBeanInfo", "org.glassfish.jaxb.runtime.v2.runtime.JaxBeanInfo").flatMap(className -> index.getAllKnownSubclasses(DotName.createSimple((String)className)).stream()).map(classInfo -> classInfo.name().toString()).map(className -> ReflectiveClassBuildItem.builder((String[])new String[]{className}).methods().build()).forEach(arg_0 -> reflectiveClass.produce(arg_0));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.glassfish.jaxb.runtime.v2.runtime.JAXBContextImpl", "org.glassfish.jaxb.runtime.v2.runtime.JaxBeanInfo"}).methods().build());
    }

    @BuildStep
    void reflectiveClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.glassfish.jaxb.core.marshaller.MinimumEscapeHandler", "org.glassfish.jaxb.core.marshaller.NoEscapeHandler"}).fields().build());
    }
}

