/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.transport;

import io.quarkiverse.cxf.CXFServletInfo;
import io.quarkiverse.cxf.CXFServletInfos;
import io.quarkiverse.cxf.QuarkusJaxWsServiceFactoryBean;
import io.quarkiverse.cxf.transport.VertxDestinationFactory;
import io.quarkiverse.cxf.transport.VertxHttpServletRequest;
import io.quarkiverse.cxf.transport.VertxHttpServletResponse;
import io.quarkiverse.cxf.transport.VertxServletConfig;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.CDI;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.DestinationRegistryImpl;
import org.apache.cxf.transport.servlet.BaseUrlHelper;
import org.apache.cxf.transport.servlet.ServletController;
import org.apache.cxf.transport.servlet.servicelist.ServiceListGeneratorServlet;
import org.jboss.logging.Logger;

public class CxfHandler
implements Handler<RoutingContext> {
    private static final Logger LOGGER = Logger.getLogger(CxfHandler.class);
    private static final String ALLOWED_METHODS = "POST, GET, PUT, DELETE, HEAD, OPTIONS, TRACE";
    private ServiceListGeneratorServlet serviceListGeneratorServlet;
    private Bus bus;
    private ClassLoader loader;
    private DestinationRegistry destinationRegistry;
    private String contextPath;
    private String servletPath;
    private ServletController controller;
    private BeanContainer beanContainer;
    private CurrentIdentityAssociation association;
    private IdentityProviderManager identityProviderManager;
    private CurrentVertxRequest currentVertxRequest;
    private static final Map<String, String> RESPONSE_HEADERS = new HashMap<String, String>();

    public CxfHandler() {
    }

    public CxfHandler(CXFServletInfos cxfServletInfos, BeanContainer beanContainer) {
        LOGGER.trace((Object)"CxfHandler created");
        this.beanContainer = beanContainer;
        Instance association = CDI.current().select(CurrentIdentityAssociation.class, new Annotation[0]);
        this.association = association.isResolvable() ? (CurrentIdentityAssociation)association.get() : null;
        Instance identityProviderManager = CDI.current().select(IdentityProviderManager.class, new Annotation[0]);
        this.identityProviderManager = identityProviderManager.isResolvable() ? (IdentityProviderManager)identityProviderManager.get() : null;
        this.currentVertxRequest = (CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get();
        if (cxfServletInfos == null || cxfServletInfos.getInfos() == null || cxfServletInfos.getInfos().isEmpty()) {
            LOGGER.warn((Object)"no info transmit to servlet");
            return;
        }
        this.bus = BusFactory.getDefaultBus();
        BusFactory.setDefaultBus((Bus)this.bus);
        this.loader = (ClassLoader)this.bus.getExtension(ClassLoader.class);
        LOGGER.trace((Object)"load destination");
        DestinationFactoryManager dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class);
        this.destinationRegistry = new DestinationRegistryImpl();
        VertxDestinationFactory destinationFactory = new VertxDestinationFactory(this.destinationRegistry);
        dfm.registerDestinationFactory("http://cxf.apache.org/transports/quarkus", (DestinationFactory)destinationFactory);
        ConduitInitiatorManager extension = (ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class);
        extension.registerConduitInitiator("http://cxf.apache.org/transports/quarkus", (ConduitInitiator)destinationFactory);
        this.serviceListGeneratorServlet = new ServiceListGeneratorServlet(this.destinationRegistry, this.bus);
        VertxServletConfig servletConfig2 = new VertxServletConfig();
        this.serviceListGeneratorServlet.init((ServletConfig)servletConfig2);
        this.controller = new ServletController(this.destinationRegistry, (ServletConfig)servletConfig2, (HttpServlet)this.serviceListGeneratorServlet);
        this.serviceListGeneratorServlet.init((ServletConfig)new VertxServletConfig());
        this.servletPath = cxfServletInfos.getPath();
        this.contextPath = cxfServletInfos.getContextPath();
        for (CXFServletInfo servletInfo : cxfServletInfos.getInfos()) {
            JaxWsServerFactoryBean factory = new JaxWsServerFactoryBean((JaxWsServiceFactoryBean)new QuarkusJaxWsServiceFactoryBean(cxfServletInfos.getWrappersclasses()));
            factory.setDestinationFactory((DestinationFactory)destinationFactory);
            factory.setBus(this.bus);
            Object instanceService = this.getInstance(servletInfo.getClassName());
            if (instanceService != null) {
                Interceptor interceptor;
                factory.setServiceClass(instanceService.getClass());
                factory.setAddress(servletInfo.getRelativePath());
                factory.setServiceBean(instanceService);
                if (servletInfo.getWsdlPath() != null) {
                    factory.setWsdlLocation(servletInfo.getWsdlPath());
                }
                if (!servletInfo.getFeatures().isEmpty()) {
                    ArrayList<Feature> features = new ArrayList<Feature>();
                    for (String feature : servletInfo.getFeatures()) {
                        Feature instanceFeature = (Feature)this.getInstance(feature);
                        features.add(instanceFeature);
                    }
                    factory.setFeatures(features);
                }
                if (servletInfo.getSOAPBinding() != null) {
                    factory.setBindingId(servletInfo.getSOAPBinding());
                }
                if (servletInfo.getEndpointUrl() != null) {
                    factory.setPublishedEndpointUrl(servletInfo.getEndpointUrl());
                }
                Server server = factory.create();
                for (String className : servletInfo.getInFaultInterceptors()) {
                    interceptor = (Interceptor)this.getInstance(className);
                    server.getEndpoint().getInFaultInterceptors().add(interceptor);
                }
                for (String className : servletInfo.getInInterceptors()) {
                    interceptor = (Interceptor)this.getInstance(className);
                    server.getEndpoint().getInInterceptors().add(interceptor);
                }
                for (String className : servletInfo.getOutFaultInterceptors()) {
                    interceptor = (Interceptor)this.getInstance(className);
                    server.getEndpoint().getOutFaultInterceptors().add(interceptor);
                }
                for (String className : servletInfo.getOutInterceptors()) {
                    interceptor = (Interceptor)this.getInstance(className);
                    server.getEndpoint().getOutInterceptors().add(interceptor);
                }
                LOGGER.info((Object)(servletInfo.toString() + " available."));
                continue;
            }
            LOGGER.error((Object)("Cannot initialize " + servletInfo.toString()));
        }
    }

    private Class<?> loadClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn((Object)("failed to load class " + className));
                return null;
            }
        }
    }

    private Object getInstance(String className) {
        Class<?> classObj = this.loadClass(className);
        try {
            return CDI.current().select(classObj, new Annotation[0]).get();
        }
        catch (UnsatisfiedResolutionException unsatisfiedResolutionException) {
            try {
                return classObj.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RoutingContext event) {
        ClassLoaderUtils.ClassLoaderHolder origLoader;
        block7: {
            origLoader = null;
            Bus origBus = null;
            try {
                if (this.loader != null) {
                    origLoader = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)this.loader);
                }
                if (this.bus != null) {
                    origBus = BusFactory.getAndSetThreadDefaultBus((Bus)this.bus);
                }
                this.process(event);
                if (origBus == this.bus) break block7;
            }
            catch (Throwable throwable) {
                if (origBus != this.bus) {
                    BusFactory.setThreadDefaultBus(origBus);
                }
                if (origLoader != null) {
                    origLoader.reset();
                }
                throw throwable;
            }
            BusFactory.setThreadDefaultBus((Bus)origBus);
        }
        if (origLoader != null) {
            origLoader.reset();
        }
    }

    protected void generateNotFound(HttpServerRequest request, HttpServerResponse res) {
        res.setStatusCode(404);
        res.headers().add("Content-Type", "text/html");
        res.end("<html><body>No service was found.</body></html>");
    }

    protected void updateDestination(HttpServerRequest request, AbstractHTTPDestination d) {
        String base = this.getBaseURL(request);
        String ad = d.getEndpointInfo().getAddress();
        if (ad == null && d.getAddress() != null && d.getAddress().getAddress() != null && (ad = d.getAddress().getAddress().getValue()) == null) {
            ad = "/";
        }
        if (ad != null && !ad.startsWith("http")) {
            BaseUrlHelper.setAddress((AbstractDestination)d, (String)(base + ad));
        }
    }

    private String getBaseURL(HttpServerRequest request) {
        String reqPrefix = request.uri();
        String pathInfo = request.path();
        if (!"/".equals(pathInfo) || reqPrefix.contains(";")) {
            StringBuilder sb = new StringBuilder();
            URI uri = URI.create(reqPrefix);
            sb.append(uri.getScheme()).append("://").append(uri.getRawAuthority());
            String path = request.path();
            if (path != null) {
                sb.append(path);
            }
            reqPrefix = sb.toString();
        }
        return reqPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(RoutingContext event) {
        ManagedContext requestContext = this.beanContainer.requestContext();
        requestContext.activate();
        if (this.association != null) {
            QuarkusHttpUser existing = (QuarkusHttpUser)event.user();
            if (existing != null) {
                SecurityIdentity identity = existing.getSecurityIdentity();
                this.association.setIdentity(identity);
            } else {
                this.association.setIdentity(QuarkusHttpUser.getSecurityIdentity((RoutingContext)event, (IdentityProviderManager)this.identityProviderManager));
            }
        }
        this.currentVertxRequest.setCurrent(event);
        try {
            VertxHttpServletRequest req = new VertxHttpServletRequest(event, this.contextPath, this.servletPath);
            VertxHttpServletResponse resp = new VertxHttpServletResponse(event);
            this.controller.invoke((HttpServletRequest)req, (HttpServletResponse)resp);
            resp.end();
        }
        catch (ServletException se) {
            LOGGER.warn((Object)"Internal server error", (Throwable)se);
            event.fail(500, (Throwable)se);
        }
        catch (IOException ioe) {
            LOGGER.warn((Object)"Cannot list or instantiate web service", (Throwable)ioe);
            event.fail(404, (Throwable)ioe);
        }
        finally {
            if (requestContext.isActive()) {
                requestContext.terminate();
            }
        }
    }

    static {
        RESPONSE_HEADERS.put("Access-Control-Allow-Origin", "*");
        RESPONSE_HEADERS.put("Access-Control-Allow-Credentials", "true");
        RESPONSE_HEADERS.put("Access-Control-Allow-Methods", ALLOWED_METHODS);
        RESPONSE_HEADERS.put("Access-Control-Allow-Headers", "Content-Type, Authorization");
        RESPONSE_HEADERS.put("Access-Control-Max-Age", "86400");
    }
}

