/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.transport;

import io.quarkiverse.cxf.transport.VertxServletOutputStream;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class VertxHttpServletResponse
implements HttpServletResponse {
    protected final RoutingContext context;
    private final HttpServerRequest request;
    protected final HttpServerResponse response;
    private VertxServletOutputStream os;
    private PrintWriter printWriter;

    public VertxHttpServletResponse(RoutingContext context) {
        this.request = context.request();
        this.response = context.response();
        this.context = context;
        this.os = new VertxServletOutputStream(this.request, this.response);
    }

    public void addCookie(Cookie cookie) {
    }

    public boolean containsHeader(String name) {
        return this.response.headers().contains(name);
    }

    public String encodeURL(String url) {
        return null;
    }

    public String encodeRedirectURL(String url) {
        return null;
    }

    @Deprecated
    public String encodeUrl(String url) {
        return null;
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        return null;
    }

    public void sendError(int sc, String msg) throws IOException {
    }

    public void sendError(int sc) throws IOException {
    }

    public void sendRedirect(String location) throws IOException {
    }

    public void setDateHeader(String name, long date) {
    }

    public void addDateHeader(String name, long date) {
    }

    public void setHeader(String name, String value) {
        this.response.headers().set(name, value);
    }

    public void addHeader(String name, String value) {
        this.response.headers().add(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.response.headers().set(name, Integer.toBinaryString(value));
    }

    public void addIntHeader(String name, int value) {
        this.response.headers().add(name, Integer.toBinaryString(value));
    }

    public void setStatus(int sc) {
        this.response.setStatusCode(sc);
    }

    @Deprecated
    public void setStatus(int sc, String sm) {
        this.response.setStatusCode(sc);
        this.response.setStatusMessage(sm);
    }

    public int getStatus() {
        return this.response.getStatusCode();
    }

    public String getHeader(String name) {
        return this.response.headers().get(name);
    }

    public Collection<String> getHeaders(String name) {
        return this.response.headers().getAll(name);
    }

    public Collection<String> getHeaderNames() {
        return this.response.headers().names();
    }

    public String getCharacterEncoding() {
        return null;
    }

    public String getContentType() {
        return this.response.headers().get("Content-Type");
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.os;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.printWriter == null) {
            this.printWriter = new PrintWriter((OutputStream)((Object)this.os));
        }
        return this.printWriter;
    }

    public void setCharacterEncoding(String charset) {
    }

    public void setContentLength(int len) {
        this.response.headers().set("Content-Length", Integer.toString(len));
    }

    public void setContentLengthLong(long len) {
        this.response.headers().set("Content-Length", Long.toString(len));
    }

    public void setContentType(String type) {
        this.response.headers().set("Content-Type", type);
    }

    public void setBufferSize(int size) {
        throw new UnsupportedOperationException();
    }

    public int getBufferSize() {
        throw new UnsupportedOperationException();
    }

    public void flushBuffer() throws IOException {
        if (this.printWriter != null) {
            this.printWriter.close();
        } else {
            this.os.close();
        }
    }

    public void resetBuffer() {
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.os = new VertxServletOutputStream(this.request, this.response);
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
    }

    public void setLocale(Locale loc) {
    }

    public Locale getLocale() {
        return null;
    }

    public void end() {
        try {
            if (this.printWriter != null) {
                this.printWriter.close();
            } else {
                this.os.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

