/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.CxfClientConfig;
import io.quarkus.arc.Unremovable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@Unremovable
public class CXFClientInfo {
    private String sei;
    private String endpointAddress;
    private String wsdlUrl;
    private String soapBinding;
    private String wsNamespace;
    private String wsName;
    private String epNamespace;
    private String epName;
    private String username;
    private String password;
    private boolean proxyClassRuntimeInitialized;
    private final List<String> inInterceptors = new ArrayList<String>();
    private final List<String> outInterceptors = new ArrayList<String>();
    private final List<String> outFaultInterceptors = new ArrayList<String>();
    private final List<String> inFaultInterceptors = new ArrayList<String>();
    private final List<String> features = new ArrayList<String>();
    private final List<String> handlers = new ArrayList<String>();

    public CXFClientInfo() {
    }

    public CXFClientInfo(String sei, String endpointAddress, String soapBinding, String wsNamespace, String wsName, boolean proxyClassRuntimeInitialized) {
        this.endpointAddress = endpointAddress;
        this.epName = null;
        this.epNamespace = null;
        this.password = null;
        this.sei = sei;
        this.soapBinding = soapBinding;
        this.username = null;
        this.wsName = wsName;
        this.wsNamespace = wsNamespace;
        this.wsdlUrl = null;
        this.proxyClassRuntimeInitialized = proxyClassRuntimeInitialized;
    }

    public CXFClientInfo(CXFClientInfo other) {
        this(other.sei, other.endpointAddress, other.soapBinding, other.wsNamespace, other.wsName, other.proxyClassRuntimeInitialized);
        this.wsdlUrl = other.wsdlUrl;
        this.epNamespace = other.epNamespace;
        this.epName = other.epName;
        this.username = other.username;
        this.password = other.password;
        this.features.addAll(other.features);
        this.handlers.addAll(other.handlers);
        this.inFaultInterceptors.addAll(other.inFaultInterceptors);
        this.inInterceptors.addAll(other.inInterceptors);
        this.outFaultInterceptors.addAll(other.outFaultInterceptors);
        this.outInterceptors.addAll(other.outInterceptors);
    }

    public CXFClientInfo withConfig(CxfClientConfig config) {
        Objects.requireNonNull(config);
        this.wsdlUrl = config.wsdlPath.orElse(this.wsdlUrl);
        this.epNamespace = config.endpointNamespace.orElse(this.epNamespace);
        this.epName = config.endpointName.orElse(this.epName);
        this.username = config.username.orElse(this.username);
        this.password = config.password.orElse(this.password);
        this.soapBinding = config.soapBinding.orElse(this.soapBinding);
        this.endpointAddress = config.clientEndpointUrl.orElse(this.endpointAddress);
        this.addFeatures(config);
        this.addHandlers(config);
        this.addInterceptors(config);
        return this;
    }

    public String getSei() {
        return this.sei;
    }

    public void setSei(String sei) {
        this.sei = sei;
    }

    public String getEndpointAddress() {
        return this.endpointAddress;
    }

    public String getWsdlUrl() {
        return this.wsdlUrl;
    }

    public String getSoapBinding() {
        return this.soapBinding;
    }

    public String getWsNamespace() {
        return this.wsNamespace;
    }

    public String getWsName() {
        return this.wsName;
    }

    public String getEpNamespace() {
        return this.epNamespace;
    }

    public String getEpName() {
        return this.epName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isProxyClassRuntimeInitialized() {
        return this.proxyClassRuntimeInitialized;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public List<String> getHandlers() {
        return this.handlers;
    }

    public List<String> getInInterceptors() {
        return this.inInterceptors;
    }

    public List<String> getOutInterceptors() {
        return this.outInterceptors;
    }

    public List<String> getOutFaultInterceptors() {
        return this.outFaultInterceptors;
    }

    public List<String> getInFaultInterceptors() {
        return this.inFaultInterceptors;
    }

    private CXFClientInfo addInterceptors(CxfClientConfig cxfEndPointConfig) {
        if (cxfEndPointConfig.inInterceptors.isPresent()) {
            this.inInterceptors.addAll((Collection<String>)cxfEndPointConfig.inInterceptors.get());
        }
        if (cxfEndPointConfig.outInterceptors.isPresent()) {
            this.outInterceptors.addAll((Collection<String>)cxfEndPointConfig.outInterceptors.get());
        }
        if (cxfEndPointConfig.outFaultInterceptors.isPresent()) {
            this.outFaultInterceptors.addAll((Collection<String>)cxfEndPointConfig.outFaultInterceptors.get());
        }
        if (cxfEndPointConfig.inFaultInterceptors.isPresent()) {
            this.inFaultInterceptors.addAll((Collection<String>)cxfEndPointConfig.inFaultInterceptors.get());
        }
        return this;
    }

    private CXFClientInfo addFeatures(CxfClientConfig cxfEndPointConfig) {
        if (cxfEndPointConfig.features.isPresent()) {
            this.features.addAll((Collection<String>)cxfEndPointConfig.features.get());
        }
        return this;
    }

    private CXFClientInfo addHandlers(CxfClientConfig cxfEndPointConfig) {
        if (cxfEndPointConfig.handlers.isPresent()) {
            this.handlers.addAll((Collection<String>)cxfEndPointConfig.handlers.get());
        }
        return this;
    }
}

