/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.CXFClientInfo;
import io.quarkiverse.cxf.CxfClientConfig;
import io.quarkiverse.cxf.CxfConfig;
import io.quarkiverse.cxf.QuarkusClientFactoryBean;
import io.quarkiverse.cxf.QuarkusJaxWsProxyFactoryBean;
import io.quarkiverse.cxf.annotation.CXFClient;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.jboss.logging.Logger;

public abstract class CxfClientProducer {
    private static final Logger LOGGER = Logger.getLogger(CxfClientProducer.class);
    public static final String RUNTIME_INITIALIZED_PROXY_MARKER_INTERFACE_PACKAGE = "io.quarkiverse.cxf.runtime.proxy";
    public static final String RUNTIME_INITIALIZED_PROXY_MARKER_INTERFACE_NAME = "io.quarkiverse.cxf.runtime.proxy.RuntimeInitializedProxyMarker";
    @Inject
    CxfConfig config;

    public Object loadCxfClient(InjectionPoint ip, CXFClientInfo meta) {
        return this.produceCxfClient(CxfClientProducer.selectorCXFClientInfo(this.config, ip, meta));
    }

    private Object produceCxfClient(CXFClientInfo cxfClientInfo) {
        Class[] interfaces;
        Class<?> seiClass;
        try {
            seiClass = Class.forName(cxfClientInfo.getSei(), false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            LOGGER.errorf("WebService interface (client) class %s not found", (Object)cxfClientInfo.getSei());
            return null;
        }
        try {
            Class[] classArray;
            if (cxfClientInfo.isProxyClassRuntimeInitialized()) {
                Class[] classArray2 = new Class[4];
                classArray2[0] = BindingProvider.class;
                classArray2[1] = Closeable.class;
                classArray2[2] = Client.class;
                classArray = classArray2;
                classArray2[3] = Class.forName(RUNTIME_INITIALIZED_PROXY_MARKER_INTERFACE_NAME, true, Thread.currentThread().getContextClassLoader());
            } else {
                Class[] classArray3 = new Class[3];
                classArray3[0] = BindingProvider.class;
                classArray3[1] = Closeable.class;
                classArray = classArray3;
                classArray3[2] = Client.class;
            }
            interfaces = classArray;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load io.quarkiverse.cxf.runtime.proxy.RuntimeInitializedProxyMarker", e);
        }
        QuarkusClientFactoryBean quarkusClientFactoryBean = new QuarkusClientFactoryBean();
        QuarkusJaxWsProxyFactoryBean factory = new QuarkusJaxWsProxyFactoryBean(quarkusClientFactoryBean, interfaces);
        factory.setServiceClass(seiClass);
        LOGGER.debugf("using servicename {%s}%s", (Object)cxfClientInfo.getWsNamespace(), (Object)cxfClientInfo.getWsName());
        factory.setServiceName(new QName(cxfClientInfo.getWsNamespace(), cxfClientInfo.getWsName()));
        if (cxfClientInfo.getEpName() != null) {
            factory.setEndpointName(new QName(cxfClientInfo.getEpNamespace(), cxfClientInfo.getEpName()));
        }
        factory.setAddress(cxfClientInfo.getEndpointAddress());
        if (cxfClientInfo.getSoapBinding() != null) {
            factory.setBindingId(cxfClientInfo.getSoapBinding());
        }
        if (cxfClientInfo.getWsdlUrl() != null && !cxfClientInfo.getWsdlUrl().isEmpty()) {
            factory.setWsdlURL(cxfClientInfo.getWsdlUrl());
        }
        if (cxfClientInfo.getUsername() != null) {
            factory.setUsername(cxfClientInfo.getUsername());
        }
        if (cxfClientInfo.getPassword() != null) {
            factory.setPassword(cxfClientInfo.getPassword());
        }
        for (String feature : cxfClientInfo.getFeatures()) {
            this.addToCols(feature, factory.getFeatures(), Feature.class);
        }
        for (String handler : cxfClientInfo.getHandlers()) {
            this.addToCols(handler, factory.getHandlers(), Handler.class);
        }
        for (String inInterceptor : cxfClientInfo.getInInterceptors()) {
            this.addToCols(inInterceptor, factory.getInInterceptors());
        }
        for (String outInterceptor : cxfClientInfo.getOutInterceptors()) {
            this.addToCols(outInterceptor, factory.getOutInterceptors());
        }
        for (String outFaultInterceptor : cxfClientInfo.getOutFaultInterceptors()) {
            this.addToCols(outFaultInterceptor, factory.getOutFaultInterceptors());
        }
        for (String inFaultInterceptor : cxfClientInfo.getInFaultInterceptors()) {
            this.addToCols(inFaultInterceptor, factory.getInFaultInterceptors());
        }
        LOGGER.debug((Object)("cxf client loaded for " + cxfClientInfo.getSei()));
        return factory.create();
    }

    private void addToCols(String className, List<Interceptor<? extends Message>> cols) {
        this.addToCols(className, CastUtils.cast(cols), Interceptor.class);
    }

    private <T> void addToCols(String className, List<T> cols, Class<T> clazz) {
        Class<T> cls;
        try {
            cls = Class.forName(className, false, Thread.currentThread().getContextClassLoader()).asSubclass(clazz);
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw new RuntimeException("No such class " + className, e);
        }
        Object item = null;
        try {
            item = CDI.current().select(cls, new Annotation[0]).get();
        }
        catch (ClassCastException | UnsatisfiedResolutionException throwable) {
            // empty catch block
        }
        try {
            item = item == null ? cls.getConstructor(new Class[0]).newInstance(new Object[0]) : item;
        }
        catch (ReflectiveOperationException | RuntimeException exception) {
            // empty catch block
        }
        if (item == null) {
            LOGGER.warnf("unable to create instance of class %s", (Object)className);
        } else {
            cols.add(item);
        }
    }

    private static CXFClientInfo selectorCXFClientInfo(CxfConfig cxfConfig, InjectionPoint ip, CXFClientInfo meta) {
        List keylist;
        CXFClientInfo info = new CXFClientInfo(meta);
        if (ip.getAnnotated().isAnnotationPresent(CXFClient.class)) {
            CXFClient anno = (CXFClient)ip.getAnnotated().getAnnotation(CXFClient.class);
            String configKey = anno.value();
            if (cxfConfig.isClientPresent(configKey)) {
                return info.withConfig(cxfConfig.getClient(configKey));
            }
            if (configKey != null && !configKey.isEmpty()) {
                throw new IllegalStateException(String.format("client config key %s does not exist. This is illegal.", configKey));
            }
        }
        if ((keylist = cxfConfig.clients.entrySet().stream().filter(kv -> kv.getValue() != null).filter(kv -> ((CxfClientConfig)kv.getValue()).serviceInterface.isPresent()).filter(kv -> ((CxfClientConfig)kv.getValue()).serviceInterface.get().equals(meta.getSei())).filter(kv -> !((CxfClientConfig)kv.getValue()).alternative).map(Map.Entry::getKey).collect(Collectors.toList())).size() > 1) {
            String fmt = "multiple client configurations found applicable for SEI(%s): %s. This is illegal. Consider to remove all but one applicable configurations by applying config property '*.alternative = false'.";
            throw new IllegalStateException(String.format(fmt, meta.getSei(), String.join((CharSequence)"|", keylist)));
        }
        if (keylist.isEmpty()) {
            LOGGER.warnf("no matching configuration found for SEI %s, using derived value %s.", (Object)meta.getSei(), (Object)meta);
            return meta;
        }
        return info.withConfig(cxfConfig.clients.get(keylist.get(0)));
    }
}

