/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkus.arc.Subclass;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;

public class QuarkusRuntimeJaxWsServiceFactoryBean
extends JaxWsServiceFactoryBean {
    private static final Logger LOG = LogUtils.getLogger(QuarkusRuntimeJaxWsServiceFactoryBean.class);

    public void setServiceClass(Class<?> serviceClass) {
        if (serviceClass == null) {
            Message message = new Message("SERVICECLASS_MUST_BE_SET", LOG, new Object[0]);
            throw new ServiceConstructionException(message);
        }
        if (Subclass.class.isAssignableFrom(serviceClass)) {
            serviceClass = serviceClass.getSuperclass();
        }
        this.setJaxWsImplementorInfo(new JaxWsImplementorInfo(serviceClass));
        super.setServiceClass(this.getJaxWsImplementorInfo().getEndpointClass());
        super.setServiceType(this.getJaxWsImplementorInfo().getSEIType());
    }
}

