/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.CXFRuntimeUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.feature.Features;
import org.apache.cxf.interceptor.AnnotationInterceptors;
import org.apache.cxf.interceptor.InFaultInterceptors;
import org.apache.cxf.interceptor.InInterceptors;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.OutFaultInterceptors;
import org.apache.cxf.interceptor.OutInterceptors;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.message.Message;

public class QuarkusJaxWsServerFactoryBean
extends JaxWsServerFactoryBean {
    private final String endpointString;

    public QuarkusJaxWsServerFactoryBean(JaxWsServiceFactoryBean serviceFactory, String endpointString) {
        super(serviceFactory);
        this.endpointString = endpointString;
    }

    protected void initializeAnnotationInterceptors(Endpoint ep, Class<?> ... cls) {
        Class seiClass = ((JaxWsServiceFactoryBean)this.getServiceFactory()).getJaxWsImplementorInfo().getSEIClass();
        if (seiClass != null) {
            boolean found = false;
            for (Class<?> c : cls) {
                if (!c.equals(seiClass)) continue;
                found = true;
            }
            if (!found) {
                Class[] cls2 = new Class[cls.length + 1];
                System.arraycopy(cls, 0, cls2, 0, cls.length);
                cls2[cls.length] = seiClass;
                cls = cls2;
            }
        }
        QuarkusAnnotationInterceptors provider = new QuarkusAnnotationInterceptors(((JaxWsServiceFactoryBean)this.getServiceFactory()).getJaxWsImplementorInfo().getImplementorClass().getName(), this.endpointString, cls);
        this.initializeAnnotationInterceptors(provider, ep);
    }

    protected boolean initializeAnnotationInterceptors(AnnotationInterceptors provider, Endpoint ep) {
        List features2;
        List outInterceptors;
        List outFaultInterceptors;
        List inInterceptors;
        boolean hasAnnotation = false;
        List inFaultInterceptors = provider.getInFaultInterceptors();
        if (inFaultInterceptors != null) {
            ep.getInFaultInterceptors().addAll(inFaultInterceptors);
            hasAnnotation = true;
        }
        if ((inInterceptors = provider.getInInterceptors()) != null) {
            ep.getInInterceptors().addAll(inInterceptors);
            hasAnnotation = true;
        }
        if ((outFaultInterceptors = provider.getOutFaultInterceptors()) != null) {
            ep.getOutFaultInterceptors().addAll(outFaultInterceptors);
            hasAnnotation = true;
        }
        if ((outInterceptors = provider.getOutInterceptors()) != null) {
            ep.getOutInterceptors().addAll(outInterceptors);
            hasAnnotation = true;
        }
        if ((features2 = provider.getFeatures()) != null) {
            this.getFeatures().addAll(features2);
            hasAnnotation = true;
        }
        return hasAnnotation;
    }

    static class QuarkusAnnotationInterceptors
    extends AnnotationInterceptors {
        private final Class<?>[] clazzes;
        private final String implementorClass;
        private final String endpointString;

        public QuarkusAnnotationInterceptors(String implementorClass, String endpointString, Class<?> ... clz) {
            super(new Class[0]);
            this.implementorClass = implementorClass;
            this.endpointString = endpointString;
            this.clazzes = clz;
        }

        private <T> List<T> getAnnotationObject(Class<? extends Annotation> annotationClazz, Class<T> type) {
            for (Class<?> cls : this.clazzes) {
                Annotation annotation = cls.getAnnotation(annotationClazz);
                if (annotation == null) continue;
                return this.initializeAnnotationObjects(annotation, type);
            }
            return null;
        }

        private <T> List<T> initializeAnnotationObjects(Annotation annotation, Class<T> type) {
            ArrayList result = new ArrayList();
            CXFRuntimeUtils.addBeansByType(Arrays.asList(this.getAnnotationObjectClasses(annotation, type)), type.getName(), this.implementorClass, this.endpointString, result);
            CXFRuntimeUtils.addBeans(Arrays.asList(this.getAnnotationObjectNames(annotation)), type.getName(), this.implementorClass, this.endpointString, result);
            return result;
        }

        private <T> Class<? extends T>[] getAnnotationObjectClasses(Annotation ann, Class<T> type) {
            if (ann instanceof InFaultInterceptors) {
                return ((InFaultInterceptors)ann).classes();
            }
            if (ann instanceof InInterceptors) {
                return ((InInterceptors)ann).classes();
            }
            if (ann instanceof OutFaultInterceptors) {
                return ((OutFaultInterceptors)ann).classes();
            }
            if (ann instanceof OutInterceptors) {
                return ((OutInterceptors)ann).classes();
            }
            if (ann instanceof Features) {
                return ((Features)ann).classes();
            }
            throw new UnsupportedOperationException("Doesn't support the annotation: " + ann);
        }

        private String[] getAnnotationObjectNames(Annotation ann) {
            if (ann instanceof InFaultInterceptors) {
                return ((InFaultInterceptors)ann).interceptors();
            }
            if (ann instanceof InInterceptors) {
                return ((InInterceptors)ann).interceptors();
            }
            if (ann instanceof OutFaultInterceptors) {
                return ((OutFaultInterceptors)ann).interceptors();
            }
            if (ann instanceof OutInterceptors) {
                return ((OutInterceptors)ann).interceptors();
            }
            if (ann instanceof Features) {
                return ((Features)ann).features();
            }
            throw new UnsupportedOperationException("Doesn't support the annotation: " + ann);
        }

        private List<Interceptor<? extends Message>> getAnnotationInterceptorList(Class<? extends Annotation> t) {
            List<Interceptor> i = this.getAnnotationObject(t, Interceptor.class);
            if (i == null) {
                return null;
            }
            ArrayList<Interceptor<? extends Message>> m = new ArrayList<Interceptor<? extends Message>>();
            for (Interceptor i2 : i) {
                m.add((Interceptor<? extends Message>)i2);
            }
            return m;
        }

        public List<Interceptor<? extends Message>> getInFaultInterceptors() {
            return this.getAnnotationInterceptorList(InFaultInterceptors.class);
        }

        public List<Interceptor<? extends Message>> getInInterceptors() {
            return this.getAnnotationInterceptorList(InInterceptors.class);
        }

        public List<Interceptor<? extends Message>> getOutFaultInterceptors() {
            return this.getAnnotationInterceptorList(OutFaultInterceptors.class);
        }

        public List<Interceptor<? extends Message>> getOutInterceptors() {
            return this.getAnnotationInterceptorList(OutInterceptors.class);
        }

        public List<Feature> getFeatures() {
            return this.getAnnotationObject(Features.class, Feature.class);
        }
    }
}

