/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.logging;

import io.quarkiverse.cxf.CXFClientInfo;
import io.quarkiverse.cxf.CXFServletInfo;
import io.quarkiverse.cxf.CxfConfig;
import io.quarkiverse.cxf.EnabledFor;
import io.quarkiverse.cxf.LoggingConfig;
import io.quarkiverse.cxf.PrettyBoolean;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;

public class LoggingFactoryCustomizer {
    private final CxfConfig config;

    public LoggingFactoryCustomizer(CxfConfig config) {
        this.config = config;
    }

    public void customize(CXFClientInfo cxfClientInfo, JaxWsProxyFactoryBean factory) {
        String key = cxfClientInfo.getConfigKey();
        LoggingConfig.PerClientOrServiceLoggingConfig clientOrServiceConfig = this.config.clients().get(key).logging();
        this.customize(Kind.client, key, clientOrServiceConfig, factory.getFeatures());
    }

    public void customize(CXFServletInfo cxfServletInfo, JaxWsServerFactoryBean factory) {
        String key = cxfServletInfo.getRelativePath();
        LoggingConfig.PerClientOrServiceLoggingConfig clientOrServiceConfig = this.config.endpoints().get(key).logging();
        this.customize(Kind.endpoint, key, clientOrServiceConfig, factory.getFeatures());
    }

    private void customize(Kind kind, String key, LoggingConfig.PerClientOrServiceLoggingConfig clientOrServiceConfig, List<Feature> features) {
        if (LoggingFactoryCustomizer.isEnabledFor(this.config.logging().enabledFor(), kind, clientOrServiceConfig.enabled())) {
            LoggingFeature loggingFeature = this.configureLoggingFeature(this.config.logging(), clientOrServiceConfig);
            features.add((Feature)loggingFeature);
        }
    }

    private LoggingFeature configureLoggingFeature(LoggingConfig.GlobalLoggingConfig global, LoggingConfig.PerClientOrServiceLoggingConfig clientOrServiceConfig) {
        LoggingFeature feature = new LoggingFeature();
        feature.setLimit(clientOrServiceConfig.limit().orElse(global.limit()));
        feature.setInMemThreshold(clientOrServiceConfig.inMemThreshold().orElse(global.inMemThreshold()));
        feature.setPrettyLogging(clientOrServiceConfig.pretty().orElse(clientOrServiceConfig.enabled().map(PrettyBoolean::pretty).orElse(global.pretty())).booleanValue());
        feature.setLogBinary(clientOrServiceConfig.logBinary().orElse(global.logBinary()).booleanValue());
        feature.setLogMultipart(clientOrServiceConfig.logMultipart().orElse(global.logMultipart()).booleanValue());
        feature.setVerbose(clientOrServiceConfig.verbose().orElse(global.verbose()).booleanValue());
        this.addList(global.inBinaryContentMediaTypes(), clientOrServiceConfig.inBinaryContentMediaTypes(), arg_0 -> ((LoggingFeature)feature).addInBinaryContentMediaTypes(arg_0));
        this.addList(global.outBinaryContentMediaTypes(), clientOrServiceConfig.outBinaryContentMediaTypes(), arg_0 -> ((LoggingFeature)feature).addOutBinaryContentMediaTypes(arg_0));
        this.addList(global.binaryContentMediaTypes(), clientOrServiceConfig.inBinaryContentMediaTypes(), arg_0 -> ((LoggingFeature)feature).addBinaryContentMediaTypes(arg_0));
        clientOrServiceConfig.sensitiveElementNames().or(global::sensitiveElementNames).ifPresent(arg_0 -> ((LoggingFeature)feature).addSensitiveElementNames(arg_0));
        clientOrServiceConfig.sensitiveProtocolHeaderNames().or(global::sensitiveProtocolHeaderNames).ifPresent(arg_0 -> ((LoggingFeature)feature).addSensitiveProtocolHeaderNames(arg_0));
        return feature;
    }

    private void addList(Optional<List<String>> global, Optional<List<String>> perClientOrService, Consumer<String> consumer) {
        if (perClientOrService.isPresent()) {
            consumer.accept(perClientOrService.get().stream().collect(Collectors.joining(";")));
        } else {
            global.ifPresent(list -> consumer.accept(list.stream().collect(Collectors.joining(";"))));
        }
    }

    static boolean isEnabledFor(EnabledFor global, Kind kind, Optional<PrettyBoolean> clientOrEndpoint) {
        if (clientOrEndpoint.isPresent()) {
            return clientOrEndpoint.get().enabled();
        }
        switch (kind) {
            case client: {
                return global.enabledForClients();
            }
            case endpoint: {
                return global.enabledForServices();
            }
        }
        throw new IllegalArgumentException("Unexpected value of " + Kind.class.getName() + ": " + kind);
    }

    static enum Kind {
        client,
        endpoint;

    }
}

