/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.vertx.http.client;

import io.quarkiverse.cxf.CXFClientInfo;
import io.quarkiverse.cxf.QuarkusCxfUtils;
import io.quarkiverse.cxf.QuarkusTLSClientParameters;
import io.quarkiverse.cxf.vertx.http.client.BodyRecorder;
import io.quarkiverse.cxf.vertx.http.client.DummyBuffer;
import io.quarkiverse.cxf.vertx.http.client.HttpClientPool;
import io.quarkiverse.cxf.vertx.http.client.VertxHttpException;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.runtime.BlockingOperationControl;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.core.streams.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.lang.annotation.Annotation;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.http.Address;
import org.apache.cxf.transport.http.Cookies;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPException;
import org.apache.cxf.transport.http.Headers;
import org.apache.cxf.transport.http.MessageTrustDecider;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.version.Version;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.jboss.logging.Logger;

public class VertxHttpClientHTTPConduit
extends HTTPConduit {
    private static final Logger log = Logger.getLogger(VertxHttpClientHTTPConduit.class);
    public static final String USE_ASYNC = "use.async.http.conduit";
    public static final String ENABLE_HTTP2 = "org.apache.cxf.transports.http2.enabled";
    public static final String AUTO_REDIRECT_MAX_SAME_URI_COUNT = "http.redirect.max.same.uri.count";
    private static final String AUTO_REDIRECT_SAME_HOST_ONLY = "http.redirect.same.host.only";
    private static final String AUTO_REDIRECT_ALLOWED_URI = "http.redirect.allowed.uri";
    public static final String AUTO_REDIRECT_ALLOW_REL_URI = "http.redirect.relative.uri";
    private final HttpClientPool httpClientPool;
    private final String userAgent;
    private final CXFClientInfo clientInfo;

    public VertxHttpClientHTTPConduit(CXFClientInfo clientInfo, Bus b, EndpointInfo ei, EndpointReferenceType t, HttpClientPool httpClientPool) throws IOException {
        super(b, ei, t);
        this.clientInfo = clientInfo;
        this.httpClientPool = httpClientPool;
        this.userAgent = Version.getCompleteVersionString();
    }

    protected void setupConnection(Message message, Address address, HTTPClientPolicy csPolicy) throws IOException {
        String query;
        InetSocketAddress adr;
        QuarkusTLSClientParameters clientParameters;
        RequestOptions requestOptions = new RequestOptions();
        URI uri = address.getURI();
        String scheme = uri.getScheme();
        message.put((Object)"http.scheme", (Object)scheme);
        HttpMethod method = VertxHttpClientHTTPConduit.getMethod(message);
        UseAsyncPolicy useAsync = UseAsyncPolicy.of(message.getContextualProperty(USE_ASYNC));
        boolean isAsync = useAsync.isAsync(message);
        message.put((Object)USE_ASYNC, (Object)isAsync);
        if (!isAsync && !BlockingOperationControl.isBlockingAllowed()) {
            throw new IllegalStateException("You have attempted to perform a blocking operation on an IO thread. This is not allowed, as blocking the IO thread will cause major performance issues with your application. You need to offload the blocking CXF client call to a worker thread, e.g. by using the @io.smallrye.common.annotation.Blocking annotation on a caller method where it is supported by the underlying Quarkus extension, such as quarkus-rest, quarkus-vertx, quarkus-reactive-routes, quarkus-grpc, quarkus-messaging-* and possibly others.");
        }
        HttpVersion version = VertxHttpClientHTTPConduit.getVersion(message, csPolicy);
        boolean isHttps = "https".equals(uri.getScheme());
        if (isHttps) {
            clientParameters = this.findTLSClientParameters(message);
            VertxHttpClientHTTPConduit.validateClientParameters(clientParameters);
            MessageTrustDecider decider2 = (MessageTrustDecider)message.get(MessageTrustDecider.class);
            if (decider2 != null || this.trustDecider != null) {
                trustDeciders = new ArrayList(2);
                if (this.trustDecider != null) {
                    trustDeciders.add(this.trustDecider);
                }
                if (decider2 != null) {
                    trustDeciders.add(decider2);
                }
            } else {
                trustDeciders = Collections.emptyList();
            }
        } else {
            clientParameters = null;
        }
        Proxy proxy = this.proxyFactory.createProxy(csPolicy, uri);
        if (proxy != null && (adr = (InetSocketAddress)proxy.address()) != null) {
            requestOptions.setProxyOptions(new ProxyOptions().setHost(adr.getHostName()).setPort(adr.getPort()).setType(VertxHttpClientHTTPConduit.toProxyType(proxy.type())));
        }
        String pathAndQuery = (query = uri.getQuery()) != null && !query.isEmpty() ? uri.getPath() + "?" + query : uri.getPath();
        requestOptions.setMethod(method).setHost(uri.getHost()).setURI(pathAndQuery).setConnectTimeout((long)VertxHttpClientHTTPConduit.determineConnectionTimeout((Message)message, (HTTPClientPolicy)csPolicy));
        int port = uri.getPort();
        if (port >= 0) {
            requestOptions.setPort(Integer.valueOf(uri.getPort()));
        } else if (isHttps) {
            requestOptions.setPort(Integer.valueOf(443));
        } else {
            requestOptions.setPort(Integer.valueOf(80));
        }
        RequestContext requestContext = new RequestContext(this.clientInfo, uri, requestOptions, clientParameters != null ? new HttpClientPool.ClientSpec(version, clientParameters.getTlsConfigurationName(), clientParameters.getTlsConfiguration()) : new HttpClientPool.ClientSpec(version, null, null), VertxHttpClientHTTPConduit.determineReceiveTimeout((Message)message, (HTTPClientPolicy)csPolicy), isAsync, csPolicy.getMaxRetransmits(), csPolicy.isAutoRedirect());
        message.put(RequestContext.class, (Object)requestContext);
    }

    private static void validateClientParameters(QuarkusTLSClientParameters clientParameters) {
        if (clientParameters.getSSLSocketFactory() != null) {
            throw new IllegalStateException(VertxHttpClientHTTPConduit.class.getName() + " does not support SSLSocketFactory set via TLSClientParameters");
        }
        if (clientParameters.getSslContext() != null) {
            throw new IllegalStateException(VertxHttpClientHTTPConduit.class.getName() + " does not support SSLContext set via TLSClientParameters");
        }
        if (clientParameters.isUseHttpsURLConnectionDefaultSslSocketFactory()) {
            throw new IllegalStateException(VertxHttpClientHTTPConduit.class.getName() + " does not support TLSClientParameters.isUseHttpsURLConnectionDefaultSslSocketFactory() returning true");
        }
    }

    static ProxyType toProxyType(Proxy.Type type) {
        switch (type) {
            case HTTP: {
                return ProxyType.HTTP;
            }
            case SOCKS: {
                return ProxyType.SOCKS4;
            }
        }
        throw new IllegalArgumentException("Unexpected " + Proxy.Type.class.getName() + " " + type);
    }

    protected OutputStream createOutputStream(Message message, boolean possibleRetransmit, boolean isChunking, int chunkThreshold) throws IOException {
        RequestContext requestContext = (RequestContext)message.get(RequestContext.class);
        ResponseHandler responseHandler = new ResponseHandler(requestContext.uri, message, this.cookies, this.incomingObserver);
        RequestBodyHandler requestBodyHandler = new RequestBodyHandler(requestContext.clientInfo, message, requestContext.uri, this.cookies, this.userAgent, this.httpClientPool, requestContext.requestOptions, requestContext.clientSpec, requestContext.receiveTimeoutMs, responseHandler, requestContext.async, requestContext.autoRedirect, requestContext.maxRetransmits);
        return new RequestBodyOutputStream(chunkThreshold, requestBodyHandler);
    }

    static HttpVersion getVersion(Message message, HTTPClientPolicy csPolicy) {
        String verc = (String)message.getContextualProperty("org.apache.cxf.transport.http.forceVersion");
        Object enableHttp2 = message.getContextualProperty(ENABLE_HTTP2);
        if (verc == null && enableHttp2 != null) {
            csPolicy.setVersion("2");
        }
        if (verc == null) {
            verc = csPolicy.getVersion();
        }
        if (verc == null) {
            verc = "1.1";
        }
        HttpVersion v = switch (verc) {
            case "2" -> HttpVersion.HTTP_2;
            case "auto", "1.1" -> HttpVersion.HTTP_1_1;
            case "1.0" -> HttpVersion.HTTP_1_0;
            default -> throw new IllegalArgumentException("Unexpected HTTP protocol version " + verc);
        };
        return v;
    }

    static HttpMethod getMethod(Message message) {
        HttpMethod method;
        String rawRequestMethod = (String)message.get((Object)"org.apache.cxf.request.method");
        if (rawRequestMethod == null) {
            method = HttpMethod.POST;
            message.put((Object)"org.apache.cxf.request.method", (Object)"POST");
        } else {
            method = HttpMethod.valueOf((String)rawRequestMethod);
        }
        return method;
    }

    QuarkusTLSClientParameters findTLSClientParameters(Message message) {
        TLSClientParameters clientParameters = (TLSClientParameters)message.get(TLSClientParameters.class);
        if (clientParameters == null) {
            clientParameters = this.tlsClientParameters;
        }
        if (clientParameters == null) {
            clientParameters = new QuarkusTLSClientParameters(null, null);
        }
        if (clientParameters.getHostnameVerifier() != null) {
            throw new IllegalStateException(this.getConduitName() + " does not support setting a hostname verifier. AllowAllHostnameVerifier can be replaced by using a named TLS configuration with hostname-verification-algorithm set to NONE");
        }
        if (clientParameters instanceof QuarkusTLSClientParameters) {
            return (QuarkusTLSClientParameters)clientParameters;
        }
        throw new IllegalStateException(VertxHttpClientHTTPConduit.class.getName() + " accepts only " + QuarkusTLSClientParameters.class.getName());
    }

    public void setTlsClientParameters(TLSClientParameters params) {
        if (params != null && !(params instanceof QuarkusTLSClientParameters)) {
            throw new IllegalStateException(VertxHttpClientHTTPConduit.class.getName() + " accepts only " + QuarkusTLSClientParameters.class.getName());
        }
        super.setTlsClientParameters(params);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum UseAsyncPolicy {
        ALWAYS(true),
        NEVER(false),
        ASYNC_ONLY(false){

            @Override
            public boolean isAsync(Message message) {
                return !message.getExchange().isSynchronous();
            }
        };

        private final boolean async;
        static final Map<Object, UseAsyncPolicy> values;

        private UseAsyncPolicy(Boolean async) {
            this.async = async;
        }

        public static UseAsyncPolicy of(Object st) {
            if (st == null) {
                return ASYNC_ONLY;
            }
            if (st instanceof UseAsyncPolicy) {
                return (UseAsyncPolicy)((Object)st);
            }
            UseAsyncPolicy result = values.get(st);
            return result != null ? result : ASYNC_ONLY;
        }

        public boolean isAsync(Message message) {
            return this.async;
        }

        static {
            values = Map.of("ALWAYS", ALWAYS, "always", ALWAYS, "ASYNC_ONLY", ASYNC_ONLY, "async_only", ASYNC_ONLY, "NEVER", NEVER, "never", NEVER, Boolean.TRUE, ALWAYS, Boolean.FALSE, NEVER);
        }
    }

    record RequestContext(CXFClientInfo clientInfo, URI uri, RequestOptions requestOptions, HttpClientPool.ClientSpec clientSpec, long receiveTimeoutMs, boolean async, int maxRetransmits, boolean autoRedirect) {
    }

    static class ResponseHandler
    implements IOEHandler<ResponseEvent> {
        private static final Collection<Integer> DEFAULT_SERVICE_NOT_AVAILABLE_ON_HTTP_STATUS_CODES = Arrays.asList(404, 429, 503);
        private final URI url;
        private final Message outMessage;
        private final Cookies cookies;
        private final MessageObserver incomingObserver;

        public ResponseHandler(URI url, Message outMessage, Cookies cookies, MessageObserver incomingObserver) {
            this.url = url;
            this.outMessage = outMessage;
            this.cookies = cookies;
            this.incomingObserver = incomingObserver;
        }

        @Override
        public void handle(ResponseEvent responseEvent) throws IOException {
            String charset;
            String normalizedEncoding;
            HttpClientResponse response = responseEvent.response;
            Exchange exchange = this.outMessage.getExchange();
            URI uri = URI.create(response.request().absoluteURI());
            int responseCode = ResponseHandler.doProcessResponseCode(uri, response, exchange, this.outMessage);
            InputStream in = null;
            MessageImpl inMessage = new MessageImpl();
            inMessage.setExchange(exchange);
            ResponseHandler.updateResponseHeaders(response, (Message)inMessage, this.cookies);
            inMessage.put((Object)Message.RESPONSE_CODE, (Object)responseCode);
            if (MessageUtils.getContextualBoolean((Message)this.outMessage, (String)"org.apache.cxf.transport.http.set.response.message", (boolean)false)) {
                inMessage.put((Object)"http.responseMessage", (Object)response.statusMessage());
            }
            ResponseHandler.propagateConduit(exchange, (Message)inMessage);
            if ((!ResponseHandler.doProcessResponse(this.outMessage, responseCode) || 202 == responseCode) && MessageUtils.getContextualBoolean((Message)this.outMessage, (String)"org.apache.cxf.transport.process202Response", (boolean)true)) {
                in = ResponseHandler.getPartialResponse(response, responseEvent.responseBodyInputStream);
                if (in == null || !MessageUtils.getContextualBoolean((Message)this.outMessage, (String)"org.apache.cxf.transport.processOneWayResponse", (boolean)false)) {
                    ClientCallback cc;
                    if (ResponseHandler.isOneway(exchange) && responseCode > 300) {
                        String msg = "HTTP response '" + responseCode + ": " + response.statusMessage() + "' when communicating with " + this.url.toString();
                        throw new VertxHttpException(msg);
                    }
                    Endpoint ep = exchange.getEndpoint();
                    if (null != ep && null != ep.getEndpointInfo() && null == ep.getEndpointInfo().getProperty("org.apache.cxf.ws.addressing.MAPAggregator.decoupledDestination") && null != (cc = (ClientCallback)exchange.remove(ClientCallback.class))) {
                        cc.handleResponse(null, null);
                    }
                    exchange.put((Object)"IN_CHAIN_COMPLETE", (Object)Boolean.TRUE);
                    exchange.setInMessage((Message)inMessage);
                    if (MessageUtils.getContextualBoolean((Message)this.outMessage, (String)"org.apache.cxf.transport.propagate202Response", (boolean)false)) {
                        this.incomingObserver.onMessage((Message)inMessage);
                    }
                    return;
                }
            } else {
                this.outMessage.removeContent(OutputStream.class);
            }
            if ((normalizedEncoding = HttpHeaderHelper.mapCharset((String)(charset = HttpHeaderHelper.findCharset((String)((String)inMessage.get((Object)"Content-Type")))))) == null) {
                throw new VertxHttpException("Invalid character set " + charset + " in request");
            }
            inMessage.put((Object)Message.ENCODING, (Object)normalizedEncoding);
            if (in == null) {
                in = responseEvent.responseBodyInputStream;
            }
            inMessage.setContent(InputStream.class, (Object)in);
            this.incomingObserver.onMessage((Message)inMessage);
        }

        static int doProcessResponseCode(URI uri, HttpClientResponse response, Exchange exchange, Message outMessage) throws IOException {
            int rc = response.statusCode();
            if (exchange != null) {
                exchange.put((Object)Message.RESPONSE_CODE, (Object)rc);
                Collection serviceNotAvailableOnHttpStatusCodes = MessageUtils.getContextualIntegers((Message)outMessage, (String)"org.apache.cxf.transport.service_not_available_on_http_status_codes", DEFAULT_SERVICE_NOT_AVAILABLE_ON_HTTP_STATUS_CODES);
                if (serviceNotAvailableOnHttpStatusCodes.contains(rc)) {
                    exchange.put((Object)"org.apache.cxf.transport.service_not_available", (Object)true);
                }
            }
            if (!(rc < 400 || rc == 500 || MessageUtils.getContextualBoolean((Message)outMessage, (String)"org.apache.cxf.transport.no_io_exceptions") || rc <= 400 && MessageUtils.getContextualBoolean((Message)outMessage, (String)"org.apache.cxf.transport.process_fault_on_http_400"))) {
                throw new HTTPException(rc, response.statusMessage(), uri.toURL());
            }
            return rc;
        }

        static void updateResponseHeaders(HttpClientResponse response, Message inMessage, Cookies cookies) {
            Headers h = new Headers(inMessage);
            inMessage.put((Object)"Content-Type", (Object)ResponseHandler.readHeaders(response, h));
            cookies.readFromHeaders(h);
        }

        static InputStream getPartialResponse(HttpClientResponse response, InputStream responseBodyInputStream) {
            InputStream in = null;
            int responseCode = response.statusCode();
            if (responseCode == 202 || responseCode == 200) {
                boolean isEofTerminated;
                String transferEncoding;
                MultiMap headers = response.headers();
                String rawContentLength = headers.get("Content-Length");
                int contentLength = 0;
                if (rawContentLength != null) {
                    try {
                        contentLength = Integer.parseInt(rawContentLength);
                    }
                    catch (NumberFormatException e) {
                        log.debug((Object)("Could not parse Content-Length value " + rawContentLength));
                    }
                }
                boolean isChunked = (transferEncoding = headers.get("Transfer-Encoding")) != null && "chunked".equalsIgnoreCase(transferEncoding);
                String connection = headers.get("Connection");
                boolean bl = isEofTerminated = connection != null && "close".equalsIgnoreCase(connection);
                if (contentLength > 0) {
                    in = responseBodyInputStream;
                } else if (isChunked || isEofTerminated) {
                    try {
                        PushbackInputStream pin = new PushbackInputStream(responseBodyInputStream);
                        int c = pin.read();
                        if (c != -1) {
                            pin.unread((byte)c);
                            in = pin;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            return in;
        }

        static String readHeaders(HttpClientResponse response, Headers h) {
            Map dest = h.headerMap();
            String ct = null;
            for (Map.Entry en : response.headers().entries()) {
                String key = (String)en.getKey();
                dest.computeIfAbsent(key, k -> new ArrayList()).add((String)en.getValue());
                if (!"Content-Type".equalsIgnoreCase(key)) continue;
                ct = (String)en.getValue();
            }
            return ct;
        }

        static void propagateConduit(Exchange exchange, Message in) {
            Message out;
            if (exchange != null && (out = exchange.getOutMessage()) != null) {
                in.put(Conduit.class, (Object)((Conduit)out.get(Conduit.class)));
            }
        }

        static boolean doProcessResponse(Message message, int responseCode) {
            if (!ResponseHandler.isOneway(message.getExchange())) {
                return true;
            }
            return responseCode == 500 && MessageUtils.getContextualBoolean((Message)message, (String)"org.apache.cxf.oneway.robust", (boolean)false);
        }

        static boolean isOneway(Exchange exchange) {
            return exchange != null && exchange.isOneWay();
        }
    }

    static class RequestBodyHandler
    implements IOEHandler<RequestBodyEvent> {
        private final Message outMessage;
        private final URI url;
        private final Cookies cookies;
        private final String userAgent;
        private final HttpClientPool clientPool;
        private final RequestOptions requestOptions;
        private final HttpClientPool.ClientSpec clientSpec;
        private boolean firstEvent = true;
        private Future<BodyRecorder.BodyWriter> bodyWriter;
        private Future<BodyRecorder.StoredBody> body;
        private Result<HttpClientRequest> request;
        private final boolean possibleRetransmit;
        private List<URI> redirects;
        private final int maxRetransmits;
        private final CXFClientInfo clientInfo;
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition requestReady = this.lock.newCondition();
        private final Condition requestWriteable = this.lock.newCondition();
        private boolean drainHandlerRegistered;
        private boolean waitingForDrain;
        private Mode mode;

        public RequestBodyHandler(CXFClientInfo clientInfo, Message outMessage, URI url, Cookies cookies, String userAgent, HttpClientPool clientPool, RequestOptions requestOptions, HttpClientPool.ClientSpec clientSpec, long receiveTimeoutMs, IOEHandler<ResponseEvent> responseHandler, boolean isAsync, boolean possibleRetransmit, int maxRetransmits) {
            this.clientInfo = clientInfo;
            this.outMessage = outMessage;
            this.url = url;
            this.cookies = cookies;
            this.userAgent = userAgent;
            this.clientPool = clientPool;
            this.requestOptions = requestOptions;
            this.clientSpec = clientSpec;
            long deadline = System.currentTimeMillis() + receiveTimeoutMs;
            this.mode = isAsync ? new Mode.Async(url, deadline, responseHandler, outMessage) : new Mode.Sync(url, deadline, responseHandler, this.lock);
            this.possibleRetransmit = possibleRetransmit;
            this.maxRetransmits = maxRetransmits;
        }

        @Override
        public void handle(RequestBodyEvent event) throws IOException {
            Buffer buffer = event.buffer();
            boolean finalChunk = event.eventType().isFinalChunk();
            if (this.firstEvent) {
                this.firstEvent = false;
                if (this.possibleRetransmit) {
                    Future bw = BodyRecorder.openWriter((ContextInternal)this.clientPool.getVertx().getOrCreateContext(), this.clientInfo.getRetransmitCache());
                    bw = bw.compose(w -> w.write(buffer.slice()));
                    if (finalChunk) {
                        this.body = bw.compose(w -> w.close());
                    } else {
                        this.bodyWriter = bw;
                    }
                    this.redirects = new ArrayList<URI>();
                    ArrayList<URI> redirs = this.redirects;
                    redirs.add(this.url);
                }
                HttpClient client = this.clientPool.getClient(this.clientSpec);
                if (event.eventType() == RequestBodyEvent.RequestBodyEventType.COMPLETE_BODY && RequestBodyHandler.requestHasBody(this.requestOptions.getMethod())) {
                    this.requestOptions.putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(buffer.length()));
                }
                RequestBodyHandler.setProtocolHeaders(this.outMessage, this.requestOptions, this.userAgent);
                client.request(this.requestOptions).onSuccess(req -> {
                    if (!finalChunk) {
                        req.setChunked(true).write((Object)buffer).onFailure(t -> this.mode.responseFailed((Throwable)t, true));
                        this.lock.lock();
                        try {
                            this.request = new Result<HttpClientRequest>((HttpClientRequest)req, null);
                            this.requestReady.signal();
                        }
                        finally {
                            this.lock.unlock();
                        }
                    } else {
                        this.finishRequest((HttpClientRequest)req, buffer);
                    }
                }).onFailure(t -> {
                    this.lock.lock();
                    try {
                        this.request = Result.failure(t);
                        this.requestReady.signal();
                        this.mode.responseFailed((Throwable)t, false);
                    }
                    finally {
                        this.lock.unlock();
                    }
                });
                if (finalChunk) {
                    this.mode.awaitResponse();
                }
            } else {
                Future bw = this.bodyWriter;
                if (bw != null) {
                    bw = bw.compose(w -> w.write(buffer.slice()));
                    if (finalChunk) {
                        this.body = bw.compose(w -> w.close());
                        this.bodyWriter = null;
                    } else {
                        this.bodyWriter = bw;
                    }
                }
                HttpClientRequest req2 = this.awaitRequest();
                if (!finalChunk) {
                    req2.write((Object)buffer).onFailure(this::failResponse);
                } else {
                    this.finishRequest(req2, buffer);
                    this.mode.awaitResponse();
                }
            }
        }

        void finishRequest(HttpClientRequest req, Buffer buffer) {
            this.prepareResponse(req);
            req.end(buffer).onFailure(t -> this.mode.responseFailed((Throwable)t, true));
        }

        private void prepareResponse(HttpClientRequest req) {
            req.response().onComplete(ar -> {
                InputStreamWriteStream sink = new InputStreamWriteStream(2);
                HttpClientResponse response = (HttpClientResponse)ar.result();
                if (ar.succeeded()) {
                    boolean isRedirect = RequestBodyHandler.isRedirect(response.statusCode());
                    if (this.possibleRetransmit && isRedirect && (this.maxRetransmits < 0 || RequestBodyHandler.performedRetransmits(this.redirects) < this.maxRetransmits)) {
                        ResponseHandler.updateResponseHeaders(response, this.outMessage, this.cookies);
                        String loc = response.getHeader("Location");
                        try {
                            if (loc != null && !loc.startsWith("http") && !MessageUtils.getContextualBoolean((Message)this.outMessage, (String)VertxHttpClientHTTPConduit.AUTO_REDIRECT_ALLOW_REL_URI)) {
                                String qKey = QuarkusCxfUtils.quoteCongurationKeyIfNeeded(this.clientInfo.getConfigKey());
                                throw new IOException("Illegal relative redirect " + loc + " detected by client " + qKey + "; you may want to set quarkus.cxf.client." + qKey + ".redirect-relative-uri = true");
                            }
                            URI previousUri = this.redirects.get(this.redirects.size() - 1);
                            URI newUri = HttpUtils.resolveURIReference((URI)previousUri, (String)loc);
                            String configKey = this.clientInfo.getConfigKey();
                            RequestBodyHandler.detectRedirectLoop(configKey, this.redirects, newUri, this.outMessage);
                            this.redirects.add(newUri);
                            RequestBodyHandler.checkAllowedRedirectUri(configKey, previousUri, newUri, this.outMessage);
                            this.redirectRetransmit(newUri);
                        }
                        catch (IOException e) {
                            sink.setException(e);
                            this.mode.responseReady(new Result<ResponseEvent>(ResponseEvent.prepare(this.body, response, sink), e));
                        }
                        catch (URISyntaxException e) {
                            IOException ioe = new IOException("Could not resolve redirect Location " + loc + " relative to " + this.url, e);
                            sink.setException(ioe);
                            this.mode.responseReady(new Result<ResponseEvent>(ResponseEvent.prepare(this.body, response, sink), ioe));
                        }
                        catch (Exception e) {
                            IOException ioe = new IOException(e);
                            sink.setException(ioe);
                            this.mode.responseReady(new Result<ResponseEvent>(ResponseEvent.prepare(this.body, response, sink), ioe));
                        }
                        return;
                    }
                    if (!this.possibleRetransmit && isRedirect) {
                        String qKey = QuarkusCxfUtils.quoteCongurationKeyIfNeeded(this.clientInfo.getConfigKey());
                        IOException ioe = new IOException("Received redirection status " + response.statusCode() + " from " + this.url + " by client " + qKey + " but following redirects is not enabled for this client. You may want to set quarkus.cxf.client." + qKey + ".auto-redirect = true");
                        sink.setException(ioe);
                        this.mode.responseReady(new Result<ResponseEvent>(ResponseEvent.prepare(this.body, response, sink), ioe));
                        return;
                    }
                    if (this.possibleRetransmit && isRedirect && this.maxRetransmits >= 0 && this.maxRetransmits <= RequestBodyHandler.performedRetransmits(this.redirects)) {
                        String qKey = QuarkusCxfUtils.quoteCongurationKeyIfNeeded(this.clientInfo.getConfigKey());
                        IOException ioe = new IOException("Received redirection status " + response.statusCode() + " from " + this.redirects.get(this.redirects.size() - 1) + " by client " + qKey + ", but already performed maximum number " + this.maxRetransmits + " of allowed retransmits; you may want to increase quarkus.cxf.client." + qKey + ".max-retransmits. Visited URIs: " + this.redirects.stream().map(URI::toString).collect(Collectors.joining(" -> ")));
                        sink.setException(ioe);
                        this.mode.responseReady(new Result<ResponseEvent>(ResponseEvent.prepare(this.body, response, sink), ioe));
                        return;
                    }
                    response.pipeTo((WriteStream)sink);
                } else if (ar.cause() instanceof IOException) {
                    sink.setException((IOException)ar.cause());
                } else {
                    sink.setException(new IOException(ar.cause()));
                }
                this.mode.responseReady(new Result<ResponseEvent>(ResponseEvent.prepare(this.body, response, sink), ar.cause()));
            });
        }

        private static int performedRetransmits(List<URI> retransmits) {
            return retransmits.size() - 1;
        }

        void redirectRetransmit(URI newURL) throws IOException {
            String query;
            Object requestURI;
            boolean ssl;
            if (log.isDebugEnabled()) {
                log.debugf("Redirect retransmit: %s", (Object)this.redirects.stream().map(URI::toString).collect(Collectors.joining(" -> ")));
            }
            int port = newURL.getPort();
            String protocol = newURL.getScheme();
            char chend = protocol.charAt(protocol.length() - 1);
            if (chend == 'p') {
                ssl = false;
                if (port == -1) {
                    port = 80;
                }
            } else if (chend == 's') {
                ssl = true;
                if (port == -1) {
                    port = 443;
                }
            } else {
                throw new IllegalStateException("Unexpected URI scheme " + protocol + "; expected 'http' or 'https'");
            }
            if ((requestURI = newURL.getPath()) == null || ((String)requestURI).isEmpty()) {
                requestURI = "/";
            }
            if ((query = newURL.getQuery()) != null) {
                requestURI = (String)requestURI + "?" + query;
            }
            RequestOptions options = new RequestOptions(this.requestOptions);
            options.setHost(newURL.getHost());
            options.setPort(Integer.valueOf(port));
            options.setSsl(Boolean.valueOf(ssl));
            options.setURI((String)requestURI);
            this.body.compose(storedBody -> {
                long contentLength = storedBody.length();
                if (contentLength >= 0L && RequestBodyHandler.requestHasBody(options.getMethod())) {
                    options.putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(contentLength));
                } else {
                    options.removeHeader(HttpHeaders.CONTENT_LENGTH);
                }
                HttpClient client = this.clientPool.getClient(this.clientSpec);
                return client.request(options).compose(req -> {
                    this.prepareResponse((HttpClientRequest)req);
                    return storedBody.pipeTo((HttpClientRequest)req).compose(v -> Future.succeededFuture((Object)req));
                });
            }).onFailure(t -> {
                this.lock.lock();
                try {
                    this.request = Result.failure(t);
                    this.requestReady.signal();
                    this.mode.responseFailed((Throwable)t, false);
                }
                finally {
                    this.lock.unlock();
                }
            });
        }

        private static boolean isRedirect(int statusCode) {
            return statusCode >= 301 && (statusCode == 302 || statusCode == 301 || statusCode == 303 || statusCode == 307);
        }

        private static void detectRedirectLoop(String configKey, List<URI> redirects, URI newURL, Message message) throws IOException {
            if (redirects.contains(newURL)) {
                Integer maxSameURICount = PropertyUtils.getInteger((Message)message, (String)VertxHttpClientHTTPConduit.AUTO_REDIRECT_MAX_SAME_URI_COUNT);
                String qKey = QuarkusCxfUtils.quoteCongurationKeyIfNeeded(configKey);
                if (maxSameURICount != null) {
                    long sameUriRetransmitsToBePerformed = redirects.stream().skip(1L).filter(newURL::equals).count() + 1L;
                    if (sameUriRetransmitsToBePerformed > maxSameURICount.longValue()) {
                        String msg = "Redirect chain with too many same URIs " + newURL + " (found " + sameUriRetransmitsToBePerformed + ", allowed <= " + maxSameURICount.longValue() + ") detected by client " + qKey + ": " + redirects.stream().map(URI::toString).collect(Collectors.joining(" -> ")) + " -> " + newURL + ". You may want to increase quarkus.cxf.client." + qKey + ".max-same-uri";
                        throw new IOException(msg);
                    }
                    return;
                }
                String msg = "Redirect loop detected by client " + qKey + ": " + redirects.stream().map(URI::toString).collect(Collectors.joining(" -> ")) + " -> " + newURL + ". You may want to increase quarkus.cxf.client." + qKey + ".max-same-uri";
                throw new IOException(msg);
            }
        }

        private static void checkAllowedRedirectUri(String configKey, URI lastUri, URI newUri, Message message) throws IOException {
            if (!(!MessageUtils.getContextualBoolean((Message)message, (String)VertxHttpClientHTTPConduit.AUTO_REDIRECT_SAME_HOST_ONLY) || newUri.getScheme().equals(lastUri.getScheme()) && newUri.getHost().equals(lastUri.getHost()))) {
                String qKey = QuarkusCxfUtils.quoteCongurationKeyIfNeeded(configKey);
                String msg = "Different HTTP scheme or different host detected in redirect URI " + newUri + " compared to original URI " + lastUri + " by client " + qKey;
                throw new IOException(msg);
            }
            String allowedRedirectURI = (String)message.getContextualProperty(VertxHttpClientHTTPConduit.AUTO_REDIRECT_ALLOWED_URI);
            if (allowedRedirectURI != null && !newUri.toString().startsWith(allowedRedirectURI)) {
                String qKey = QuarkusCxfUtils.quoteCongurationKeyIfNeeded(configKey);
                String msg = "Illegal redirect URI " + newUri + " detected by client " + qKey + "; expected to start with " + allowedRedirectURI;
                throw new IOException(msg);
            }
        }

        void failResponse(Throwable t) {
        }

        static void setProtocolHeaders(Message outMessage, RequestOptions requestOptions, String userAgent) throws IOException {
            MultiMap outHeaders;
            String contentType;
            Headers h = new Headers(outMessage);
            if (RequestBodyHandler.requestHasBody(requestOptions.getMethod()) && (contentType = h.determineContentType()) != null) {
                requestOptions.putHeader("Content-Type", contentType);
                outHeaders = requestOptions.getHeaders();
            } else {
                outHeaders = HttpHeaders.headers();
                requestOptions.setHeaders(outHeaders);
            }
            boolean addHeaders = MessageUtils.getContextualBoolean((Message)outMessage, (String)"org.apache.cxf.http.add-headers", (boolean)false);
            for (Map.Entry header : h.headerMap().entrySet()) {
                if ("Content-Type".equalsIgnoreCase((String)header.getKey())) continue;
                if (addHeaders || "Cookie".equalsIgnoreCase((String)header.getKey())) {
                    values = (List)header.getValue();
                    for (String s : values) {
                        outHeaders.add("Cookie", s);
                    }
                } else if (!"Content-Length".equalsIgnoreCase((String)header.getKey())) {
                    values = (List)header.getValue();
                    int len = values.size();
                    switch (len) {
                        case 0: {
                            outHeaders.set((String)header.getKey(), "");
                            break;
                        }
                        case 1: {
                            outHeaders.set((String)header.getKey(), (String)values.get(0));
                            break;
                        }
                        default: {
                            StringBuilder b = new StringBuilder();
                            for (int i = 0; i < len; ++i) {
                                b.append((String)values.get(i));
                                if (i + 1 >= len) continue;
                                b.append(',');
                            }
                            outHeaders.set((String)header.getKey(), b.toString());
                        }
                    }
                }
                if (outHeaders.contains("User-Agent")) continue;
                outHeaders.set("User-Agent", userAgent);
            }
        }

        static boolean requestHasBody(HttpMethod method) {
            if (HttpMethod.POST == method) {
                return true;
            }
            return method != HttpMethod.GET && method != HttpMethod.HEAD && method != HttpMethod.OPTIONS && method != HttpMethod.TRACE;
        }

        HttpClientRequest awaitRequest() throws IOException {
            if (this.request == null) {
                this.lock.lock();
                try {
                    if (!(this.request != null || this.requestReady.await(this.requestOptions.getConnectTimeout(), TimeUnit.MILLISECONDS) && this.request != null)) {
                        throw new SocketTimeoutException("Timeout waiting for HTTP connect to " + this.url);
                    }
                    if (this.request.succeeded()) {
                        this.awaitWriteable(this.request.result());
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted waiting for HTTP response from " + this.url, e);
                }
                finally {
                    this.lock.unlock();
                }
            }
            if (this.request.succeeded()) {
                return this.request.result();
            }
            Throwable e = this.request.cause();
            throw new IOException("Unable to connect to " + this.url, e);
        }

        void awaitWriteable(HttpClientRequest request) throws IOException, InterruptedException {
            while (request.writeQueueFull()) {
                if (this.request.cause() != null) {
                    throw new IOException(this.request.cause());
                }
                if (!BlockingOperationControl.isBlockingAllowed()) {
                    throw new IllegalStateException("Attempting a blocking write on io thread");
                }
                if (!this.drainHandlerRegistered) {
                    this.drainHandlerRegistered = true;
                    Handler<Void> drainHandler = new Handler<Void>(){

                        public void handle(Void event) {
                            if (waitingForDrain) {
                                lock.lock();
                                try {
                                    requestWriteable.signal();
                                }
                                finally {
                                    lock.unlock();
                                }
                            }
                        }
                    };
                    request.drainHandler((Handler)drainHandler);
                }
                try {
                    this.waitingForDrain = true;
                    if (this.requestWriteable.await(this.mode.receiveTimeout(), TimeUnit.MILLISECONDS)) continue;
                    throw new SocketTimeoutException("Timeout waiting for sending HTTP headers to " + this.url);
                }
                finally {
                    this.waitingForDrain = false;
                }
            }
        }

        static abstract class Mode {
            private final long receiveTimeoutDeadline;
            protected final URI url;
            protected final IOEHandler<ResponseEvent> responseHandler;

            Mode(URI url, long receiveTimeoutDeadline, IOEHandler<ResponseEvent> responseHandler) {
                this.url = url;
                this.receiveTimeoutDeadline = receiveTimeoutDeadline;
                this.responseHandler = responseHandler;
            }

            long receiveTimeout() throws SocketTimeoutException {
                long timeout = this.receiveTimeoutDeadline - System.currentTimeMillis();
                if (timeout <= 0L) {
                    throw new SocketTimeoutException("Timeout waiting for HTTP response from " + this.url);
                }
                return timeout;
            }

            protected abstract void responseFailed(Throwable var1, boolean var2);

            protected abstract void responseReady(Result<ResponseEvent> var1);

            protected abstract void awaitResponse() throws IOException;

            static class Async
            extends Mode {
                private final Message outMessage;

                Async(URI url, long receiveTimeoutDeadline, IOEHandler<ResponseEvent> responseHandler, Message outMessage) {
                    super(url, receiveTimeoutDeadline, responseHandler);
                    this.outMessage = outMessage;
                }

                @Override
                protected void responseFailed(Throwable t, boolean lockIfNeeded) {
                    this.responseReady(Result.failure(t));
                }

                protected void responseFailedOnWorkerThread(Throwable t) {
                    ((PhaseInterceptorChain)this.outMessage.getInterceptorChain()).abort();
                    this.outMessage.setContent(Exception.class, (Object)t);
                    if (t instanceof Exception) {
                        this.outMessage.put(Exception.class, (Object)((Exception)t));
                    }
                    ((PhaseInterceptorChain)this.outMessage.getInterceptorChain()).unwind(this.outMessage);
                    MessageObserver mo = this.outMessage.getInterceptorChain().getFaultObserver();
                    if (mo == null) {
                        mo = (MessageObserver)this.outMessage.getExchange().get(MessageObserver.class);
                    }
                    mo.onMessage(this.outMessage);
                }

                @Override
                protected void responseReady(Result<ResponseEvent> response) {
                    InstanceHandle managedExecutorInst = Arc.container().instance(ManagedExecutor.class, new Annotation[0]);
                    if (!managedExecutorInst.isAvailable()) {
                        throw new IllegalStateException(ManagedExecutor.class.getName() + " not available in Arc");
                    }
                    ((ManagedExecutor)managedExecutorInst.get()).execute(() -> {
                        if (response.succeeded()) {
                            try {
                                this.responseHandler.handle((ResponseEvent)response.result());
                            }
                            catch (Throwable e) {
                                this.responseFailedOnWorkerThread(e);
                            }
                        } else {
                            this.responseFailedOnWorkerThread(response.cause());
                        }
                    });
                }

                @Override
                protected void awaitResponse() throws IOException {
                }
            }

            static class Sync
            extends Mode {
                private final ReentrantLock lock;
                private final Condition responseReceived;
                private Result<ResponseEvent> response;

                Sync(URI url, long receiveTimeoutDeadline, IOEHandler<ResponseEvent> responseHandler, ReentrantLock lock) {
                    super(url, receiveTimeoutDeadline, responseHandler);
                    this.lock = lock;
                    this.responseReceived = lock.newCondition();
                }

                @Override
                protected void responseFailed(Throwable t, boolean lockIfNeeded) {
                    if (lockIfNeeded) {
                        this.lock.lock();
                        try {
                            this.response = Result.failure(t);
                            this.responseReceived.signal();
                        }
                        finally {
                            this.lock.unlock();
                        }
                    } else {
                        this.response = Result.failure(t);
                        this.responseReceived.signal();
                    }
                }

                @Override
                protected void responseReady(Result<ResponseEvent> response) {
                    this.lock.lock();
                    try {
                        this.response = response;
                        this.responseReceived.signal();
                    }
                    finally {
                        this.lock.unlock();
                    }
                }

                @Override
                protected void awaitResponse() throws IOException {
                    this.responseHandler.handle(this.awaitResponseInternal());
                }

                ResponseEvent awaitResponseInternal() throws IOException {
                    if (this.response == null) {
                        this.lock.lock();
                        try {
                            if (!(this.response != null || this.responseReceived.await(this.receiveTimeout(), TimeUnit.MILLISECONDS) && this.response != null)) {
                                throw new SocketTimeoutException("Timeout waiting for HTTP response from " + this.url);
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new IOException("Interrupted waiting for HTTP response from " + this.url, e);
                        }
                        finally {
                            this.lock.unlock();
                        }
                    }
                    if (this.response.succeeded()) {
                        return this.response.result();
                    }
                    Throwable e = this.response.cause();
                    throw new IOException("Unable to receive HTTP response from " + this.url, e);
                }
            }
        }
    }

    public static interface IOEHandler<E> {
        public void handle(E var1) throws IOException;
    }

    static class RequestBodyOutputStream
    extends OutputStream {
        private Buffer buffer;
        private final int chunkSize;
        private final IOEHandler<RequestBodyEvent> bodyHandler;
        private boolean closed = false;
        private boolean firstChunkSent = false;

        public RequestBodyOutputStream(int chunkSize, IOEHandler<RequestBodyEvent> bodyHandler) {
            this.chunkSize = chunkSize;
            this.bodyHandler = bodyHandler;
            this.buffer = Buffer.buffer((int)chunkSize);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.chunkSize > 0) {
                int remainingCapacity;
                while ((remainingCapacity = this.chunkSize - this.buffer.length()) < len) {
                    this.buffer.appendBytes(b, off, remainingCapacity);
                    off += remainingCapacity;
                    len -= remainingCapacity;
                    Buffer buf = this.buffer;
                    this.bodyHandler.handle(new RequestBodyEvent(buf, RequestBodyEvent.RequestBodyEventType.NON_FINAL_CHUNK));
                    this.firstChunkSent = true;
                    this.buffer = Buffer.buffer((int)this.chunkSize);
                }
            }
            if (len > 0) {
                this.buffer.appendBytes(b, off, len);
            }
        }

        @Override
        public void write(int b) throws IOException {
            if (this.chunkSize > 0 && this.buffer.length() == this.chunkSize) {
                Buffer buf = this.buffer;
                this.bodyHandler.handle(new RequestBodyEvent(buf, RequestBodyEvent.RequestBodyEventType.NON_FINAL_CHUNK));
                this.firstChunkSent = true;
                this.buffer = Buffer.buffer((int)this.chunkSize);
            }
            this.buffer.appendByte((byte)b);
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                super.close();
                RequestBodyEvent.RequestBodyEventType eventType = this.firstChunkSent ? RequestBodyEvent.RequestBodyEventType.FINAL_CHUNK : RequestBodyEvent.RequestBodyEventType.COMPLETE_BODY;
                Buffer buf = this.buffer;
                this.buffer = null;
                this.bodyHandler.handle(new RequestBodyEvent(buf, eventType));
            }
        }
    }

    static class InputStreamWriteStream
    extends InputStream
    implements WriteStream<Buffer> {
        private static final Buffer END = new DummyBuffer();
        private final Queue<Buffer> queue;
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition queueChange = this.lock.newCondition();
        private volatile Handler<Void> drainHandler;
        private volatile IOException exception;
        private int maxQueueSize;
        private Buffer readBuffer;
        private int readPosition = 0;

        public InputStreamWriteStream(int queueSize) {
            this.setWriteQueueMaxSize(queueSize);
            this.queue = new ArrayDeque<Buffer>(queueSize);
        }

        public WriteStream<Buffer> exceptionHandler(Handler<Throwable> handler) {
            throw new UnsupportedOperationException();
        }

        public Future<Void> write(Buffer data) {
            Promise promise = Promise.promise();
            this.write(data, (Handler<AsyncResult<Void>>)promise);
            return promise.future();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(Buffer data, Handler<AsyncResult<Void>> handler) {
            try {
                ReentrantLock lock = this.lock;
                lock.lock();
                try {
                    this.queue.offer(data);
                    this.queueChange.signal();
                }
                finally {
                    lock.unlock();
                }
                handler.handle((Object)Future.succeededFuture());
            }
            catch (Throwable e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (this.exception == null) {
                    this.exception = e instanceof IOException ? (IOException)e : new IOException(e);
                }
                handler.handle((Object)Future.failedFuture((Throwable)e));
            }
        }

        public void end(Handler<AsyncResult<Void>> handler) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                this.queue.offer(END);
                this.queueChange.signal();
            }
            finally {
                lock.unlock();
            }
        }

        public WriteStream<Buffer> setWriteQueueMaxSize(int maxSize) {
            if (maxSize < 1) {
                throw new IllegalArgumentException("maxSize must be >= 1");
            }
            this.maxQueueSize = maxSize;
            return this;
        }

        public boolean writeQueueFull() {
            return this.queue.size() >= this.maxQueueSize;
        }

        public WriteStream<Buffer> drainHandler(Handler<Void> handler) {
            this.drainHandler = handler;
            return this;
        }

        @Override
        public int read() throws IOException {
            IOException e = this.exception;
            if (e != null) {
                throw e;
            }
            Buffer rb = this.takeBuffer(true);
            return rb != null ? rb.getByte(this.readPosition++) & 0xFF : -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result;
            IOException e = this.exception;
            if (e != null) {
                throw e;
            }
            Buffer rb = this.takeBuffer(true);
            if (rb == null) {
                return -1;
            }
            int rbLen = rb.length();
            int readable = rbLen - this.readPosition;
            if (readable >= len) {
                readable = len;
                rb.getBytes(this.readPosition, this.readPosition + readable, b, off);
                this.readPosition += readable;
                if (this.readPosition >= rbLen && this.readBuffer != END) {
                    this.readBuffer = null;
                }
                result = readable;
            } else {
                rb.getBytes(this.readPosition, this.readPosition + readable, b, off);
                this.readPosition += readable;
                len -= readable;
                int off2 = off + readable;
                result = readable;
                while (len > 0 && (rb = this.takeBuffer(false)) != null) {
                    rbLen = rb.length();
                    readable = rbLen - this.readPosition;
                    if (readable > len) {
                        readable = len;
                    }
                    rb.getBytes(this.readPosition, this.readPosition + readable, b, off2);
                    this.readPosition += readable;
                    len -= readable;
                    off2 += readable;
                    result += readable;
                }
                if (this.readPosition == rbLen && this.readBuffer != END) {
                    this.readBuffer = null;
                }
            }
            return result;
        }

        @Override
        public void close() {
            this.readBuffer = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                Buffer rb = this.takeBuffer(false);
                if (rb != null) {
                    int result = rb.length() - this.readPosition;
                    for (Buffer b : this.queue) {
                        if (rb == b) continue;
                        result += b.length();
                    }
                    int n = result;
                    return n;
                }
            }
            finally {
                lock.unlock();
            }
            return 0;
        }

        private Buffer takeBuffer(boolean blockingAwaitBuffer) throws IOException {
            Buffer rb = this.readBuffer;
            if (rb == END) {
                return null;
            }
            if (rb == null || this.readPosition >= rb.length()) {
                Handler<Void> dh;
                ReentrantLock lock = this.lock;
                try {
                    lock.lockInterruptibly();
                    if (blockingAwaitBuffer) {
                        while (true) {
                            this.readBuffer = rb = this.queue.poll();
                            if (rb == null) {
                                this.queueChange.await();
                                continue;
                            }
                            break;
                        }
                    } else {
                        this.readBuffer = rb = this.queue.poll();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException(e);
                }
                finally {
                    lock.unlock();
                }
                if (rb == END) {
                    return null;
                }
                this.readPosition = 0;
                if (!this.writeQueueFull() && (dh = this.drainHandler) != null) {
                    dh.handle(null);
                }
            }
            return rb;
        }

        public void setException(IOException exception) {
            if (this.exception == null) {
                this.exception = exception;
            }
        }
    }

    record Result<T>(T result, Throwable cause) {
        static <T> Result<T> failure(Throwable cause) {
            return new Result<Object>(null, cause);
        }

        boolean succeeded() {
            return this.cause == null;
        }
    }

    record ResponseEvent(HttpClientResponse response, InputStream responseBodyInputStream) {
        public static ResponseEvent prepare(Future<BodyRecorder.StoredBody> body, HttpClientResponse response, InputStream responseBodyInputStream) {
            if (body != null) {
                body.compose(b -> b.discard());
            }
            return new ResponseEvent(response, responseBodyInputStream);
        }
    }

    record RequestBodyEvent(Buffer buffer, RequestBodyEventType eventType) {

        public static enum RequestBodyEventType {
            NON_FINAL_CHUNK(false),
            FINAL_CHUNK(true),
            COMPLETE_BODY(true);

            private final boolean finalChunk;

            private RequestBodyEventType(boolean finalChunk) {
                this.finalChunk = finalChunk;
            }

            public boolean isFinalChunk() {
                return this.finalChunk;
            }
        }
    }
}

