/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.loggingjson;

import io.quarkiverse.loggingjson.Config;
import io.quarkiverse.loggingjson.JsonFactory;
import io.quarkiverse.loggingjson.JsonGenerator;
import io.quarkiverse.loggingjson.JsonProvider;
import io.quarkiverse.loggingjson.StringBuilderWriter;
import java.util.List;
import org.jboss.logmanager.ExtFormatter;
import org.jboss.logmanager.ExtLogRecord;

public class JsonFormatter
extends ExtFormatter {
    private final List<JsonProvider> providers;
    private final JsonFactory jsonFactory;
    private final String recordDelimiter;

    public JsonFormatter(List<JsonProvider> providers, JsonFactory jsonFactory, Config config) {
        this.providers = providers;
        this.jsonFactory = jsonFactory;
        this.recordDelimiter = config.recordDelimiter;
    }

    public String format(ExtLogRecord record) {
        try {
            StringBuilderWriter writer = new StringBuilderWriter();
            try (JsonGenerator generator = this.jsonFactory.createGenerator(writer);){
                generator.writeStartObject();
                for (JsonProvider provider : this.providers) {
                    provider.writeTo(generator, record);
                }
                generator.writeEndObject();
                generator.flush();
                if (this.recordDelimiter != null) {
                    writer.write(this.recordDelimiter);
                }
            }
            return writer.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

