/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.loggingjson.providers;

import io.quarkiverse.loggingjson.Config;
import io.quarkiverse.loggingjson.Enabled;
import io.quarkiverse.loggingjson.JsonGenerator;
import io.quarkiverse.loggingjson.JsonProvider;
import io.quarkiverse.loggingjson.JsonWritingUtils;
import java.io.IOException;
import org.jboss.logmanager.ExtLogRecord;

public class ErrorMessageJsonProvider
implements JsonProvider,
Enabled {
    private final String fieldName;
    private final Config.FieldConfig config;

    public ErrorMessageJsonProvider(Config.FieldConfig config) {
        this(config, "errorMessage");
    }

    public ErrorMessageJsonProvider(Config.FieldConfig config, String defaultName) {
        this.config = config;
        this.fieldName = config.fieldName.orElse(defaultName);
    }

    @Override
    public void writeTo(JsonGenerator generator, ExtLogRecord event) throws IOException {
        if (event.getThrown() != null) {
            JsonWritingUtils.writeStringField(generator, this.fieldName, event.getThrown().getMessage());
        }
    }

    @Override
    public boolean isEnabled() {
        return this.config.enabled.orElse(true);
    }
}

