/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.http;

import io.quarkus.amazon.lambda.http.LambdaHttpRecorder;
import io.quarkus.amazon.lambda.http.model.CognitoAuthorizerClaims;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;

public class CognitoPrincipal
implements JsonWebToken {
    private CognitoAuthorizerClaims claims;
    private String name;
    private Set<String> audience;
    private Set<String> groups;

    public CognitoPrincipal(CognitoAuthorizerClaims claims) {
        this.claims = claims;
        this.name = claims.getUsername();
    }

    public Set<String> getClaimNames() {
        return null;
    }

    public <T> T getClaim(String claimName) {
        if (claimName.equals(Claims.groups)) {
            return (T)this.getGroups();
        }
        if (claimName.equals(Claims.groups)) {
            return (T)this.getAudience();
        }
        if (claimName.equals(Claims.exp)) {
            return (T)Long.valueOf(this.getExpirationTime());
        }
        if (claimName.equals(Claims.iat)) {
            return (T)Long.valueOf(this.getIssuedAtTime());
        }
        if (claimName.equals(Claims.aud)) {
            return (T)this.getAudience();
        }
        return (T)this.claims.getClaim(claimName);
    }

    public String getIssuer() {
        return this.claims.getIssuer();
    }

    public Set<String> getAudience() {
        if (this.audience == null) {
            this.audience = new HashSet<String>();
            this.audience.add(this.claims.getAudience());
        }
        return this.audience;
    }

    public String getSubject() {
        return this.claims.getSubject();
    }

    public long getExpirationTime() {
        return Long.valueOf(this.claims.getExpiration());
    }

    public long getIssuedAtTime() {
        return Long.valueOf(this.claims.getIssuedAt());
    }

    public Set<String> getGroups() {
        if (this.groups == null) {
            String grpClaim = this.claims.getClaim(LambdaHttpRecorder.config.cognitoRoleClaim());
            if (grpClaim != null) {
                Matcher matcher = LambdaHttpRecorder.groupPattern.matcher(grpClaim);
                this.groups = new HashSet<String>();
                while (matcher.find()) {
                    this.groups.add(matcher.group(matcher.groupCount()));
                }
            } else {
                this.groups = Collections.EMPTY_SET;
            }
        }
        return this.groups;
    }

    public String getName() {
        return this.name;
    }

    public CognitoAuthorizerClaims getClaims() {
        return this.claims;
    }
}

