/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.remotedev;

import io.quarkus.remotedev.QuarkusWebsocketProtocol;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.ContainerProvider;
import javax.websocket.Endpoint;
import javax.websocket.Session;

public class AgentRunner
extends QuarkusWebsocketProtocol {
    private static final String REMOTE_PASSWORD = "quarkus-security-key";
    private final Map<String, Long> classChangeTimes = new ConcurrentHashMap<String, Long>();
    private final Map<String, Long> resourceChangeTimes = new ConcurrentHashMap<String, Long>();
    private final long agentStart;
    private final String web;
    private final String srcs;
    private final String classes;
    private final String uri;
    private final String password;

    public AgentRunner(String web, String srcs, String classes, String uri, String password) {
        this.web = web;
        this.srcs = srcs;
        this.classes = classes;
        this.uri = uri;
        this.password = password;
        this.agentStart = ManagementFactory.getRuntimeMXBean().getStartTime();
    }

    public void run() {
        try {
            final Session session = ContainerProvider.getWebSocketContainer().connectToServer((Endpoint)this, ClientEndpointConfig.Builder.create().configurator(new ClientEndpointConfig.Configurator(){

                public void beforeRequest(Map<String, List<String>> headers) {
                    headers.put(AgentRunner.REMOTE_PASSWORD, Collections.singletonList(AgentRunner.this.password));
                }
            }).build(), new URI(this.uri));
            Timer timer = new Timer("Websocket ping timer");
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        session.getAsyncRemote().sendPing(ByteBuffer.allocate(0));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }, 10000L, 10000L);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    protected Map<String, byte[]> changedSrcs() {
        HashMap<String, byte[]> found = new HashMap<String, byte[]>();
        if (this.srcs != null) {
            try {
                this.scanForProgramChanges("", new File(this.srcs), found);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        return found;
    }

    @Override
    protected Map<String, byte[]> changedWebResources() {
        HashMap<String, byte[]> found = new HashMap<String, byte[]>();
        if (this.web != null) {
            try {
                this.scanForWebResources("", new File(this.web), found);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        return found;
    }

    @Override
    protected void logMessage(String message) {
        System.out.println(message);
    }

    @Override
    protected void error(Throwable t) {
        t.printStackTrace();
        System.exit(1);
    }

    @Override
    protected void done() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.run();
    }

    private void scanForWebResources(String currentPath, File root, Map<String, byte[]> found) throws IOException {
        File serverCurrent = new File(root, currentPath);
        for (String part : serverCurrent.list()) {
            String fullPart = (currentPath.isEmpty() ? "" : currentPath + File.separatorChar) + part;
            File f = new File(serverCurrent, part);
            if (f.isDirectory()) {
                this.scanForWebResources(fullPart, root, found);
                continue;
            }
            File localFile = new File(serverCurrent, part);
            Long recordedChange = this.resourceChangeTimes.get(fullPart);
            long lastModified = localFile.lastModified();
            if (recordedChange == null) {
                recordedChange = this.agentStart;
            }
            if (recordedChange >= lastModified) continue;
            found.put(fullPart, this.readFile(localFile));
            this.resourceChangeTimes.put(fullPart, lastModified);
        }
    }

    private void scanForProgramChanges(String currentPath, File root, Map<String, byte[]> found) throws IOException {
        File serverCurrent = new File(root, currentPath);
        for (String part : serverCurrent.list()) {
            String fullPart = (currentPath.isEmpty() ? "" : currentPath + File.separatorChar) + part;
            File f = new File(serverCurrent, part);
            if (f.isDirectory()) {
                this.scanForProgramChanges(fullPart, root, found);
                continue;
            }
            if (!part.contains(".")) continue;
            File localFile = new File(serverCurrent, part);
            String fullPartAsClassFile = fullPart.substring(0, fullPart.lastIndexOf(46)) + ".class";
            Long recordedChange = this.classChangeTimes.get(fullPartAsClassFile);
            long lastModified = localFile.lastModified();
            if (recordedChange == null) {
                recordedChange = this.agentStart;
            }
            System.out.println("file " + localFile + " " + recordedChange + " " + lastModified);
            if (recordedChange >= lastModified) continue;
            found.put(fullPart, this.readFile(localFile));
            this.classChangeTimes.put(fullPartAsClassFile, lastModified);
        }
    }

    private byte[] readFile(File localFile) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (FileInputStream in = new FileInputStream(localFile);){
            int r;
            byte[] buf = new byte[1024];
            while ((r = in.read(buf)) > 0) {
                out.write(buf, 0, r);
            }
        }
        return out.toByteArray();
    }
}

