/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands;

import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.CreateJBangProjectCommandHandler;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.codegen.CreateProjectHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CreateJBangProject {
    public static final String NAME = "create-jbang";
    private final QuarkusProject quarkusProject;
    private Set<String> extensions = new HashSet<String>();
    private Map<String, Object> values = new HashMap<String, Object>();
    private String javaVersion;

    public CreateJBangProject(QuarkusProject quarkusProject) {
        this.quarkusProject = Objects.requireNonNull(quarkusProject, "quarkusProject is required");
    }

    public CreateJBangProject extensions(Set<String> extensions) {
        if (extensions == null) {
            return this;
        }
        this.extensions.addAll(extensions);
        return this;
    }

    public CreateJBangProject javaTarget(String javaVersion) {
        this.javaVersion = javaVersion;
        return this;
    }

    public CreateJBangProject setValue(String name, Object value) {
        if (value != null) {
            this.values.put(name, value);
        }
        return this;
    }

    public QuarkusCommandOutcome execute() throws QuarkusCommandException {
        this.setValue("extensions", this.extensions);
        CreateProjectHelper.setJavaVersion(this.values, this.javaVersion);
        QuarkusCommandInvocation invocation = new QuarkusCommandInvocation(this.quarkusProject, this.values);
        return new CreateJBangProjectCommandHandler().execute(invocation);
    }
}

