/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandler;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandlers;
import io.quarkus.devtools.messagewriter.MessageIcons;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class RemoveExtensionsCommandHandler
implements QuarkusCommandHandler {
    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        Set<String> extensionsQuery = invocation.getValue("quarkus.remove-extensions.extensions", Collections.emptySet());
        if (extensionsQuery.isEmpty()) {
            return (QuarkusCommandOutcome)QuarkusCommandOutcome.success().setValue("quarkus.remove-extensions.outcome-updated", false);
        }
        List<ArtifactCoords> extensionsToRemove = QuarkusCommandHandlers.computeCoordsFromQuery(invocation, extensionsQuery);
        if (extensionsToRemove == null) {
            return (QuarkusCommandOutcome)new QuarkusCommandOutcome(false).setValue("quarkus.remove-extensions.outcome-updated", false);
        }
        ExtensionManager extensionManager = invocation.getValue("quarkus.remove-extensions.extension-manager", invocation.getQuarkusProject().getExtensionManager());
        try {
            Set<ArtifactKey> keys = extensionsToRemove.stream().map(ArtifactCoords::getKey).collect(Collectors.toSet());
            ExtensionManager.UninstallResult result = extensionManager.uninstall(keys);
            result.getUninstalled().forEach(a -> invocation.log().info(MessageIcons.SUCCESS_ICON + " Extension " + a.getGroupId() + ":" + a.getArtifactId() + " has been uninstalled"));
            return (QuarkusCommandOutcome)new QuarkusCommandOutcome(true).setValue("quarkus.remove-extensions.outcome-updated", result.isSourceUpdated());
        }
        catch (IOException e) {
            throw new QuarkusCommandException("Failed to remove extensions", e);
        }
    }
}

